/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.AbstractCharCollection;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.CharArrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.CharCollection;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.CharConsumer;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.CharIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.CharIterators;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.CharList;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.CharListIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.CharSpliterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.chars.CharSpliterators;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;

public abstract class AbstractCharList
extends AbstractCharCollection
implements CharList {
    protected AbstractCharList() {
    }

    protected void ensureIndex(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    @Override
    public void add(int n2, char c2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(char c2) {
        this.add(this.size(), c2);
        return true;
    }

    @Override
    public char removeChar(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public char set(int n2, char c2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int n2, Collection<? extends Character> collection) {
        if (collection instanceof CharCollection) {
            return this.addAll(n2, (CharCollection)collection);
        }
        this.ensureIndex(n2);
        Iterator<? extends Character> iterator = collection.iterator();
        boolean bl2 = iterator.hasNext();
        while (iterator.hasNext()) {
            this.add(n2++, iterator.next().charValue());
        }
        return bl2;
    }

    @Override
    public boolean addAll(Collection<? extends Character> collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public CharListIterator iterator() {
        return this.listIterator();
    }

    @Override
    public CharListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public CharListIterator listIterator(int n2) {
        this.ensureIndex(n2);
        return new CharIterators.AbstractIndexBasedListIterator(0, n2){

            @Override
            protected final char get(int n2) {
                return AbstractCharList.this.getChar(n2);
            }

            @Override
            protected final void add(int n2, char c2) {
                AbstractCharList.this.add(n2, c2);
            }

            @Override
            protected final void set(int n2, char c2) {
                AbstractCharList.this.set(n2, c2);
            }

            @Override
            protected final void remove(int n2) {
                AbstractCharList.this.removeChar(n2);
            }

            @Override
            protected final int getMaxPos() {
                return AbstractCharList.this.size();
            }
        };
    }

    @Override
    public boolean contains(char c2) {
        return this.indexOf(c2) >= 0;
    }

    @Override
    public int indexOf(char c2) {
        CharListIterator charListIterator = this.listIterator();
        while (charListIterator.hasNext()) {
            char c3 = charListIterator.nextChar();
            if (c2 != c3) continue;
            return charListIterator.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(char c2) {
        CharListIterator charListIterator = this.listIterator(this.size());
        while (charListIterator.hasPrevious()) {
            char c3 = charListIterator.previousChar();
            if (c2 != c3) continue;
            return charListIterator.nextIndex();
        }
        return -1;
    }

    @Override
    public CharList subList(int n2, int n3) {
        this.ensureIndex(n2);
        this.ensureIndex(n3);
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
        }
        return this instanceof RandomAccess ? new CharRandomAccessSubList(this, n2, n3) : new CharSubList(this, n2, n3);
    }

    @Override
    public void forEach(CharConsumer charConsumer) {
        if (this instanceof RandomAccess) {
            int n2 = this.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                charConsumer.accept(this.getChar(i2));
            }
        } else {
            CharList.super.forEach(charConsumer);
        }
    }

    @Override
    public void removeElements(int n2, int n3) {
        this.ensureIndex(n3);
        CharListIterator charListIterator = this.listIterator(n2);
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw new IllegalArgumentException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
        }
        while (n4-- != 0) {
            charListIterator.nextChar();
            charListIterator.remove();
        }
    }

    @Override
    public void getElements(int n2, char[] cArray, int n3, int n4) {
        this.ensureIndex(n2);
        CharArrays.ensureOffsetLength(cArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        if (this instanceof RandomAccess) {
            int n5 = n2;
            while (n4-- != 0) {
                cArray[n3++] = this.getChar(n5++);
            }
        } else {
            CharListIterator charListIterator = this.listIterator(n2);
            while (n4-- != 0) {
                cArray[n3++] = charListIterator.nextChar();
            }
        }
    }

    @Override
    public void setElements(int n2, char[] cArray, int n3, int n4) {
        this.ensureIndex(n2);
        CharArrays.ensureOffsetLength(cArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        if (this instanceof RandomAccess) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.set(i2 + n2, cArray[i2 + n3]);
            }
        } else {
            CharListIterator charListIterator = this.listIterator(n2);
            int n5 = 0;
            while (n5 < n4) {
                charListIterator.nextChar();
                charListIterator.set(cArray[n3 + n5++]);
            }
        }
    }

    @Override
    public void clear() {
        this.removeElements(0, this.size());
    }

    @Override
    public int hashCode() {
        CharListIterator charListIterator = this.iterator();
        int n2 = 1;
        int n3 = this.size();
        while (n3-- != 0) {
            char c2 = charListIterator.nextChar();
            n2 = 31 * n2 + c2;
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        int n2 = this.size();
        if (n2 != list.size()) {
            return false;
        }
        if (list instanceof CharList) {
            CharListIterator charListIterator = this.listIterator();
            CharListIterator charListIterator2 = ((CharList)list).listIterator();
            while (n2-- != 0) {
                if (charListIterator.nextChar() == charListIterator2.nextChar()) continue;
                return false;
            }
            return true;
        }
        CharListIterator charListIterator = this.listIterator();
        ListIterator listIterator = list.listIterator();
        while (n2-- != 0) {
            if (Objects.equals(charListIterator.next(), listIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(List<? extends Character> list) {
        if (list == this) {
            return 0;
        }
        if (list instanceof CharList) {
            CharListIterator charListIterator = this.listIterator();
            CharListIterator charListIterator2 = ((CharList)list).listIterator();
            while (charListIterator.hasNext() && charListIterator2.hasNext()) {
                char c2;
                char c3 = charListIterator.nextChar();
                int n2 = Character.compare(c3, c2 = charListIterator2.nextChar());
                if (n2 == 0) continue;
                return n2;
            }
            return charListIterator2.hasNext() ? -1 : (charListIterator.hasNext() ? 1 : 0);
        }
        CharListIterator charListIterator = this.listIterator();
        ListIterator<? extends Character> listIterator = list.listIterator();
        while (charListIterator.hasNext() && listIterator.hasNext()) {
            int n3 = ((Comparable)charListIterator.next()).compareTo(listIterator.next());
            if (n3 == 0) continue;
            return n3;
        }
        return listIterator.hasNext() ? -1 : (charListIterator.hasNext() ? 1 : 0);
    }

    @Override
    public boolean rem(char c2) {
        int n2 = this.indexOf(c2);
        if (n2 == -1) {
            return false;
        }
        this.removeChar(n2);
        return true;
    }

    @Override
    public char[] toCharArray() {
        int n2 = this.size();
        if (n2 == 0) {
            return CharArrays.EMPTY_ARRAY;
        }
        char[] cArray = new char[n2];
        this.getElements(0, cArray, 0, n2);
        return cArray;
    }

    public boolean addAll(int n2, CharCollection charCollection) {
        this.ensureIndex(n2);
        CharIterator charIterator = charCollection.iterator();
        boolean bl2 = charIterator.hasNext();
        while (charIterator.hasNext()) {
            this.add(n2++, charIterator.nextChar());
        }
        return bl2;
    }

    @Override
    public boolean addAll(CharCollection charCollection) {
        return this.addAll(this.size(), charCollection);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        CharListIterator charListIterator = this.iterator();
        int n2 = this.size();
        boolean bl2 = true;
        stringBuilder.append("[");
        while (n2-- != 0) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(", ");
            }
            char c2 = charListIterator.nextChar();
            stringBuilder.append(String.valueOf(c2));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static class CharRandomAccessSubList
    extends CharSubList
    implements RandomAccess {
        public CharRandomAccessSubList(CharList charList, int n2, int n3) {
            super(charList, n2, n3);
        }

        @Override
        public CharList subList(int n2, int n3) {
            this.ensureIndex(n2);
            this.ensureIndex(n3);
            if (n2 > n3) {
                throw new IllegalArgumentException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
            }
            return new CharRandomAccessSubList(this, n2, n3);
        }
    }

    public static class CharSubList
    extends AbstractCharList
    implements Serializable {
        protected final CharList l;
        protected final int from;
        protected int to;

        public CharSubList(CharList charList, int n2, int n3) {
            this.l = charList;
            this.from = n2;
            this.to = n3;
        }

        private boolean assertRange() {
            assert (this.from <= this.l.size());
            assert (this.to <= this.l.size());
            assert (this.to >= this.from);
            return true;
        }

        @Override
        public boolean add(char c2) {
            this.l.add(this.to, c2);
            ++this.to;
            assert (this.assertRange());
            return true;
        }

        @Override
        public void add(int n2, char c2) {
            this.ensureIndex(n2);
            this.l.add(this.from + n2, c2);
            ++this.to;
            assert (this.assertRange());
        }

        @Override
        public boolean addAll(int n2, Collection<? extends Character> collection) {
            this.ensureIndex(n2);
            this.to += collection.size();
            return this.l.addAll(this.from + n2, collection);
        }

        @Override
        public char getChar(int n2) {
            this.ensureRestrictedIndex(n2);
            return this.l.getChar(this.from + n2);
        }

        @Override
        public char removeChar(int n2) {
            this.ensureRestrictedIndex(n2);
            --this.to;
            return this.l.removeChar(this.from + n2);
        }

        @Override
        public char set(int n2, char c2) {
            this.ensureRestrictedIndex(n2);
            return this.l.set(this.from + n2, c2);
        }

        @Override
        public int size() {
            return this.to - this.from;
        }

        @Override
        public void getElements(int n2, char[] cArray, int n3, int n4) {
            this.ensureIndex(n2);
            if (n2 + n4 > this.size()) {
                throw new IndexOutOfBoundsException("End index (" + n2 + n4 + ") is greater than list size (" + this.size() + ")");
            }
            this.l.getElements(this.from + n2, cArray, n3, n4);
        }

        @Override
        public void removeElements(int n2, int n3) {
            this.ensureIndex(n2);
            this.ensureIndex(n3);
            this.l.removeElements(this.from + n2, this.from + n3);
            this.to -= n3 - n2;
            assert (this.assertRange());
        }

        @Override
        public void setElements(int n2, char[] cArray, int n3, int n4) {
            this.ensureIndex(n2);
            this.l.setElements(this.from + n2, cArray, n3, n4);
            assert (this.assertRange());
        }

        @Override
        public CharListIterator listIterator(int n2) {
            this.ensureIndex(n2);
            return this.l instanceof RandomAccess ? new RandomAccessIter(n2) : new ParentWrappingIter(this.l.listIterator(n2 + this.from));
        }

        @Override
        public CharSpliterator spliterator() {
            return this.l instanceof RandomAccess ? new IndexBasedSpliterator(this.l, this.from, this.to) : super.spliterator();
        }

        @Override
        public CharList subList(int n2, int n3) {
            this.ensureIndex(n2);
            this.ensureIndex(n3);
            if (n2 > n3) {
                throw new IllegalArgumentException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
            }
            return new CharSubList(this, n2, n3);
        }

        @Override
        public boolean rem(char c2) {
            int n2 = this.indexOf(c2);
            if (n2 == -1) {
                return false;
            }
            --this.to;
            this.l.removeChar(this.from + n2);
            assert (this.assertRange());
            return true;
        }

        @Override
        public boolean addAll(int n2, CharCollection charCollection) {
            this.ensureIndex(n2);
            return super.addAll(n2, charCollection);
        }

        private final class RandomAccessIter
        extends CharIterators.AbstractIndexBasedListIterator {
            RandomAccessIter(int n2) {
                super(0, n2);
            }

            @Override
            protected final char get(int n2) {
                return CharSubList.this.l.getChar(CharSubList.this.from + n2);
            }

            @Override
            protected final void add(int n2, char c2) {
                CharSubList.this.add(n2, c2);
            }

            @Override
            protected final void set(int n2, char c2) {
                CharSubList.this.set(n2, c2);
            }

            @Override
            protected final void remove(int n2) {
                CharSubList.this.removeChar(n2);
            }

            @Override
            protected final int getMaxPos() {
                return CharSubList.this.to - CharSubList.this.from;
            }

            @Override
            public void add(char c2) {
                super.add(c2);
                assert (CharSubList.this.assertRange());
            }

            @Override
            public void remove() {
                super.remove();
                assert (CharSubList.this.assertRange());
            }
        }

        private class ParentWrappingIter
        implements CharListIterator {
            private CharListIterator parent;

            ParentWrappingIter(CharListIterator charListIterator) {
                this.parent = charListIterator;
            }

            @Override
            public int nextIndex() {
                return this.parent.nextIndex() - CharSubList.this.from;
            }

            @Override
            public int previousIndex() {
                return this.parent.previousIndex() - CharSubList.this.from;
            }

            @Override
            public boolean hasNext() {
                return this.parent.nextIndex() < CharSubList.this.to;
            }

            @Override
            public boolean hasPrevious() {
                return this.parent.previousIndex() >= CharSubList.this.from;
            }

            @Override
            public char nextChar() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.parent.nextChar();
            }

            @Override
            public char previousChar() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                return this.parent.previousChar();
            }

            @Override
            public void add(char c2) {
                this.parent.add(c2);
            }

            @Override
            public void set(char c2) {
                this.parent.set(c2);
            }

            @Override
            public void remove() {
                this.parent.remove();
            }
        }
    }

    static final class IndexBasedSpliterator
    extends CharSpliterators.LateBindingSizeIndexBasedSpliterator {
        final CharList l;

        IndexBasedSpliterator(CharList charList, int n2) {
            super(n2);
            this.l = charList;
        }

        IndexBasedSpliterator(CharList charList, int n2, int n3) {
            super(n2, n3);
            this.l = charList;
        }

        @Override
        protected final int getMaxPosFromBackingStore() {
            return this.l.size();
        }

        @Override
        protected final char get(int n2) {
            return this.l.getChar(n2);
        }

        @Override
        protected final IndexBasedSpliterator makeForSplit(int n2, int n3) {
            return new IndexBasedSpliterator(this.l, n2, n3);
        }
    }
}

