/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.booleans;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.Arrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.Hash;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.booleans.BooleanComparator;
import java.io.Serializable;

public final class BooleanArrays {
    public static final boolean[] EMPTY_ARRAY = new boolean[0];
    public static final boolean[] DEFAULT_EMPTY_ARRAY = new boolean[0];
    public static final Hash.Strategy<boolean[]> HASH_STRATEGY = new ArrayHashStrategy();

    public static void ensureOffsetLength(boolean[] blArray, int n2, int n3) {
        Arrays.ensureOffsetLength(blArray.length, n2, n3);
    }

    public static void swap(boolean[] blArray, int n2, int n3) {
        boolean bl2 = blArray[n2];
        blArray[n2] = blArray[n3];
        blArray[n3] = bl2;
    }

    public static void swap(boolean[] blArray, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            BooleanArrays.swap(blArray, n2, n3);
            ++n5;
            ++n2;
            ++n3;
        }
    }

    private static int med3(boolean[] blArray, int n2, int n3, int n4, BooleanComparator booleanComparator) {
        int n5 = booleanComparator.compare(blArray[n2], blArray[n3]);
        int n6 = booleanComparator.compare(blArray[n2], blArray[n4]);
        int n7 = booleanComparator.compare(blArray[n3], blArray[n4]);
        return n5 < 0 ? (n7 < 0 ? n3 : (n6 < 0 ? n4 : n2)) : (n7 > 0 ? n3 : (n6 > 0 ? n4 : n2));
    }

    private static void selectionSort(boolean[] blArray, int n2, int n3, BooleanComparator booleanComparator) {
        for (int i2 = n2; i2 < n3 - 1; ++i2) {
            int n4;
            int n5 = i2;
            for (n4 = i2 + 1; n4 < n3; ++n4) {
                if (booleanComparator.compare(blArray[n4], blArray[n5]) >= 0) continue;
                n5 = n4;
            }
            if (n5 == i2) continue;
            n4 = blArray[i2];
            blArray[i2] = blArray[n5];
            blArray[n5] = n4;
        }
    }

    private static void insertionSort(boolean[] blArray, int n2, int n3, BooleanComparator booleanComparator) {
        int n4 = n2;
        while (++n4 < n3) {
            boolean bl2 = blArray[n4];
            int n5 = n4;
            boolean bl3 = blArray[n5 - 1];
            while (booleanComparator.compare(bl2, bl3) < 0) {
                blArray[n5] = bl3;
                if (n2 == n5 - 1) {
                    --n5;
                    break;
                }
                bl3 = blArray[--n5 - 1];
            }
            blArray[n5] = bl2;
        }
    }

    public static void quickSort(boolean[] blArray, int n2, int n3, BooleanComparator booleanComparator) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = n3 - n2;
        if (n8 < 16) {
            BooleanArrays.selectionSort(blArray, n2, n3, booleanComparator);
            return;
        }
        int n9 = n2 + n8 / 2;
        int n10 = n2;
        int n11 = n3 - 1;
        if (n8 > 128) {
            n7 = n8 / 8;
            n10 = BooleanArrays.med3(blArray, n10, n10 + n7, n10 + 2 * n7, booleanComparator);
            n9 = BooleanArrays.med3(blArray, n9 - n7, n9, n9 + n7, booleanComparator);
            n11 = BooleanArrays.med3(blArray, n11 - 2 * n7, n11 - n7, n11, booleanComparator);
        }
        n9 = BooleanArrays.med3(blArray, n10, n9, n11, booleanComparator);
        n7 = blArray[n9];
        int n12 = n6 = n2;
        int n13 = n5 = n3 - 1;
        while (true) {
            if (n12 <= n5 && (n4 = booleanComparator.compare(blArray[n12], n7 != 0)) <= 0) {
                if (n4 == 0) {
                    BooleanArrays.swap(blArray, n6++, n12);
                }
                ++n12;
                continue;
            }
            while (n5 >= n12 && (n4 = booleanComparator.compare(blArray[n5], n7 != 0)) >= 0) {
                if (n4 == 0) {
                    BooleanArrays.swap(blArray, n5, n13--);
                }
                --n5;
            }
            if (n12 > n5) break;
            BooleanArrays.swap(blArray, n12++, n5--);
        }
        n4 = Math.min(n6 - n2, n12 - n6);
        BooleanArrays.swap(blArray, n2, n12 - n4, n4);
        n4 = Math.min(n13 - n5, n3 - n13 - 1);
        BooleanArrays.swap(blArray, n12, n3 - n4, n4);
        n4 = n12 - n6;
        if (n4 > 1) {
            BooleanArrays.quickSort(blArray, n2, n2 + n4, booleanComparator);
        }
        if ((n4 = n13 - n5) > 1) {
            BooleanArrays.quickSort(blArray, n3 - n4, n3, booleanComparator);
        }
    }

    private static int med3(boolean[] blArray, int n2, int n3, int n4) {
        int n5 = Boolean.compare(blArray[n2], blArray[n3]);
        int n6 = Boolean.compare(blArray[n2], blArray[n4]);
        int n7 = Boolean.compare(blArray[n3], blArray[n4]);
        return n5 < 0 ? (n7 < 0 ? n3 : (n6 < 0 ? n4 : n2)) : (n7 > 0 ? n3 : (n6 > 0 ? n4 : n2));
    }

    private static void selectionSort(boolean[] blArray, int n2, int n3) {
        for (int i2 = n2; i2 < n3 - 1; ++i2) {
            int n4;
            int n5 = i2;
            for (n4 = i2 + 1; n4 < n3; ++n4) {
                if (blArray[n4] || !blArray[n5]) continue;
                n5 = n4;
            }
            if (n5 == i2) continue;
            n4 = blArray[i2];
            blArray[i2] = blArray[n5];
            blArray[n5] = n4;
        }
    }

    public static void quickSort(boolean[] blArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = n3 - n2;
        if (n8 < 16) {
            BooleanArrays.selectionSort(blArray, n2, n3);
            return;
        }
        int n9 = n2 + n8 / 2;
        int n10 = n2;
        int n11 = n3 - 1;
        if (n8 > 128) {
            n7 = n8 / 8;
            n10 = BooleanArrays.med3(blArray, n10, n10 + n7, n10 + 2 * n7);
            n9 = BooleanArrays.med3(blArray, n9 - n7, n9, n9 + n7);
            n11 = BooleanArrays.med3(blArray, n11 - 2 * n7, n11 - n7, n11);
        }
        n9 = BooleanArrays.med3(blArray, n10, n9, n11);
        n7 = blArray[n9];
        int n12 = n6 = n2;
        int n13 = n5 = n3 - 1;
        while (true) {
            if (n12 <= n5 && (n4 = Boolean.compare(blArray[n12], n7 != 0)) <= 0) {
                if (n4 == 0) {
                    BooleanArrays.swap(blArray, n6++, n12);
                }
                ++n12;
                continue;
            }
            while (n5 >= n12 && (n4 = Boolean.compare(blArray[n5], n7 != 0)) >= 0) {
                if (n4 == 0) {
                    BooleanArrays.swap(blArray, n5, n13--);
                }
                --n5;
            }
            if (n12 > n5) break;
            BooleanArrays.swap(blArray, n12++, n5--);
        }
        n4 = Math.min(n6 - n2, n12 - n6);
        BooleanArrays.swap(blArray, n2, n12 - n4, n4);
        n4 = Math.min(n13 - n5, n3 - n13 - 1);
        BooleanArrays.swap(blArray, n12, n3 - n4, n4);
        n4 = n12 - n6;
        if (n4 > 1) {
            BooleanArrays.quickSort(blArray, n2, n2 + n4);
        }
        if ((n4 = n13 - n5) > 1) {
            BooleanArrays.quickSort(blArray, n3 - n4, n3);
        }
    }

    public static void unstableSort(boolean[] blArray, int n2, int n3) {
        BooleanArrays.quickSort(blArray, n2, n3);
    }

    public static void unstableSort(boolean[] blArray) {
        BooleanArrays.unstableSort(blArray, 0, blArray.length);
    }

    public static void unstableSort(boolean[] blArray, int n2, int n3, BooleanComparator booleanComparator) {
        BooleanArrays.quickSort(blArray, n2, n3, booleanComparator);
    }

    public static void unstableSort(boolean[] blArray, BooleanComparator booleanComparator) {
        BooleanArrays.unstableSort(blArray, 0, blArray.length, booleanComparator);
    }

    public static void mergeSort(boolean[] blArray, int n2, int n3, BooleanComparator booleanComparator, boolean[] blArray2) {
        int n4 = n3 - n2;
        if (n4 < 16) {
            BooleanArrays.insertionSort(blArray, n2, n3, booleanComparator);
            return;
        }
        if (blArray2 == null) {
            blArray2 = java.util.Arrays.copyOf(blArray, n3);
        }
        int n5 = n2 + n3 >>> 1;
        BooleanArrays.mergeSort(blArray2, n2, n5, booleanComparator, blArray);
        BooleanArrays.mergeSort(blArray2, n5, n3, booleanComparator, blArray);
        if (booleanComparator.compare(blArray2[n5 - 1], blArray2[n5]) <= 0) {
            System.arraycopy(blArray2, n2, blArray, n2, n4);
            return;
        }
        int n6 = n2;
        int n7 = n5;
        for (int i2 = n2; i2 < n3; ++i2) {
            blArray[i2] = n7 >= n3 || n6 < n5 && booleanComparator.compare(blArray2[n6], blArray2[n7]) <= 0 ? blArray2[n6++] : blArray2[n7++];
        }
    }

    public static void mergeSort(boolean[] blArray, int n2, int n3, BooleanComparator booleanComparator) {
        BooleanArrays.mergeSort(blArray, n2, n3, booleanComparator, null);
    }

    public static void stableSort(boolean[] blArray, int n2, int n3, BooleanComparator booleanComparator) {
        BooleanArrays.mergeSort(blArray, n2, n3, booleanComparator);
    }

    public static void stableSort(boolean[] blArray, BooleanComparator booleanComparator) {
        BooleanArrays.stableSort(blArray, 0, blArray.length, booleanComparator);
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<boolean[]>,
    Serializable {
        private ArrayHashStrategy() {
        }
    }
}

