/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.util.concurrent;

import com.gradle.maven.extension.internal.dep.io.netty.util.internal.MathUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.IntSupplier;

public interface MpscIntQueue {
    public static MpscIntQueue create(int n2, int n3) {
        return new MpscAtomicIntegerArrayQueue(n2, n3);
    }

    public boolean offer(int var1);

    public int poll();

    public int fill(int var1, IntSupplier var2);

    public int size();

    public static final class MpscAtomicIntegerArrayQueue
    extends AtomicIntegerArray
    implements MpscIntQueue {
        private static final AtomicLongFieldUpdater<MpscAtomicIntegerArrayQueue> PRODUCER_INDEX = AtomicLongFieldUpdater.newUpdater(MpscAtomicIntegerArrayQueue.class, "producerIndex");
        private static final AtomicLongFieldUpdater<MpscAtomicIntegerArrayQueue> PRODUCER_LIMIT = AtomicLongFieldUpdater.newUpdater(MpscAtomicIntegerArrayQueue.class, "producerLimit");
        private static final AtomicLongFieldUpdater<MpscAtomicIntegerArrayQueue> CONSUMER_INDEX = AtomicLongFieldUpdater.newUpdater(MpscAtomicIntegerArrayQueue.class, "consumerIndex");
        private final int mask;
        private final int emptyValue;
        private volatile long producerIndex;
        private volatile long producerLimit;
        private volatile long consumerIndex;

        public MpscAtomicIntegerArrayQueue(int n2, int n3) {
            super(MathUtil.safeFindNextPositivePowerOfTwo(n2));
            if (n3 != 0) {
                this.emptyValue = n3;
                int n4 = this.length() - 1;
                for (int i2 = 0; i2 < n4; ++i2) {
                    this.lazySet(i2, n3);
                }
                this.getAndSet(n4, n3);
            } else {
                this.emptyValue = 0;
            }
            this.mask = this.length() - 1;
        }

        @Override
        public boolean offer(int n2) {
            long l2;
            if (n2 == this.emptyValue) {
                throw new IllegalArgumentException("Cannot offer the \"empty\" value: " + this.emptyValue);
            }
            int n3 = this.mask;
            long l3 = this.producerLimit;
            do {
                if ((l2 = this.producerIndex) < l3) continue;
                long l4 = this.consumerIndex;
                l3 = l4 + (long)n3 + 1L;
                if (l2 >= l3) {
                    return false;
                }
                PRODUCER_LIMIT.lazySet(this, l3);
            } while (!PRODUCER_INDEX.compareAndSet(this, l2, l2 + 1L));
            int n4 = (int)(l2 & (long)n3);
            this.lazySet(n4, n2);
            return true;
        }

        @Override
        public int poll() {
            long l2 = this.consumerIndex;
            int n2 = (int)(l2 & (long)this.mask);
            int n3 = this.get(n2);
            if (this.emptyValue == n3) {
                if (l2 != this.producerIndex) {
                    while (this.emptyValue == (n3 = this.get(n2))) {
                    }
                } else {
                    return this.emptyValue;
                }
            }
            this.lazySet(n2, this.emptyValue);
            CONSUMER_INDEX.lazySet(this, l2 + 1L);
            return n3;
        }

        @Override
        public int fill(int n2, IntSupplier intSupplier) {
            long l2;
            int n3;
            long l3;
            Objects.requireNonNull(intSupplier, "supplier");
            ObjectUtil.checkPositiveOrZero(n2, "limit");
            if (n2 == 0) {
                return 0;
            }
            int n4 = this.mask;
            long l4 = n4 + 1;
            long l5 = this.producerLimit;
            do {
                if ((l2 = l5 - (l3 = this.producerIndex)) > 0L) continue;
                long l6 = this.consumerIndex;
                l5 = l6 + l4;
                l2 = l5 - l3;
                if (l2 <= 0L) {
                    return 0;
                }
                PRODUCER_LIMIT.lazySet(this, l5);
            } while (!PRODUCER_INDEX.compareAndSet(this, l3, l3 + (long)(n3 = Math.min((int)l2, n2))));
            for (int i2 = 0; i2 < n3; ++i2) {
                int n5 = (int)(l3 + (long)i2 & (long)n4);
                this.lazySet(n5, intSupplier.getAsInt());
            }
            return n3;
        }

        @Override
        public int size() {
            long l2;
            long l3;
            long l4 = this.consumerIndex;
            do {
                l3 = l4;
                l2 = this.producerIndex;
            } while (l3 != (l4 = this.consumerIndex));
            long l5 = l2 - l4;
            return l5 < 0L ? 0 : (l5 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l5);
        }
    }
}

