/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.util.collection;

import com.gradle.maven.extension.internal.dep.io.netty.util.collection.IntObjectMap;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.MathUtil;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IntObjectHashMap<V>
implements IntObjectMap<V> {
    private static final Object NULL_VALUE = new Object();
    private int maxSize;
    private final float loadFactor;
    private int[] keys;
    private V[] values;
    private int size;
    private int mask;
    private final Set<Integer> keySet = new KeySet();
    private final Set<Map.Entry<Integer, V>> entrySet = new EntrySet();
    private final Iterable<IntObjectMap.PrimitiveEntry<V>> entries = new Iterable<IntObjectMap.PrimitiveEntry<V>>(){

        @Override
        public Iterator<IntObjectMap.PrimitiveEntry<V>> iterator() {
            return new PrimitiveIterator();
        }
    };

    public IntObjectHashMap() {
        this(8, 0.5f);
    }

    public IntObjectHashMap(int n2, float f2) {
        if (f2 <= 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1");
        }
        this.loadFactor = f2;
        int n3 = MathUtil.safeFindNextPositivePowerOfTwo(n2);
        this.mask = n3 - 1;
        this.keys = new int[n3];
        Object[] objectArray = new Object[n3];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n3);
    }

    private static <T> T toExternal(T t2) {
        assert (t2 != null) : "null is not a legitimate internal value. Concurrent Modification?";
        return t2 == NULL_VALUE ? null : (T)t2;
    }

    private static <T> T toInternal(T t2) {
        return (T)(t2 == null ? NULL_VALUE : t2);
    }

    @Override
    public V get(int n2) {
        int n3 = this.indexOf(n2);
        return n3 == -1 ? null : (V)IntObjectHashMap.toExternal(this.values[n3]);
    }

    @Override
    public V put(int n2, V v2) {
        int n3;
        int n4 = n3 = this.hashIndex(n2);
        do {
            if (this.values[n4] == null) {
                this.keys[n4] = n2;
                this.values[n4] = IntObjectHashMap.toInternal(v2);
                this.growSize();
                return null;
            }
            if (this.keys[n4] != n2) continue;
            V v3 = this.values[n4];
            this.values[n4] = IntObjectHashMap.toInternal(v2);
            return IntObjectHashMap.toExternal(v3);
        } while ((n4 = this.probeNext(n4)) != n3);
        throw new IllegalStateException("Unable to insert");
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> map) {
        if (map instanceof IntObjectHashMap) {
            IntObjectHashMap intObjectHashMap = (IntObjectHashMap)map;
            for (int i2 = 0; i2 < intObjectHashMap.values.length; ++i2) {
                V v2 = intObjectHashMap.values[i2];
                if (v2 == null) continue;
                this.put(intObjectHashMap.keys[i2], v2);
            }
            return;
        }
        for (Map.Entry<Integer, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public V remove(int n2) {
        int n3 = this.indexOf(n2);
        if (n3 == -1) {
            return null;
        }
        V v2 = this.values[n3];
        this.removeAt(n3);
        return IntObjectHashMap.toExternal(v2);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, 0);
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    public boolean containsKey(int n2) {
        return this.indexOf(n2) >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        Object object2 = IntObjectHashMap.toInternal(object);
        for (V v2 : this.values) {
            if (v2 == null || !v2.equals(object2)) continue;
            return true;
        }
        return false;
    }

    public Iterable<IntObjectMap.PrimitiveEntry<V>> entries() {
        return this.entries;
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    final PrimitiveIterator iter;
                    {
                        this.iter = new PrimitiveIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public V next() {
                        return this.iter.next().value();
                    }

                    @Override
                    public void remove() {
                        this.iter.remove();
                    }
                };
            }

            @Override
            public int size() {
                return IntObjectHashMap.this.size;
            }
        };
    }

    @Override
    public int hashCode() {
        int n2 = this.size;
        for (int n3 : this.keys) {
            n2 ^= IntObjectHashMap.hashCode(n3);
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IntObjectMap)) {
            return false;
        }
        IntObjectMap intObjectMap = (IntObjectMap)object;
        if (this.size != intObjectMap.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            V v2 = this.values[i2];
            if (v2 == null) continue;
            int n2 = this.keys[i2];
            Object v3 = intObjectMap.get(n2);
            if (!(v2 == NULL_VALUE ? v3 != null : !v2.equals(v3))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.containsKey(this.objectToKey(object));
    }

    @Override
    public V get(Object object) {
        return this.get(this.objectToKey(object));
    }

    @Override
    public V put(Integer n2, V v2) {
        return this.put(this.objectToKey(n2), v2);
    }

    @Override
    public V remove(Object object) {
        return this.remove(this.objectToKey(object));
    }

    @Override
    public Set<Integer> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<Integer, V>> entrySet() {
        return this.entrySet;
    }

    private int objectToKey(Object object) {
        return (Integer)object;
    }

    private int indexOf(int n2) {
        int n3;
        int n4 = n3 = this.hashIndex(n2);
        do {
            if (this.values[n4] == null) {
                return -1;
            }
            if (n2 != this.keys[n4]) continue;
            return n4;
        } while ((n4 = this.probeNext(n4)) != n3);
        return -1;
    }

    private int hashIndex(int n2) {
        return IntObjectHashMap.hashCode(n2) & this.mask;
    }

    private static int hashCode(int n2) {
        return n2;
    }

    private int probeNext(int n2) {
        return n2 + 1 & this.mask;
    }

    private void growSize() {
        ++this.size;
        if (this.size > this.maxSize) {
            if (this.keys.length == Integer.MAX_VALUE) {
                throw new IllegalStateException("Max capacity reached at size=" + this.size);
            }
            this.rehash(this.keys.length << 1);
        }
    }

    private boolean removeAt(int n2) {
        --this.size;
        this.keys[n2] = 0;
        this.values[n2] = null;
        int n3 = n2;
        int n4 = this.probeNext(n2);
        V v2 = this.values[n4];
        while (v2 != null) {
            int n5 = this.keys[n4];
            int n6 = this.hashIndex(n5);
            if (n4 < n6 && (n6 <= n3 || n3 <= n4) || n6 <= n3 && n3 <= n4) {
                this.keys[n3] = n5;
                this.values[n3] = v2;
                this.keys[n4] = 0;
                this.values[n4] = null;
                n3 = n4;
            }
            n4 = this.probeNext(n4);
            v2 = this.values[n4];
        }
        return n3 != n2;
    }

    private int calcMaxSize(int n2) {
        int n3 = n2 - 1;
        return Math.min(n3, (int)((float)n2 * this.loadFactor));
    }

    private void rehash(int n2) {
        int[] nArray = this.keys;
        V[] VArray = this.values;
        this.keys = new int[n2];
        Object[] objectArray = new Object[n2];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n2);
        this.mask = n2 - 1;
        block0: for (int i2 = 0; i2 < VArray.length; ++i2) {
            V v2 = VArray[i2];
            if (v2 == null) continue;
            int n3 = nArray[i2];
            int n4 = this.hashIndex(n3);
            while (true) {
                if (this.values[n4] == null) {
                    this.keys[n4] = n3;
                    this.values[n4] = v2;
                    continue block0;
                }
                n4 = this.probeNext(n4);
            }
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(4 * this.size);
        stringBuilder.append('{');
        boolean bl2 = true;
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            V v2 = this.values[i2];
            if (v2 == null) continue;
            if (!bl2) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.keyToString(this.keys[i2])).append('=').append((Object)(v2 == this ? "(this Map)" : IntObjectHashMap.toExternal(v2)));
            bl2 = false;
        }
        return stringBuilder.append('}').toString();
    }

    protected String keyToString(int n2) {
        return Integer.toString(n2);
    }

    final class MapEntry
    implements Map.Entry<Integer, V> {
        private final int entryIndex;

        MapEntry(int n2) {
            this.entryIndex = n2;
        }

        @Override
        public Integer getKey() {
            this.verifyExists();
            return IntObjectHashMap.this.keys[this.entryIndex];
        }

        @Override
        public V getValue() {
            this.verifyExists();
            return IntObjectHashMap.toExternal(IntObjectHashMap.this.values[this.entryIndex]);
        }

        @Override
        public V setValue(V v2) {
            this.verifyExists();
            Object object = IntObjectHashMap.toExternal(IntObjectHashMap.this.values[this.entryIndex]);
            ((IntObjectHashMap)IntObjectHashMap.this).values[this.entryIndex] = IntObjectHashMap.toInternal(v2);
            return object;
        }

        private void verifyExists() {
            if (IntObjectHashMap.this.values[this.entryIndex] == null) {
                throw new IllegalStateException("The map entry has been removed");
            }
        }
    }

    private final class MapIterator
    implements Iterator<Map.Entry<Integer, V>> {
        private final PrimitiveIterator iter;

        private MapIterator() {
            this.iter = new PrimitiveIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Map.Entry<Integer, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.iter.next();
            return new MapEntry(this.iter.entryIndex);
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    private final class PrimitiveIterator
    implements IntObjectMap.PrimitiveEntry<V>,
    Iterator<IntObjectMap.PrimitiveEntry<V>> {
        private int prevIndex = -1;
        private int nextIndex = -1;
        private int entryIndex = -1;

        private PrimitiveIterator() {
        }

        private void scanNext() {
            while (++this.nextIndex != IntObjectHashMap.this.values.length && IntObjectHashMap.this.values[this.nextIndex] == null) {
            }
        }

        @Override
        public boolean hasNext() {
            if (this.nextIndex == -1) {
                this.scanNext();
            }
            return this.nextIndex != IntObjectHashMap.this.values.length;
        }

        @Override
        public IntObjectMap.PrimitiveEntry<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prevIndex = this.nextIndex;
            this.scanNext();
            this.entryIndex = this.prevIndex;
            return this;
        }

        @Override
        public void remove() {
            if (this.prevIndex == -1) {
                throw new IllegalStateException("next must be called before each remove.");
            }
            if (IntObjectHashMap.this.removeAt(this.prevIndex)) {
                this.nextIndex = this.prevIndex;
            }
            this.prevIndex = -1;
        }

        @Override
        public int key() {
            return IntObjectHashMap.this.keys[this.entryIndex];
        }

        @Override
        public V value() {
            return IntObjectHashMap.toExternal(IntObjectHashMap.this.values[this.entryIndex]);
        }
    }

    private final class KeySet
    extends AbstractSet<Integer> {
        private KeySet() {
        }

        @Override
        public int size() {
            return IntObjectHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return IntObjectHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return IntObjectHashMap.this.remove(object) != null;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean bl2 = false;
            Iterator iterator = IntObjectHashMap.this.entries().iterator();
            while (iterator.hasNext()) {
                IntObjectMap.PrimitiveEntry primitiveEntry = iterator.next();
                if (collection.contains(primitiveEntry.key())) continue;
                bl2 = true;
                iterator.remove();
            }
            return bl2;
        }

        @Override
        public void clear() {
            IntObjectHashMap.this.clear();
        }

        @Override
        public Iterator<Integer> iterator() {
            return new Iterator<Integer>(){
                private final Iterator<Map.Entry<Integer, V>> iter;
                {
                    this.iter = IntObjectHashMap.this.entrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public Integer next() {
                    return this.iter.next().getKey();
                }

                @Override
                public void remove() {
                    this.iter.remove();
                }
            };
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<Integer, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Integer, V>> iterator() {
            return new MapIterator();
        }

        @Override
        public int size() {
            return IntObjectHashMap.this.size();
        }
    }
}

