/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.util;

import com.gradle.maven.extension.internal.dep.io.netty.util.Constant;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ConstantPool<T extends Constant<T>> {
    private final ConcurrentMap<String, T> constants = new ConcurrentHashMap<String, T>();
    private final AtomicInteger nextId = new AtomicInteger(1);

    public T valueOf(Class<?> clazz, String string) {
        return this.valueOf(ObjectUtil.checkNotNull(clazz, "firstNameComponent").getName() + '#' + ObjectUtil.checkNotNull(string, "secondNameComponent"));
    }

    public T valueOf(String string) {
        return this.getOrCreate(ObjectUtil.checkNonEmpty(string, "name"));
    }

    private T getOrCreate(String string) {
        T t2;
        Constant constant = (Constant)this.constants.get(string);
        if (constant == null && (constant = (Constant)this.constants.putIfAbsent(string, t2 = this.newConstant(this.nextId(), string))) == null) {
            return t2;
        }
        return (T)constant;
    }

    protected abstract T newConstant(int var1, String var2);

    @Deprecated
    public final int nextId() {
        return this.nextId.getAndIncrement();
    }
}

