/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.ssl;

import com.gradle.maven.extension.internal.dep.io.netty.handler.ssl.OpenSslAsyncPrivateKeyMethod;
import com.gradle.maven.extension.internal.dep.io.netty.internal.tcnative.SSLPrivateKeyMethod;
import com.gradle.maven.extension.internal.dep.io.netty.util.collection.IntCollections;
import com.gradle.maven.extension.internal.dep.io.netty.util.collection.IntObjectHashMap;
import com.gradle.maven.extension.internal.dep.io.netty.util.collection.IntObjectMap;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.PrivateKey;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class JdkDelegatingPrivateKeyMethod
implements SSLPrivateKeyMethod {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(JdkDelegatingPrivateKeyMethod.class);
    private static final IntObjectMap<String> SSL_TO_JDK_SIGNATURE_ALGORITHM;
    private static final ConcurrentMap<Object, String> PROVIDER_CACHE;
    private final PrivateKey privateKey;
    private final String privateKeyTypeName;

    JdkDelegatingPrivateKeyMethod(PrivateKey privateKey) {
        this.privateKey = ObjectUtil.checkNotNull(privateKey, "privateKey");
        this.privateKeyTypeName = privateKey.getClass().getName();
    }

    static {
        PROVIDER_CACHE = new ConcurrentHashMap<Object, String>();
        IntObjectHashMap<String> intObjectHashMap = new IntObjectHashMap<String>();
        intObjectHashMap.put(OpenSslAsyncPrivateKeyMethod.SSL_SIGN_RSA_PKCS1_SHA1, "SHA1withRSA");
        intObjectHashMap.put(OpenSslAsyncPrivateKeyMethod.SSL_SIGN_RSA_PKCS1_SHA256, "SHA256withRSA");
        intObjectHashMap.put(OpenSslAsyncPrivateKeyMethod.SSL_SIGN_RSA_PKCS1_SHA384, "SHA384withRSA");
        intObjectHashMap.put(OpenSslAsyncPrivateKeyMethod.SSL_SIGN_RSA_PKCS1_SHA512, "SHA512withRSA");
        intObjectHashMap.put(OpenSslAsyncPrivateKeyMethod.SSL_SIGN_RSA_PKCS1_MD5_SHA1, "MD5andSHA1withRSA");
        intObjectHashMap.put(OpenSslAsyncPrivateKeyMethod.SSL_SIGN_ECDSA_SHA1, "SHA1withECDSA");
        intObjectHashMap.put(OpenSslAsyncPrivateKeyMethod.SSL_SIGN_ECDSA_SECP256R1_SHA256, "SHA256withECDSA");
        intObjectHashMap.put(OpenSslAsyncPrivateKeyMethod.SSL_SIGN_ECDSA_SECP384R1_SHA384, "SHA384withECDSA");
        intObjectHashMap.put(OpenSslAsyncPrivateKeyMethod.SSL_SIGN_ECDSA_SECP521R1_SHA512, "SHA512withECDSA");
        intObjectHashMap.put(OpenSslAsyncPrivateKeyMethod.SSL_SIGN_RSA_PSS_RSAE_SHA256, "RSASSA-PSS");
        intObjectHashMap.put(OpenSslAsyncPrivateKeyMethod.SSL_SIGN_RSA_PSS_RSAE_SHA384, "RSASSA-PSS");
        intObjectHashMap.put(OpenSslAsyncPrivateKeyMethod.SSL_SIGN_RSA_PSS_RSAE_SHA512, "RSASSA-PSS");
        intObjectHashMap.put(OpenSslAsyncPrivateKeyMethod.SSL_SIGN_ED25519, "EdDSA");
        SSL_TO_JDK_SIGNATURE_ALGORITHM = IntCollections.unmodifiableMap(intObjectHashMap);
    }
}

