/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.Unpooled;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelFuture;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelFutureListener;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPipeline;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.DecoderResult;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.MessageAggregator;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.DefaultFullHttpResponse;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.EmptyHttpHeaders;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.FullHttpMessage;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.FullHttpRequest;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.FullHttpResponse;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpContent;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpExpectationFailedEvent;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpHeaderNames;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpHeaderValues;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpHeaders;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpMessage;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpMessageUtil;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpMethod;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpObject;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpRequest;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpResponse;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpResponseStatus;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpStatusClass;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpUtil;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpVersion;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.LastHttpContent;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.TooLongHttpContentException;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.GenericFutureListener;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.StringUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;

public class HttpObjectAggregator
extends MessageAggregator<HttpObject, HttpMessage, HttpContent, FullHttpMessage> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(HttpObjectAggregator.class);
    private static final FullHttpResponse CONTINUE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);
    private static final FullHttpResponse EXPECTATION_FAILED = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.EXPECTATION_FAILED, Unpooled.EMPTY_BUFFER);
    private static final FullHttpResponse TOO_LARGE_CLOSE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, Unpooled.EMPTY_BUFFER);
    private static final FullHttpResponse TOO_LARGE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, Unpooled.EMPTY_BUFFER);
    private final boolean closeOnExpectationFailed;

    public HttpObjectAggregator(int n2) {
        this(n2, false);
    }

    public HttpObjectAggregator(int n2, boolean bl2) {
        super(n2, HttpObject.class);
        this.closeOnExpectationFailed = bl2;
    }

    @Override
    protected boolean isStartMessage(HttpObject httpObject) throws Exception {
        return httpObject instanceof HttpMessage;
    }

    @Override
    protected boolean isContentMessage(HttpObject httpObject) throws Exception {
        return httpObject instanceof HttpContent;
    }

    @Override
    protected boolean isLastContentMessage(HttpContent httpContent) throws Exception {
        return httpContent instanceof LastHttpContent;
    }

    @Override
    protected boolean isAggregated(HttpObject httpObject) throws Exception {
        return httpObject instanceof FullHttpMessage;
    }

    @Override
    protected boolean isContentLengthInvalid(HttpMessage httpMessage, int n2) {
        try {
            return HttpUtil.getContentLength(httpMessage, -1L) > (long)n2;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private Object continueResponse(HttpMessage httpMessage, int n2, ChannelPipeline channelPipeline) {
        if (HttpUtil.isUnsupportedExpectation(httpMessage)) {
            channelPipeline.fireUserEventTriggered(HttpExpectationFailedEvent.INSTANCE);
            return EXPECTATION_FAILED.retainedDuplicate();
        }
        if (HttpUtil.is100ContinueExpected(httpMessage)) {
            if (!this.isContentLengthInvalid(httpMessage, n2)) {
                return CONTINUE.retainedDuplicate();
            }
            channelPipeline.fireUserEventTriggered(HttpExpectationFailedEvent.INSTANCE);
            return TOO_LARGE.retainedDuplicate();
        }
        return null;
    }

    @Override
    protected Object newContinueResponse(HttpMessage httpMessage, int n2, ChannelPipeline channelPipeline) {
        Object object = this.continueResponse(httpMessage, n2, channelPipeline);
        if (object != null) {
            httpMessage.headers().remove(HttpHeaderNames.EXPECT);
        }
        return object;
    }

    @Override
    protected boolean closeAfterContinueResponse(Object object) {
        return this.closeOnExpectationFailed && this.ignoreContentAfterContinueResponse(object);
    }

    @Override
    protected boolean ignoreContentAfterContinueResponse(Object object) {
        if (object instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)object;
            return httpResponse.status().codeClass().equals((Object)HttpStatusClass.CLIENT_ERROR);
        }
        return false;
    }

    @Override
    protected FullHttpMessage beginAggregation(HttpMessage httpMessage, ByteBuf byteBuf) throws Exception {
        assert (!(httpMessage instanceof FullHttpMessage));
        HttpUtil.setTransferEncodingChunked(httpMessage, false);
        if (httpMessage instanceof HttpRequest) {
            return new AggregatedFullHttpRequest((HttpRequest)httpMessage, byteBuf, null);
        }
        if (httpMessage instanceof HttpResponse) {
            return new AggregatedFullHttpResponse((HttpResponse)httpMessage, byteBuf, null);
        }
        throw new Error("Unexpected http message type: " + StringUtil.className(httpMessage));
    }

    @Override
    protected void aggregate(FullHttpMessage fullHttpMessage, HttpContent httpContent) throws Exception {
        if (httpContent instanceof LastHttpContent) {
            ((AggregatedFullHttpMessage)fullHttpMessage).setTrailingHeaders(((LastHttpContent)httpContent).trailingHeaders());
        }
    }

    @Override
    protected void finishAggregation(FullHttpMessage fullHttpMessage) throws Exception {
        if (!HttpUtil.isContentLengthSet(fullHttpMessage)) {
            fullHttpMessage.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(fullHttpMessage.content().readableBytes()));
        }
    }

    @Override
    protected void handleOversizedMessage(final ChannelHandlerContext channelHandlerContext, HttpMessage httpMessage) throws Exception {
        if (httpMessage instanceof HttpRequest) {
            if (httpMessage instanceof FullHttpMessage || !HttpUtil.is100ContinueExpected(httpMessage) && !HttpUtil.isKeepAlive(httpMessage)) {
                ChannelFuture channelFuture = channelHandlerContext.writeAndFlush(TOO_LARGE_CLOSE.retainedDuplicate());
                channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture channelFuture) throws Exception {
                        if (!channelFuture.isSuccess()) {
                            logger.debug("Failed to send a 413 Request Entity Too Large.", channelFuture.cause());
                        }
                        channelHandlerContext.close();
                    }
                });
            } else {
                channelHandlerContext.writeAndFlush(TOO_LARGE.retainedDuplicate()).addListener((GenericFutureListener)new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture channelFuture) throws Exception {
                        if (!channelFuture.isSuccess()) {
                            logger.debug("Failed to send a 413 Request Entity Too Large.", channelFuture.cause());
                            channelHandlerContext.close();
                        }
                    }
                });
            }
        } else {
            if (httpMessage instanceof HttpResponse) {
                channelHandlerContext.close();
                throw new TooLongHttpContentException("Response entity too large: " + httpMessage);
            }
            throw new IllegalStateException();
        }
    }

    static {
        EXPECTATION_FAILED.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        TOO_LARGE.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        TOO_LARGE_CLOSE.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        TOO_LARGE_CLOSE.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
    }

    private static final class AggregatedFullHttpResponse
    extends AggregatedFullHttpMessage
    implements FullHttpResponse {
        AggregatedFullHttpResponse(HttpResponse httpResponse, ByteBuf byteBuf, HttpHeaders httpHeaders) {
            super(httpResponse, byteBuf, httpHeaders);
        }

        @Override
        public FullHttpResponse retainedDuplicate() {
            return this.replace(this.content().retainedDuplicate());
        }

        public FullHttpResponse replace(ByteBuf byteBuf) {
            DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(this.getProtocolVersion(), this.getStatus(), byteBuf, this.headers().copy(), this.trailingHeaders().copy());
            defaultFullHttpResponse.setDecoderResult(this.decoderResult());
            return defaultFullHttpResponse;
        }

        public HttpResponseStatus getStatus() {
            return ((HttpResponse)this.message).status();
        }

        @Override
        public HttpResponseStatus status() {
            return this.getStatus();
        }

        @Override
        public FullHttpResponse retain() {
            super.retain();
            return this;
        }

        @Override
        public FullHttpResponse touch(Object object) {
            super.touch(object);
            return this;
        }

        @Override
        public FullHttpResponse touch() {
            super.touch();
            return this;
        }

        public String toString() {
            return HttpMessageUtil.appendFullResponse(new StringBuilder(256), this).toString();
        }
    }

    private static final class AggregatedFullHttpRequest
    extends AggregatedFullHttpMessage
    implements FullHttpRequest {
        AggregatedFullHttpRequest(HttpRequest httpRequest, ByteBuf byteBuf, HttpHeaders httpHeaders) {
            super(httpRequest, byteBuf, httpHeaders);
        }

        @Override
        public FullHttpRequest retain() {
            super.retain();
            return this;
        }

        @Override
        public FullHttpRequest touch() {
            super.touch();
            return this;
        }

        @Override
        public FullHttpRequest touch(Object object) {
            super.touch(object);
            return this;
        }

        public HttpMethod getMethod() {
            return ((HttpRequest)this.message).method();
        }

        public String getUri() {
            return ((HttpRequest)this.message).uri();
        }

        @Override
        public HttpMethod method() {
            return this.getMethod();
        }

        @Override
        public String uri() {
            return this.getUri();
        }

        public String toString() {
            return HttpMessageUtil.appendFullRequest(new StringBuilder(256), this).toString();
        }
    }

    private static abstract class AggregatedFullHttpMessage
    implements FullHttpMessage {
        protected final HttpMessage message;
        private final ByteBuf content;
        private HttpHeaders trailingHeaders;

        AggregatedFullHttpMessage(HttpMessage httpMessage, ByteBuf byteBuf, HttpHeaders httpHeaders) {
            this.message = httpMessage;
            this.content = byteBuf;
            this.trailingHeaders = httpHeaders;
        }

        @Override
        public HttpHeaders trailingHeaders() {
            HttpHeaders httpHeaders = this.trailingHeaders;
            if (httpHeaders == null) {
                return EmptyHttpHeaders.INSTANCE;
            }
            return httpHeaders;
        }

        void setTrailingHeaders(HttpHeaders httpHeaders) {
            this.trailingHeaders = httpHeaders;
        }

        public HttpVersion getProtocolVersion() {
            return this.message.protocolVersion();
        }

        @Override
        public HttpVersion protocolVersion() {
            return this.message.protocolVersion();
        }

        @Override
        public HttpHeaders headers() {
            return this.message.headers();
        }

        @Override
        public DecoderResult decoderResult() {
            return this.message.decoderResult();
        }

        @Override
        public void setDecoderResult(DecoderResult decoderResult) {
            this.message.setDecoderResult(decoderResult);
        }

        @Override
        public ByteBuf content() {
            return this.content;
        }

        @Override
        public int refCnt() {
            return this.content.refCnt();
        }

        @Override
        public FullHttpMessage retain() {
            this.content.retain();
            return this;
        }

        @Override
        public FullHttpMessage touch(Object object) {
            this.content.touch(object);
            return this;
        }

        @Override
        public FullHttpMessage touch() {
            this.content.touch();
            return this;
        }

        @Override
        public boolean release() {
            return this.content.release();
        }
    }
}

