/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.channel;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufUtil;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelId;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.EmptyArrays;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.MacAddressUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;

public final class DefaultChannelId
implements ChannelId {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultChannelId.class);
    private static final byte[] MACHINE_ID;
    private static final int PROCESS_ID;
    private static final AtomicInteger nextSequence;
    private final byte[] data;
    private final int hashCode;
    private transient String shortValue;
    private transient String longValue;

    public static DefaultChannelId newInstance() {
        return new DefaultChannelId(MACHINE_ID, PROCESS_ID, nextSequence.getAndIncrement(), Long.reverse(System.nanoTime()) ^ System.currentTimeMillis(), ThreadLocalRandom.current().nextInt());
    }

    static int processHandlePid(ClassLoader classLoader) {
        int n2 = -1;
        if (PlatformDependent.javaVersion() >= 9) {
            Long l2;
            try {
                Class<?> clazz = Class.forName("java.lang.ProcessHandle", true, classLoader);
                Method method = clazz.getMethod("current", new Class[0]);
                Object object = method.invoke(null, new Object[0]);
                Method method2 = clazz.getMethod("pid", new Class[0]);
                l2 = (Long)method2.invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                logger.debug("Could not invoke ProcessHandle.current().pid();", exception);
                return n2;
            }
            if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
                throw new IllegalStateException("Current process ID exceeds int range: " + l2);
            }
            return l2.intValue();
        }
        return n2;
    }

    static int jmxPid(ClassLoader classLoader) {
        int n2;
        String string;
        Class<?> clazz;
        try {
            Class<?> clazz2 = Class.forName("java.lang.management.ManagementFactory", true, classLoader);
            clazz = Class.forName("java.lang.management.RuntimeMXBean", true, classLoader);
            Method method = clazz2.getMethod("getRuntimeMXBean", EmptyArrays.EMPTY_CLASSES);
            Object object = method.invoke(null, EmptyArrays.EMPTY_OBJECTS);
            Method method2 = clazz.getMethod("getName", EmptyArrays.EMPTY_CLASSES);
            string = (String)method2.invoke(object, EmptyArrays.EMPTY_OBJECTS);
        }
        catch (Throwable throwable) {
            logger.debug("Could not invoke ManagementFactory.getRuntimeMXBean().getName(); Android?", throwable);
            try {
                clazz = Class.forName("android.os.Process", true, classLoader);
                Method method = clazz.getMethod("myPid", EmptyArrays.EMPTY_CLASSES);
                string = method.invoke(null, EmptyArrays.EMPTY_OBJECTS).toString();
            }
            catch (Throwable throwable2) {
                logger.debug("Could not invoke Process.myPid(); not Android?", throwable2);
                string = "";
            }
        }
        int n3 = string.indexOf(64);
        if (n3 >= 0) {
            string = string.substring(0, n3);
        }
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = -1;
        }
        if (n2 < 0) {
            n2 = ThreadLocalRandom.current().nextInt();
            logger.warn("Failed to find the current process ID from '{}'; using a random value: {}", (Object)string, (Object)n2);
        }
        return n2;
    }

    static int defaultProcessId() {
        ClassLoader classLoader = PlatformDependent.getClassLoader(DefaultChannelId.class);
        int n2 = DefaultChannelId.processHandlePid(classLoader);
        if (n2 != -1) {
            return n2;
        }
        return DefaultChannelId.jmxPid(classLoader);
    }

    DefaultChannelId(byte[] byArray, int n2, int n3, long l2, int n4) {
        byte[] byArray2 = new byte[byArray.length + 4 + 4 + 8 + 4];
        int n5 = 0;
        System.arraycopy(byArray, 0, byArray2, n5, byArray.length);
        DefaultChannelId.writeInt(byArray2, n5 += byArray.length, n2);
        DefaultChannelId.writeInt(byArray2, n5 += 4, n3);
        DefaultChannelId.writeLong(byArray2, n5 += 4, l2);
        DefaultChannelId.writeInt(byArray2, n5 += 8, n4);
        assert ((n5 += 4) == byArray2.length);
        this.data = byArray2;
        this.hashCode = Arrays.hashCode(byArray2);
    }

    private static void writeInt(byte[] byArray, int n2, int n3) {
        if (PlatformDependent.isUnaligned()) {
            PlatformDependent.putInt(byArray, n2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? n3 : Integer.reverseBytes(n3));
            return;
        }
        byArray[n2] = (byte)(n3 >>> 24);
        byArray[n2 + 1] = (byte)(n3 >>> 16);
        byArray[n2 + 2] = (byte)(n3 >>> 8);
        byArray[n2 + 3] = (byte)n3;
    }

    private static void writeLong(byte[] byArray, int n2, long l2) {
        if (PlatformDependent.isUnaligned()) {
            PlatformDependent.putLong(byArray, n2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? l2 : Long.reverseBytes(l2));
            return;
        }
        byArray[n2] = (byte)(l2 >>> 56);
        byArray[n2 + 1] = (byte)(l2 >>> 48);
        byArray[n2 + 2] = (byte)(l2 >>> 40);
        byArray[n2 + 3] = (byte)(l2 >>> 32);
        byArray[n2 + 4] = (byte)(l2 >>> 24);
        byArray[n2 + 5] = (byte)(l2 >>> 16);
        byArray[n2 + 6] = (byte)(l2 >>> 8);
        byArray[n2 + 7] = (byte)l2;
    }

    @Override
    public String asShortText() {
        String string = this.shortValue;
        if (string == null) {
            this.shortValue = string = ByteBufUtil.hexDump(this.data, this.data.length - 4, 4);
        }
        return string;
    }

    @Override
    public String asLongText() {
        String string = this.longValue;
        if (string == null) {
            this.longValue = string = this.newLongValue();
        }
        return string;
    }

    private String newLongValue() {
        StringBuilder stringBuilder = new StringBuilder(2 * this.data.length + 5);
        int n2 = this.data.length - 4 - 4 - 8 - 4;
        int n3 = 0;
        n3 = this.appendHexDumpField(stringBuilder, n3, n2);
        n3 = this.appendHexDumpField(stringBuilder, n3, 4);
        n3 = this.appendHexDumpField(stringBuilder, n3, 4);
        n3 = this.appendHexDumpField(stringBuilder, n3, 8);
        n3 = this.appendHexDumpField(stringBuilder, n3, 4);
        assert (n3 == this.data.length);
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    private int appendHexDumpField(StringBuilder stringBuilder, int n2, int n3) {
        stringBuilder.append(ByteBufUtil.hexDump(this.data, n2, n3));
        stringBuilder.append('-');
        return n2 += n3;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(ChannelId channelId) {
        if (this == channelId) {
            return 0;
        }
        if (channelId instanceof DefaultChannelId) {
            byte[] byArray = ((DefaultChannelId)channelId).data;
            int n2 = this.data.length;
            int n3 = byArray.length;
            int n4 = Math.min(n2, n3);
            for (int i2 = 0; i2 < n4; ++i2) {
                byte by2 = this.data[i2];
                byte by3 = byArray[i2];
                if (by2 == by3) continue;
                return (by2 & 0xFF) - (by3 & 0xFF);
            }
            return n2 - n3;
        }
        return this.asLongText().compareTo(channelId.asLongText());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultChannelId)) {
            return false;
        }
        DefaultChannelId defaultChannelId = (DefaultChannelId)object;
        return this.hashCode == defaultChannelId.hashCode && Arrays.equals(this.data, defaultChannelId.data);
    }

    public String toString() {
        return this.asShortText();
    }

    static {
        nextSequence = new AtomicInteger();
        int n2 = -1;
        String string = SystemPropertyUtil.get("com.gradle.maven.extension.internal.dep.io.netty.processId");
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n2 < 0) {
                n2 = -1;
                logger.warn("-Dio.netty.processId: {} (malformed)", (Object)string);
            } else if (logger.isDebugEnabled()) {
                logger.debug("-Dio.netty.processId: {} (user-set)", (Object)n2);
            }
        }
        if (n2 < 0) {
            n2 = DefaultChannelId.defaultProcessId();
            if (logger.isDebugEnabled()) {
                logger.debug("-Dio.netty.processId: {} (auto-detected)", (Object)n2);
            }
        }
        PROCESS_ID = n2;
        byte[] byArray = null;
        String string2 = SystemPropertyUtil.get("com.gradle.maven.extension.internal.dep.io.netty.machineId");
        if (string2 != null) {
            try {
                byArray = MacAddressUtil.parseMAC(string2);
            }
            catch (Exception exception) {
                logger.warn("-Dio.netty.machineId: {} (malformed)", (Object)string2, (Object)exception);
            }
            if (byArray != null) {
                logger.debug("-Dio.netty.machineId: {} (user-set)", (Object)string2);
            }
        }
        if (byArray == null) {
            byArray = MacAddressUtil.defaultMachineId();
            if (logger.isDebugEnabled()) {
                logger.debug("-Dio.netty.machineId: {} (auto-detected)", (Object)MacAddressUtil.formatAddress(byArray));
            }
        }
        MACHINE_ID = byArray;
    }
}

