/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.channel;

import com.gradle.maven.extension.internal.dep.io.netty.channel.AbstractChannelHandlerContext;
import com.gradle.maven.extension.internal.dep.io.netty.channel.Channel;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelConfig;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelFuture;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelFutureListener;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelId;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelOption;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelOutboundBuffer;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPipeline;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.channel.DefaultChannelConfig;
import com.gradle.maven.extension.internal.dep.io.netty.channel.DefaultChannelId;
import com.gradle.maven.extension.internal.dep.io.netty.channel.DefaultChannelPipeline;
import com.gradle.maven.extension.internal.dep.io.netty.channel.DefaultChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.channel.EventLoop;
import com.gradle.maven.extension.internal.dep.io.netty.channel.RecvByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.channel.StacklessClosedChannelException;
import com.gradle.maven.extension.internal.dep.io.netty.channel.VoidChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.channel.socket.ChannelOutputShutdownEvent;
import com.gradle.maven.extension.internal.dep.io.netty.channel.socket.ChannelOutputShutdownException;
import com.gradle.maven.extension.internal.dep.io.netty.util.DefaultAttributeMap;
import com.gradle.maven.extension.internal.dep.io.netty.util.ReferenceCountUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.GenericFutureListener;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public abstract class AbstractChannel
extends DefaultAttributeMap
implements Channel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractChannel.class);
    private final Channel parent;
    private final ChannelId id;
    private final Channel.Unsafe unsafe;
    private final DefaultChannelPipeline pipeline;
    private final VoidChannelPromise unsafeVoidPromise = new VoidChannelPromise(this, false);
    private final CloseFuture closeFuture = new CloseFuture(this);
    private volatile SocketAddress localAddress;
    private volatile SocketAddress remoteAddress;
    private volatile EventLoop eventLoop;
    private volatile boolean registered;
    private boolean closeInitiated;
    private Throwable initialCloseCause;
    private boolean strValActive;
    private String strVal;

    protected AbstractChannel(Channel channel) {
        this.parent = channel;
        this.id = this.newId();
        this.unsafe = this.newUnsafe();
        this.pipeline = this.newChannelPipeline();
    }

    protected AbstractChannel(Channel channel, ChannelId channelId) {
        this.parent = channel;
        this.id = channelId;
        this.unsafe = this.newUnsafe();
        this.pipeline = this.newChannelPipeline();
    }

    protected final int maxMessagesPerWrite() {
        ChannelConfig channelConfig = this.config();
        if (channelConfig instanceof DefaultChannelConfig) {
            return ((DefaultChannelConfig)channelConfig).getMaxMessagesPerWrite();
        }
        Integer n2 = channelConfig.getOption(ChannelOption.MAX_MESSAGES_PER_WRITE);
        if (n2 == null) {
            return Integer.MAX_VALUE;
        }
        return n2;
    }

    @Override
    public final ChannelId id() {
        return this.id;
    }

    protected ChannelId newId() {
        return DefaultChannelId.newInstance();
    }

    protected DefaultChannelPipeline newChannelPipeline() {
        return new DefaultChannelPipeline(this);
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public EventLoop eventLoop() {
        EventLoop eventLoop = this.eventLoop;
        if (eventLoop == null) {
            throw new IllegalStateException("channel not registered to an event loop");
        }
        return eventLoop;
    }

    public SocketAddress localAddress() {
        SocketAddress socketAddress = this.localAddress;
        if (socketAddress == null) {
            try {
                this.localAddress = socketAddress = this.unsafe().localAddress();
            }
            catch (Error error) {
                throw error;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return socketAddress;
    }

    @Override
    public SocketAddress remoteAddress() {
        SocketAddress socketAddress = this.remoteAddress;
        if (socketAddress == null) {
            try {
                this.remoteAddress = socketAddress = this.unsafe().remoteAddress();
            }
            catch (Error error) {
                throw error;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return socketAddress;
    }

    @Override
    public boolean isRegistered() {
        return this.registered;
    }

    @Override
    public ChannelFuture closeFuture() {
        return this.closeFuture;
    }

    @Override
    public Channel.Unsafe unsafe() {
        return this.unsafe;
    }

    protected abstract AbstractUnsafe newUnsafe();

    public final int hashCode() {
        return this.id.hashCode();
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    @Override
    public final int compareTo(Channel channel) {
        if (this == channel) {
            return 0;
        }
        return this.id().compareTo(channel.id());
    }

    public String toString() {
        boolean bl2 = this.isActive();
        if (this.strValActive == bl2 && this.strVal != null) {
            return this.strVal;
        }
        SocketAddress socketAddress = this.remoteAddress();
        SocketAddress socketAddress2 = this.localAddress();
        if (socketAddress != null) {
            StringBuilder stringBuilder = new StringBuilder(96).append("[id: 0x").append(this.id.asShortText()).append(", L:").append(socketAddress2).append(bl2 ? " - " : " ! ").append("R:").append(socketAddress).append(']');
            this.strVal = stringBuilder.toString();
        } else if (socketAddress2 != null) {
            StringBuilder stringBuilder = new StringBuilder(64).append("[id: 0x").append(this.id.asShortText()).append(", L:").append(socketAddress2).append(']');
            this.strVal = stringBuilder.toString();
        } else {
            StringBuilder stringBuilder = new StringBuilder(16).append("[id: 0x").append(this.id.asShortText()).append(']');
            this.strVal = stringBuilder.toString();
        }
        this.strValActive = bl2;
        return this.strVal;
    }

    @Override
    public final ChannelPromise voidPromise() {
        return this.pipeline.voidPromise();
    }

    protected abstract boolean isCompatible(EventLoop var1);

    protected abstract SocketAddress localAddress0();

    protected abstract SocketAddress remoteAddress0();

    @Deprecated
    protected void doRegister() throws Exception {
    }

    protected void doRegister(ChannelPromise channelPromise) {
        try {
            this.doRegister();
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
            return;
        }
        channelPromise.setSuccess();
    }

    protected abstract void doBind(SocketAddress var1) throws Exception;

    protected abstract void doDisconnect() throws Exception;

    protected abstract void doClose() throws Exception;

    protected void doShutdownOutput() throws Exception {
        this.doClose();
    }

    protected void doDeregister() throws Exception {
    }

    protected abstract void doBeginRead() throws Exception;

    protected abstract void doWrite(ChannelOutboundBuffer var1) throws Exception;

    protected Object filterOutboundMessage(Object object) throws Exception {
        return object;
    }

    private static final class AnnotatedSocketException
    extends SocketException {
        AnnotatedSocketException(SocketException socketException, SocketAddress socketAddress) {
            super(socketException.getMessage() + ": " + socketAddress);
            this.initCause(socketException);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static final class AnnotatedNoRouteToHostException
    extends NoRouteToHostException {
        AnnotatedNoRouteToHostException(NoRouteToHostException noRouteToHostException, SocketAddress socketAddress) {
            super(noRouteToHostException.getMessage() + ": " + socketAddress);
            this.initCause(noRouteToHostException);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static final class AnnotatedConnectException
    extends ConnectException {
        AnnotatedConnectException(ConnectException connectException, SocketAddress socketAddress) {
            super(connectException.getMessage() + ": " + socketAddress);
            this.initCause(connectException);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    static final class CloseFuture
    extends DefaultChannelPromise {
        CloseFuture(AbstractChannel abstractChannel) {
            super(abstractChannel);
        }

        @Override
        public ChannelPromise setSuccess() {
            throw new IllegalStateException();
        }

        @Override
        public ChannelPromise setFailure(Throwable throwable) {
            throw new IllegalStateException();
        }

        @Override
        public boolean trySuccess() {
            throw new IllegalStateException();
        }

        @Override
        public boolean tryFailure(Throwable throwable) {
            throw new IllegalStateException();
        }

        boolean setClosed() {
            return super.trySuccess();
        }
    }

    protected abstract class AbstractUnsafe
    implements Channel.Unsafe {
        private volatile ChannelOutboundBuffer outboundBuffer;
        private RecvByteBufAllocator.Handle recvHandle;
        private boolean inFlush0;
        private boolean neverRegistered;

        protected AbstractUnsafe() {
            this.outboundBuffer = new ChannelOutboundBuffer(AbstractChannel.this);
            this.neverRegistered = true;
        }

        private void assertEventLoop() {
            assert (!AbstractChannel.this.registered || AbstractChannel.this.eventLoop.inEventLoop());
        }

        @Override
        public RecvByteBufAllocator.Handle recvBufAllocHandle() {
            if (this.recvHandle == null) {
                this.recvHandle = AbstractChannel.this.config().getRecvByteBufAllocator().newHandle();
            }
            return this.recvHandle;
        }

        @Override
        public final ChannelOutboundBuffer outboundBuffer() {
            return this.outboundBuffer;
        }

        @Override
        public final SocketAddress localAddress() {
            return AbstractChannel.this.localAddress0();
        }

        @Override
        public final SocketAddress remoteAddress() {
            return AbstractChannel.this.remoteAddress0();
        }

        @Override
        public final void register(EventLoop eventLoop, final ChannelPromise channelPromise) {
            ObjectUtil.checkNotNull(eventLoop, "eventLoop");
            if (AbstractChannel.this.isRegistered()) {
                channelPromise.setFailure(new IllegalStateException("registered to an event loop already"));
                return;
            }
            if (!AbstractChannel.this.isCompatible(eventLoop)) {
                channelPromise.setFailure(new IllegalStateException("incompatible event loop type: " + eventLoop.getClass().getName()));
                return;
            }
            AbstractChannel.this.eventLoop = eventLoop;
            AbstractChannelHandlerContext abstractChannelHandlerContext = ((AbstractChannel)AbstractChannel.this).pipeline.tail;
            do {
                abstractChannelHandlerContext.contextExecutor = null;
            } while ((abstractChannelHandlerContext = abstractChannelHandlerContext.prev) != null);
            if (eventLoop.inEventLoop()) {
                this.register0(channelPromise);
            } else {
                try {
                    eventLoop.execute(new Runnable(){

                        @Override
                        public void run() {
                            AbstractUnsafe.this.register0(channelPromise);
                        }
                    });
                }
                catch (Throwable throwable) {
                    logger.warn("Force-closing a channel whose registration task was not accepted by an event loop: {}", (Object)AbstractChannel.this, (Object)throwable);
                    this.closeForcibly();
                    AbstractChannel.this.closeFuture.setClosed();
                    this.safeSetFailure(channelPromise, throwable);
                }
            }
        }

        private void register0(final ChannelPromise channelPromise) {
            if (!channelPromise.setUncancellable() || !this.ensureOpen(channelPromise)) {
                return;
            }
            ChannelPromise channelPromise2 = AbstractChannel.this.newPromise();
            final boolean bl2 = this.neverRegistered;
            channelPromise2.addListener((GenericFutureListener)new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture channelFuture) throws Exception {
                    if (channelFuture.isSuccess()) {
                        AbstractUnsafe.this.neverRegistered = false;
                        AbstractChannel.this.registered = true;
                        AbstractChannel.this.pipeline.invokeHandlerAddedIfNeeded();
                        AbstractUnsafe.this.safeSetSuccess(channelPromise);
                        AbstractChannel.this.pipeline.fireChannelRegistered();
                        if (AbstractChannel.this.isActive()) {
                            if (bl2) {
                                AbstractChannel.this.pipeline.fireChannelActive();
                            } else if (AbstractChannel.this.config().isAutoRead()) {
                                AbstractUnsafe.this.beginRead();
                            }
                        }
                    } else {
                        AbstractUnsafe.this.closeForcibly();
                        AbstractChannel.this.closeFuture.setClosed();
                        AbstractUnsafe.this.safeSetFailure(channelPromise, channelFuture.cause());
                    }
                }
            });
            AbstractChannel.this.doRegister(channelPromise2);
        }

        @Override
        public final void bind(SocketAddress socketAddress, ChannelPromise channelPromise) {
            this.assertEventLoop();
            if (!channelPromise.setUncancellable() || !this.ensureOpen(channelPromise)) {
                return;
            }
            if (Boolean.TRUE.equals(AbstractChannel.this.config().getOption(ChannelOption.SO_BROADCAST)) && socketAddress instanceof InetSocketAddress && !((InetSocketAddress)socketAddress).getAddress().isAnyLocalAddress() && !PlatformDependent.isWindows() && !PlatformDependent.maybeSuperUser()) {
                logger.warn("A non-root user can't receive a broadcast packet if the socket is not bound to a wildcard address; binding to a non-wildcard address (" + socketAddress + ") anyway as requested.");
            }
            boolean bl2 = AbstractChannel.this.isActive();
            try {
                AbstractChannel.this.doBind(socketAddress);
            }
            catch (Throwable throwable) {
                this.safeSetFailure(channelPromise, throwable);
                this.closeIfClosed();
                return;
            }
            if (!bl2 && AbstractChannel.this.isActive()) {
                this.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractChannel.this.pipeline.fireChannelActive();
                    }
                });
            }
            this.safeSetSuccess(channelPromise);
        }

        @Override
        public final void disconnect(ChannelPromise channelPromise) {
            this.assertEventLoop();
            if (!channelPromise.setUncancellable()) {
                return;
            }
            boolean bl2 = AbstractChannel.this.isActive();
            try {
                AbstractChannel.this.doDisconnect();
                AbstractChannel.this.remoteAddress = null;
                AbstractChannel.this.localAddress = null;
            }
            catch (Throwable throwable) {
                this.safeSetFailure(channelPromise, throwable);
                this.closeIfClosed();
                return;
            }
            if (bl2 && !AbstractChannel.this.isActive()) {
                this.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractChannel.this.pipeline.fireChannelInactive();
                    }
                });
            }
            this.safeSetSuccess(channelPromise);
            this.closeIfClosed();
        }

        @Override
        public void close(ChannelPromise channelPromise) {
            this.assertEventLoop();
            StacklessClosedChannelException stacklessClosedChannelException = StacklessClosedChannelException.newInstance(AbstractChannel.class, "close(ChannelPromise)");
            this.close(channelPromise, stacklessClosedChannelException, stacklessClosedChannelException);
        }

        public final void shutdownOutput(ChannelPromise channelPromise) {
            this.assertEventLoop();
            this.shutdownOutput(channelPromise, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdownOutput(ChannelPromise channelPromise, Throwable throwable) {
            if (!channelPromise.setUncancellable()) {
                return;
            }
            ChannelOutboundBuffer channelOutboundBuffer = this.outboundBuffer;
            if (channelOutboundBuffer == null) {
                channelPromise.setFailure(new ClosedChannelException());
                return;
            }
            this.outboundBuffer = null;
            ChannelOutputShutdownException channelOutputShutdownException = throwable == null ? new ChannelOutputShutdownException("Channel output shutdown") : new ChannelOutputShutdownException("Channel output shutdown", throwable);
            try {
                AbstractChannel.this.doShutdownOutput();
                channelPromise.setSuccess();
            }
            catch (Throwable throwable2) {
                channelPromise.setFailure(throwable2);
            }
            finally {
                this.closeOutboundBufferForShutdown(AbstractChannel.this.pipeline, channelOutboundBuffer, channelOutputShutdownException);
            }
        }

        private void closeOutboundBufferForShutdown(ChannelPipeline channelPipeline, ChannelOutboundBuffer channelOutboundBuffer, Throwable throwable) {
            channelOutboundBuffer.failFlushed(throwable, false);
            channelOutboundBuffer.close(throwable, true);
            channelPipeline.fireUserEventTriggered(ChannelOutputShutdownEvent.INSTANCE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void close(final ChannelPromise channelPromise, final Throwable throwable, final ClosedChannelException closedChannelException) {
            if (!channelPromise.setUncancellable()) {
                return;
            }
            if (AbstractChannel.this.closeInitiated) {
                if (AbstractChannel.this.closeFuture.isDone()) {
                    this.safeSetSuccess(channelPromise);
                } else if (!(channelPromise instanceof VoidChannelPromise)) {
                    AbstractChannel.this.closeFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                        @Override
                        public void operationComplete(ChannelFuture channelFuture) throws Exception {
                            channelPromise.setSuccess();
                        }
                    });
                }
                return;
            }
            AbstractChannel.this.closeInitiated = true;
            final boolean bl2 = AbstractChannel.this.isActive();
            final ChannelOutboundBuffer channelOutboundBuffer = this.outboundBuffer;
            this.outboundBuffer = null;
            Executor executor = this.prepareToClose();
            if (executor != null) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AbstractUnsafe.this.doClose0(channelPromise);
                        }
                        catch (Throwable throwable2) {
                            AbstractUnsafe.this.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (channelOutboundBuffer != null) {
                                        channelOutboundBuffer.failFlushed(throwable, false);
                                        channelOutboundBuffer.close(closedChannelException);
                                    }
                                    AbstractUnsafe.this.fireChannelInactiveAndDeregister(bl2);
                                }
                            });
                            throw throwable2;
                        }
                        AbstractUnsafe.this.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                });
            } else {
                try {
                    this.doClose0(channelPromise);
                }
                finally {
                    if (channelOutboundBuffer != null) {
                        channelOutboundBuffer.failFlushed(throwable, false);
                        channelOutboundBuffer.close(closedChannelException);
                    }
                }
                if (this.inFlush0) {
                    this.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AbstractUnsafe.this.fireChannelInactiveAndDeregister(bl2);
                        }
                    });
                } else {
                    this.fireChannelInactiveAndDeregister(bl2);
                }
            }
        }

        private void doClose0(ChannelPromise channelPromise) {
            try {
                AbstractChannel.this.doClose();
                AbstractChannel.this.closeFuture.setClosed();
                this.safeSetSuccess(channelPromise);
            }
            catch (Throwable throwable) {
                AbstractChannel.this.closeFuture.setClosed();
                this.safeSetFailure(channelPromise, throwable);
            }
        }

        private void fireChannelInactiveAndDeregister(boolean bl2) {
            this.deregister(this.voidPromise(), bl2 && !AbstractChannel.this.isActive());
        }

        @Override
        public final void closeForcibly() {
            this.assertEventLoop();
            try {
                AbstractChannel.this.doClose();
            }
            catch (Exception exception) {
                logger.warn("Failed to close a channel.", exception);
            }
        }

        @Override
        public final void deregister(ChannelPromise channelPromise) {
            this.assertEventLoop();
            this.deregister(channelPromise, false);
        }

        private void deregister(final ChannelPromise channelPromise, final boolean bl2) {
            if (!channelPromise.setUncancellable()) {
                return;
            }
            if (!AbstractChannel.this.registered) {
                this.safeSetSuccess(channelPromise);
                return;
            }
            this.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractChannel.this.doDeregister();
                    }
                    catch (Throwable throwable) {
                        logger.warn("Unexpected exception occurred while deregistering a channel.", throwable);
                    }
                    finally {
                        if (bl2) {
                            AbstractChannel.this.pipeline.fireChannelInactive();
                        }
                        if (AbstractChannel.this.registered) {
                            AbstractChannel.this.registered = false;
                            AbstractChannel.this.pipeline.fireChannelUnregistered();
                        }
                        AbstractUnsafe.this.safeSetSuccess(channelPromise);
                    }
                }
            });
        }

        @Override
        public final void beginRead() {
            this.assertEventLoop();
            try {
                AbstractChannel.this.doBeginRead();
            }
            catch (Exception exception) {
                this.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractChannel.this.pipeline.fireExceptionCaught(exception);
                    }
                });
                this.close(this.voidPromise());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void write(Object object, ChannelPromise channelPromise) {
            int n2;
            this.assertEventLoop();
            ChannelOutboundBuffer channelOutboundBuffer = this.outboundBuffer;
            if (channelOutboundBuffer == null) {
                try {
                    ReferenceCountUtil.release(object);
                }
                finally {
                    this.safeSetFailure(channelPromise, this.newClosedChannelException(AbstractChannel.this.initialCloseCause, "write(Object, ChannelPromise)"));
                }
                return;
            }
            try {
                object = AbstractChannel.this.filterOutboundMessage(object);
                n2 = AbstractChannel.this.pipeline.estimatorHandle().size(object);
                if (n2 < 0) {
                    n2 = 0;
                }
            }
            catch (Throwable throwable) {
                try {
                    ReferenceCountUtil.release(object);
                }
                finally {
                    this.safeSetFailure(channelPromise, throwable);
                }
                return;
            }
            channelOutboundBuffer.addMessage(object, n2, channelPromise);
        }

        @Override
        public final void flush() {
            this.assertEventLoop();
            ChannelOutboundBuffer channelOutboundBuffer = this.outboundBuffer;
            if (channelOutboundBuffer == null) {
                return;
            }
            channelOutboundBuffer.addFlush();
            this.flush0();
        }

        protected void flush0() {
            if (this.inFlush0) {
                return;
            }
            ChannelOutboundBuffer channelOutboundBuffer = this.outboundBuffer;
            if (channelOutboundBuffer == null || channelOutboundBuffer.isEmpty()) {
                return;
            }
            this.inFlush0 = true;
            if (!AbstractChannel.this.isActive()) {
                try {
                    if (!channelOutboundBuffer.isEmpty()) {
                        if (AbstractChannel.this.isOpen()) {
                            channelOutboundBuffer.failFlushed(new NotYetConnectedException(), true);
                        } else {
                            channelOutboundBuffer.failFlushed(this.newClosedChannelException(AbstractChannel.this.initialCloseCause, "flush0()"), false);
                        }
                    }
                }
                finally {
                    this.inFlush0 = false;
                }
                return;
            }
            try {
                AbstractChannel.this.doWrite(channelOutboundBuffer);
            }
            catch (Throwable throwable) {
                this.handleWriteError(throwable);
            }
            finally {
                this.inFlush0 = false;
            }
        }

        protected final void handleWriteError(Throwable throwable) {
            if (throwable instanceof IOException && AbstractChannel.this.config().isAutoClose()) {
                AbstractChannel.this.initialCloseCause = throwable;
                this.close(this.voidPromise(), throwable, this.newClosedChannelException(throwable, "flush0()"));
            } else {
                try {
                    this.shutdownOutput(this.voidPromise(), throwable);
                }
                catch (Throwable throwable2) {
                    AbstractChannel.this.initialCloseCause = throwable;
                    this.close(this.voidPromise(), throwable2, this.newClosedChannelException(throwable, "flush0()"));
                }
            }
        }

        private ClosedChannelException newClosedChannelException(Throwable throwable, String string) {
            StacklessClosedChannelException stacklessClosedChannelException = StacklessClosedChannelException.newInstance(AbstractUnsafe.class, string);
            if (throwable != null) {
                stacklessClosedChannelException.initCause(throwable);
            }
            return stacklessClosedChannelException;
        }

        public final ChannelPromise voidPromise() {
            this.assertEventLoop();
            return AbstractChannel.this.unsafeVoidPromise;
        }

        protected final boolean ensureOpen(ChannelPromise channelPromise) {
            if (AbstractChannel.this.isOpen()) {
                return true;
            }
            this.safeSetFailure(channelPromise, this.newClosedChannelException(AbstractChannel.this.initialCloseCause, "ensureOpen(ChannelPromise)"));
            return false;
        }

        protected final void safeSetSuccess(ChannelPromise channelPromise) {
            if (!(channelPromise instanceof VoidChannelPromise) && !channelPromise.trySuccess()) {
                logger.warn("Failed to mark a promise as success because it is done already: {}", (Object)channelPromise);
            }
        }

        protected final void safeSetFailure(ChannelPromise channelPromise, Throwable throwable) {
            if (!(channelPromise instanceof VoidChannelPromise) && !channelPromise.tryFailure(throwable)) {
                logger.warn("Failed to mark a promise as failure because it's done already: {}", (Object)channelPromise, (Object)throwable);
            }
        }

        protected final void closeIfClosed() {
            if (AbstractChannel.this.isOpen()) {
                return;
            }
            this.close(this.voidPromise());
        }

        private void invokeLater(Runnable runnable) {
            try {
                AbstractChannel.this.eventLoop().execute(runnable);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                logger.warn("Can't invoke task later as EventLoop rejected it", rejectedExecutionException);
            }
        }

        protected final Throwable annotateConnectException(Throwable throwable, SocketAddress socketAddress) {
            if (throwable instanceof ConnectException) {
                return new AnnotatedConnectException((ConnectException)throwable, socketAddress);
            }
            if (throwable instanceof NoRouteToHostException) {
                return new AnnotatedNoRouteToHostException((NoRouteToHostException)throwable, socketAddress);
            }
            if (throwable instanceof SocketException) {
                return new AnnotatedSocketException((SocketException)throwable, socketAddress);
            }
            return throwable;
        }

        protected Executor prepareToClose() {
            return null;
        }
    }
}

