/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.buffer;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.PoolThreadCache;

final class SizeClasses {
    final int pageSize;
    final int pageShifts;
    final int chunkSize;
    final int directMemoryCacheAlignment;
    final int nSizes;
    final int nSubpages;
    final int nPSizes;
    final int lookupMaxSize;
    final int smallMaxSizeIdx;
    private final int[] pageIdx2sizeTab;
    private final int[] sizeIdx2sizeTab;
    private final int[] size2idxTab;

    SizeClasses(int n2, int n3, int n4, int n5) {
        short[] sArray;
        int n6 = PoolThreadCache.log2(n4) - 4 - 2 + 1;
        short[][] sArray2 = new short[n6 << 2][7];
        int n7 = -1;
        int n8 = 0;
        int n9 = 0;
        int n10 = 4;
        int n11 = 4;
        int n12 = 4;
        int n13 = 0;
        while (n13 < n12) {
            sArray = SizeClasses.newSizeClass(n8, n10, n11, n13, n3);
            sArray2[n8] = sArray;
            n9 = SizeClasses.sizeOf(sArray, n5);
            ++n13;
            ++n8;
        }
        n10 += 2;
        while (n9 < n4) {
            n13 = 1;
            while (n13 <= n12 && n9 < n4) {
                sArray = SizeClasses.newSizeClass(n8, n10, n11, n13, n3);
                sArray2[n8] = sArray;
                n9 = n7 = SizeClasses.sizeOf(sArray, n5);
                ++n13;
                ++n8;
            }
            ++n10;
            ++n11;
        }
        assert (n4 == n7);
        n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        for (int i2 = 0; i2 < n8; ++i2) {
            short[] sArray3 = sArray2[i2];
            if (sArray3[4] == 1) {
                ++n15;
            }
            if (sArray3[5] == 1) {
                ++n16;
                n13 = i2;
            }
            if (sArray3[6] == 0) continue;
            n14 = SizeClasses.sizeOf(sArray3, n5);
        }
        this.smallMaxSizeIdx = n13;
        this.lookupMaxSize = n14;
        this.nPSizes = n15;
        this.nSubpages = n16;
        this.nSizes = n8;
        this.pageSize = n2;
        this.pageShifts = n3;
        this.chunkSize = n4;
        this.directMemoryCacheAlignment = n5;
        this.sizeIdx2sizeTab = SizeClasses.newIdx2SizeTab(sArray2, n8, n5);
        this.pageIdx2sizeTab = SizeClasses.newPageIdx2sizeTab(sArray2, n8, n15, n5);
        this.size2idxTab = SizeClasses.newSize2idxTab(n14, sArray2);
    }

    private static short[] newSizeClass(int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        int n9;
        short s2;
        if (n4 >= n6) {
            s2 = 1;
        } else {
            n9 = 1 << n6;
            n8 = SizeClasses.calculateSize(n3, n5, n4);
            s2 = n8 == n8 / n9 * n9 ? (short)1 : 0;
        }
        n9 = n5 == 0 ? 0 : PoolThreadCache.log2(n5);
        n8 = 1 << n9 < n5 ? 1 : 0;
        int n10 = n7 = n4 + n9 == n3 ? n3 + 1 : n3;
        if (n7 == n3) {
            n8 = 1;
        }
        short s3 = n7 < n6 + 2 ? (short)1 : 0;
        int n11 = n7 < 12 || n7 == 12 && n8 == 0 ? n4 : 0;
        return new short[]{(short)n2, (short)n3, (short)n4, (short)n5, s2, s3, (short)n11};
    }

    private static int[] newIdx2SizeTab(short[][] sArray, int n2, int n3) {
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            short[] sArray2 = sArray[i2];
            nArray[i2] = SizeClasses.sizeOf(sArray2, n3);
        }
        return nArray;
    }

    private static int calculateSize(int n2, int n3, int n4) {
        return (1 << n2) + (n3 << n4);
    }

    private static int sizeOf(short[] sArray, int n2) {
        short s2 = sArray[1];
        short s3 = sArray[2];
        short s4 = sArray[3];
        int n3 = SizeClasses.calculateSize(s2, s4, s3);
        return SizeClasses.alignSizeIfNeeded(n3, n2);
    }

    private static int[] newPageIdx2sizeTab(short[][] sArray, int n2, int n3, int n4) {
        int[] nArray = new int[n3];
        int n5 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            short[] sArray2 = sArray[i2];
            if (sArray2[4] != 1) continue;
            nArray[n5++] = SizeClasses.sizeOf(sArray2, n4);
        }
        return nArray;
    }

    private static int[] newSize2idxTab(int n2, short[][] sArray) {
        int[] nArray = new int[n2 >> 4];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n4 <= n2) {
            short s2 = sArray[n5][2];
            int n6 = 1 << s2 - 4;
            while (n4 <= n2 && n6-- > 0) {
                nArray[n3++] = n5;
                n4 = n3 + 1 << 4;
            }
            ++n5;
        }
        return nArray;
    }

    public int sizeIdx2size(int n2) {
        return this.sizeIdx2sizeTab[n2];
    }

    public int size2SizeIdx(int n2) {
        if (n2 == 0) {
            return 0;
        }
        if (n2 > this.chunkSize) {
            return this.nSizes;
        }
        if ((n2 = SizeClasses.alignSizeIfNeeded(n2, this.directMemoryCacheAlignment)) <= this.lookupMaxSize) {
            return this.size2idxTab[n2 - 1 >> 4];
        }
        int n3 = PoolThreadCache.log2((n2 << 1) - 1);
        int n4 = n3 < 7 ? 0 : n3 - 6;
        int n5 = n4 << 2;
        int n6 = n3 < 7 ? 4 : n3 - 2 - 1;
        int n7 = n2 - 1 >> n6 & 3;
        return n5 + n7;
    }

    public int pages2pageIdx(int n2) {
        return this.pages2pageIdxCompute(n2, false);
    }

    public int pages2pageIdxFloor(int n2) {
        return this.pages2pageIdxCompute(n2, true);
    }

    private int pages2pageIdxCompute(int n2, boolean bl2) {
        int n3 = n2 << this.pageShifts;
        if (n3 > this.chunkSize) {
            return this.nPSizes;
        }
        int n4 = PoolThreadCache.log2((n3 << 1) - 1);
        int n5 = n4 < 2 + this.pageShifts ? 0 : n4 - (2 + this.pageShifts);
        int n6 = n5 << 2;
        int n7 = n4 < 2 + this.pageShifts + 1 ? this.pageShifts : n4 - 2 - 1;
        int n8 = n3 - 1 >> n7 & 3;
        int n9 = n6 + n8;
        if (bl2 && this.pageIdx2sizeTab[n9] > n2 << this.pageShifts) {
            --n9;
        }
        return n9;
    }

    private static int alignSizeIfNeeded(int n2, int n3) {
        if (n3 <= 0) {
            return n2;
        }
        int n4 = n2 & n3 - 1;
        return n4 == 0 ? n2 : n2 + n3 - n4;
    }

    public int normalizeSize(int n2) {
        if (n2 == 0) {
            return this.sizeIdx2sizeTab[0];
        }
        if ((n2 = SizeClasses.alignSizeIfNeeded(n2, this.directMemoryCacheAlignment)) <= this.lookupMaxSize) {
            int n3 = this.sizeIdx2sizeTab[this.size2idxTab[n2 - 1 >> 4]];
            assert (n3 == SizeClasses.normalizeSizeCompute(n2));
            return n3;
        }
        return SizeClasses.normalizeSizeCompute(n2);
    }

    private static int normalizeSizeCompute(int n2) {
        int n3 = PoolThreadCache.log2((n2 << 1) - 1);
        int n4 = n3 < 7 ? 4 : n3 - 2 - 1;
        int n5 = 1 << n4;
        int n6 = n5 - 1;
        return n2 + n6 & ~n6;
    }
}

