/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.buffer;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.AbstractByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.AbstractByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.AbstractReferenceCountedByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.AllocateBufferEvent;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.AllocateChunkEvent;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ChunkInfo;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.FreeBufferEvent;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.FreeChunkEvent;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.PoolArena;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.PoolThreadCache;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.PooledByteBufAllocatorMetric;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ReallocateBufferEvent;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.SizeClasses;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.UnpooledDirectByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.UnpooledHeapByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.UnpooledUnsafeHeapByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.UnsafeByteBufUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.NettyRuntime;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.EventExecutor;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.FastThreadLocal;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.FastThreadLocalThread;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ThreadExecutorMap;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class PooledByteBufAllocator
extends AbstractByteBufAllocator {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PooledByteBufAllocator.class);
    private static final int DEFAULT_NUM_HEAP_ARENA;
    private static final int DEFAULT_NUM_DIRECT_ARENA;
    private static final int DEFAULT_PAGE_SIZE;
    private static final int DEFAULT_MAX_ORDER;
    private static final int DEFAULT_SMALL_CACHE_SIZE;
    private static final int DEFAULT_NORMAL_CACHE_SIZE;
    static final int DEFAULT_MAX_CACHED_BUFFER_CAPACITY;
    private static final int DEFAULT_CACHE_TRIM_INTERVAL;
    private static final long DEFAULT_CACHE_TRIM_INTERVAL_MILLIS;
    private static final boolean DEFAULT_USE_CACHE_FOR_ALL_THREADS;
    private static final int DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT;
    static final int DEFAULT_MAX_CACHED_BYTEBUFFERS_PER_CHUNK;
    private static final boolean DEFAULT_DISABLE_CACHE_FINALIZERS_FOR_FAST_THREAD_LOCAL_THREADS;
    private final Runnable trimTask = new Runnable(){

        @Override
        public void run() {
            PooledByteBufAllocator.this.trimCurrentThreadCache();
        }
    };
    public static final PooledByteBufAllocator DEFAULT;
    private final PoolArena<byte[]>[] heapArenas;
    private final PoolArena<ByteBuffer>[] directArenas;
    private final int smallCacheSize;
    private final int normalCacheSize;
    private final List<Object> heapArenaMetrics;
    private final List<Object> directArenaMetrics;
    private final PoolThreadLocalCache threadCache;
    private final int chunkSize;
    private final PooledByteBufAllocatorMetric metric;

    public PooledByteBufAllocator() {
        this(false);
    }

    public PooledByteBufAllocator(boolean bl2) {
        this(bl2, DEFAULT_NUM_HEAP_ARENA, DEFAULT_NUM_DIRECT_ARENA, DEFAULT_PAGE_SIZE, DEFAULT_MAX_ORDER);
    }

    @Deprecated
    public PooledByteBufAllocator(boolean bl2, int n2, int n3, int n4, int n5) {
        this(bl2, n2, n3, n4, n5, 0, DEFAULT_SMALL_CACHE_SIZE, DEFAULT_NORMAL_CACHE_SIZE);
    }

    @Deprecated
    public PooledByteBufAllocator(boolean bl2, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this(bl2, n2, n3, n4, n5, n7, n8, DEFAULT_USE_CACHE_FOR_ALL_THREADS, DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT);
    }

    public PooledByteBufAllocator(boolean bl2, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl3, int n8) {
        super(bl2);
        PoolArena poolArena;
        int n9;
        SizeClasses sizeClasses;
        ArrayList<PoolArena.HeapArena> arrayList;
        this.threadCache = new PoolThreadLocalCache(bl3);
        this.smallCacheSize = n6;
        this.normalCacheSize = n7;
        if (n8 != 0) {
            if (!PlatformDependent.hasAlignDirectByteBuffer()) {
                throw new UnsupportedOperationException("Buffer alignment is not supported. Either Unsafe or ByteBuffer.alignSlice() must be available.");
            }
            n4 = (int)PlatformDependent.align(n4, n8);
        }
        this.chunkSize = PooledByteBufAllocator.validateAndCalculateChunkSize(n4, n5);
        ObjectUtil.checkPositiveOrZero(n2, "nHeapArena");
        ObjectUtil.checkPositiveOrZero(n3, "nDirectArena");
        ObjectUtil.checkPositiveOrZero(n8, "directMemoryCacheAlignment");
        if (n8 > 0 && !PooledByteBufAllocator.isDirectMemoryCacheAlignmentSupported()) {
            throw new IllegalArgumentException("directMemoryCacheAlignment is not supported");
        }
        if ((n8 & -n8) != n8) {
            throw new IllegalArgumentException("directMemoryCacheAlignment: " + n8 + " (expected: power of two)");
        }
        int n10 = PooledByteBufAllocator.validateAndCalculatePageShifts(n4, n8);
        if (n2 > 0) {
            this.heapArenas = PooledByteBufAllocator.newArenaArray(n2);
            arrayList = new ArrayList<PoolArena.HeapArena>(this.heapArenas.length);
            sizeClasses = new SizeClasses(n4, n10, this.chunkSize, 0);
            for (n9 = 0; n9 < this.heapArenas.length; ++n9) {
                this.heapArenas[n9] = poolArena = new PoolArena.HeapArena(this, sizeClasses);
                arrayList.add((PoolArena.HeapArena)poolArena);
            }
            this.heapArenaMetrics = Collections.unmodifiableList(arrayList);
        } else {
            this.heapArenas = null;
            this.heapArenaMetrics = Collections.emptyList();
        }
        if (n3 > 0) {
            this.directArenas = PooledByteBufAllocator.newArenaArray(n3);
            arrayList = new ArrayList(this.directArenas.length);
            sizeClasses = new SizeClasses(n4, n10, this.chunkSize, n8);
            for (n9 = 0; n9 < this.directArenas.length; ++n9) {
                this.directArenas[n9] = poolArena = new PoolArena.DirectArena(this, sizeClasses);
                arrayList.add((PoolArena.HeapArena)poolArena);
            }
            this.directArenaMetrics = Collections.unmodifiableList(arrayList);
        } else {
            this.directArenas = null;
            this.directArenaMetrics = Collections.emptyList();
        }
        this.metric = new PooledByteBufAllocatorMetric(this);
    }

    private static <T> PoolArena<T>[] newArenaArray(int n2) {
        return new PoolArena[n2];
    }

    private static int validateAndCalculatePageShifts(int n2, int n3) {
        if (n2 < 4096) {
            throw new IllegalArgumentException("pageSize: " + n2 + " (expected: " + 4096 + ')');
        }
        if ((n2 & n2 - 1) != 0) {
            throw new IllegalArgumentException("pageSize: " + n2 + " (expected: power of 2)");
        }
        if (n2 < n3) {
            throw new IllegalArgumentException("Alignment cannot be greater than page size. Alignment: " + n3 + ", page size: " + n2 + '.');
        }
        return 31 - Integer.numberOfLeadingZeros(n2);
    }

    private static int validateAndCalculateChunkSize(int n2, int n3) {
        if (n3 > 14) {
            throw new IllegalArgumentException("maxOrder: " + n3 + " (expected: 0-14)");
        }
        int n4 = n2;
        for (int i2 = n3; i2 > 0; --i2) {
            if (n4 > 0x20000000) {
                throw new IllegalArgumentException(String.format("pageSize (%d) << maxOrder (%d) must not exceed %d", n2, n3, 0x40000000));
            }
            n4 <<= 1;
        }
        return n4;
    }

    @Override
    protected ByteBuf newHeapBuffer(int n2, int n3) {
        AbstractReferenceCountedByteBuf abstractReferenceCountedByteBuf;
        PoolThreadCache poolThreadCache = (PoolThreadCache)this.threadCache.get();
        PoolArena<byte[]> poolArena = poolThreadCache.heapArena;
        if (poolArena != null) {
            abstractReferenceCountedByteBuf = poolArena.allocate(poolThreadCache, n2, n3);
        } else {
            abstractReferenceCountedByteBuf = PlatformDependent.hasUnsafe() ? new UnpooledUnsafeHeapByteBuf((ByteBufAllocator)this, n2, n3) : new UnpooledHeapByteBuf((ByteBufAllocator)this, n2, n3);
            PooledByteBufAllocator.onAllocateBuffer(abstractReferenceCountedByteBuf, false, false);
        }
        return PooledByteBufAllocator.toLeakAwareBuffer(abstractReferenceCountedByteBuf);
    }

    @Override
    protected ByteBuf newDirectBuffer(int n2, int n3) {
        AbstractReferenceCountedByteBuf abstractReferenceCountedByteBuf;
        PoolThreadCache poolThreadCache = (PoolThreadCache)this.threadCache.get();
        PoolArena<ByteBuffer> poolArena = poolThreadCache.directArena;
        if (poolArena != null) {
            abstractReferenceCountedByteBuf = poolArena.allocate(poolThreadCache, n2, n3);
        } else {
            abstractReferenceCountedByteBuf = PlatformDependent.hasUnsafe() ? UnsafeByteBufUtil.newUnsafeDirectByteBuf(this, n2, n3, true) : new UnpooledDirectByteBuf(this, n2, n3, true);
            PooledByteBufAllocator.onAllocateBuffer(abstractReferenceCountedByteBuf, false, false);
        }
        return PooledByteBufAllocator.toLeakAwareBuffer(abstractReferenceCountedByteBuf);
    }

    public static boolean defaultDisableCacheFinalizersForFastThreadLocalThreads() {
        return DEFAULT_DISABLE_CACHE_FINALIZERS_FOR_FAST_THREAD_LOCAL_THREADS;
    }

    public static boolean isDirectMemoryCacheAlignmentSupported() {
        return PlatformDependent.hasUnsafe();
    }

    @Override
    public boolean isDirectBufferPooled() {
        return this.directArenas != null;
    }

    private static boolean useCacheFinalizers() {
        if (!PooledByteBufAllocator.defaultDisableCacheFinalizersForFastThreadLocalThreads()) {
            return true;
        }
        return FastThreadLocalThread.currentThreadWillCleanupFastThreadLocals();
    }

    @Deprecated
    public int numHeapArenas() {
        return this.heapArenaMetrics.size();
    }

    @Deprecated
    public int numDirectArenas() {
        return this.directArenaMetrics.size();
    }

    @Deprecated
    public int numThreadLocalCaches() {
        return Math.max(PooledByteBufAllocator.numThreadLocalCaches(this.heapArenas), PooledByteBufAllocator.numThreadLocalCaches(this.directArenas));
    }

    private static int numThreadLocalCaches(PoolArena<?>[] poolArenaArray) {
        if (poolArenaArray == null) {
            return 0;
        }
        int n2 = 0;
        for (PoolArena<?> poolArena : poolArenaArray) {
            n2 += poolArena.numThreadCaches.get();
        }
        return n2;
    }

    @Deprecated
    public int smallCacheSize() {
        return this.smallCacheSize;
    }

    @Deprecated
    public int normalCacheSize() {
        return this.normalCacheSize;
    }

    @Deprecated
    public final int chunkSize() {
        return this.chunkSize;
    }

    final long usedHeapMemory() {
        return PooledByteBufAllocator.usedMemory(this.heapArenas);
    }

    final long usedDirectMemory() {
        return PooledByteBufAllocator.usedMemory(this.directArenas);
    }

    private static long usedMemory(PoolArena<?>[] poolArenaArray) {
        if (poolArenaArray == null) {
            return -1L;
        }
        long l2 = 0L;
        for (PoolArena<?> poolArena : poolArenaArray) {
            if ((l2 += poolArena.numActiveBytes()) >= 0L) continue;
            return Long.MAX_VALUE;
        }
        return l2;
    }

    final PoolThreadCache threadCache() {
        PoolThreadCache poolThreadCache = (PoolThreadCache)this.threadCache.get();
        assert (poolThreadCache != null);
        return poolThreadCache;
    }

    public boolean trimCurrentThreadCache() {
        PoolThreadCache poolThreadCache = (PoolThreadCache)this.threadCache.getIfExists();
        if (poolThreadCache != null) {
            poolThreadCache.trim();
            return true;
        }
        return false;
    }

    static void onAllocateBuffer(AbstractByteBuf abstractByteBuf, boolean bl2, boolean bl3) {
        AllocateBufferEvent allocateBufferEvent;
        if (PlatformDependent.isJfrEnabled() && AllocateBufferEvent.isEventEnabled() && (allocateBufferEvent = new AllocateBufferEvent()).shouldCommit()) {
            allocateBufferEvent.fill(abstractByteBuf, PooledByteBufAllocator.class);
            allocateBufferEvent.chunkPooled = bl2;
            allocateBufferEvent.chunkThreadLocal = bl3;
            allocateBufferEvent.commit();
        }
    }

    static void onDeallocateBuffer(AbstractByteBuf abstractByteBuf) {
        FreeBufferEvent freeBufferEvent;
        if (PlatformDependent.isJfrEnabled() && FreeBufferEvent.isEventEnabled() && (freeBufferEvent = new FreeBufferEvent()).shouldCommit()) {
            freeBufferEvent.fill(abstractByteBuf, PooledByteBufAllocator.class);
            freeBufferEvent.commit();
        }
    }

    static void onReallocateBuffer(AbstractByteBuf abstractByteBuf, int n2) {
        ReallocateBufferEvent reallocateBufferEvent;
        if (PlatformDependent.isJfrEnabled() && ReallocateBufferEvent.isEventEnabled() && (reallocateBufferEvent = new ReallocateBufferEvent()).shouldCommit()) {
            reallocateBufferEvent.fill(abstractByteBuf, PooledByteBufAllocator.class);
            reallocateBufferEvent.newCapacity = n2;
            reallocateBufferEvent.commit();
        }
    }

    static void onAllocateChunk(ChunkInfo chunkInfo, boolean bl2) {
        AllocateChunkEvent allocateChunkEvent;
        if (PlatformDependent.isJfrEnabled() && AllocateChunkEvent.isEventEnabled() && (allocateChunkEvent = new AllocateChunkEvent()).shouldCommit()) {
            allocateChunkEvent.fill(chunkInfo, PooledByteBufAllocator.class);
            allocateChunkEvent.pooled = bl2;
            allocateChunkEvent.threadLocal = false;
            allocateChunkEvent.commit();
        }
    }

    static void onDeallocateChunk(ChunkInfo chunkInfo, boolean bl2) {
        FreeChunkEvent freeChunkEvent;
        if (PlatformDependent.isJfrEnabled() && FreeChunkEvent.isEventEnabled() && (freeChunkEvent = new FreeChunkEvent()).shouldCommit()) {
            freeChunkEvent.fill(chunkInfo, PooledByteBufAllocator.class);
            freeChunkEvent.pooled = bl2;
            freeChunkEvent.commit();
        }
    }

    static {
        int n2 = SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.allocator.directMemoryCacheAlignment", 0);
        int n3 = SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.allocator.pageSize", 8192);
        Throwable throwable = null;
        try {
            PooledByteBufAllocator.validateAndCalculatePageShifts(n3, n2);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            n3 = 8192;
            n2 = 0;
        }
        DEFAULT_PAGE_SIZE = n3;
        DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT = n2;
        int n4 = SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.allocator.maxOrder", 9);
        Throwable throwable3 = null;
        try {
            PooledByteBufAllocator.validateAndCalculateChunkSize(DEFAULT_PAGE_SIZE, n4);
        }
        catch (Throwable throwable4) {
            throwable3 = throwable4;
            n4 = 9;
        }
        DEFAULT_MAX_ORDER = n4;
        Runtime runtime = Runtime.getRuntime();
        int n5 = NettyRuntime.availableProcessors() * 2;
        int n6 = DEFAULT_PAGE_SIZE << DEFAULT_MAX_ORDER;
        DEFAULT_NUM_HEAP_ARENA = Math.max(0, SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.allocator.numHeapArenas", (int)Math.min((long)n5, runtime.maxMemory() / (long)n6 / 2L / 3L)));
        DEFAULT_NUM_DIRECT_ARENA = Math.max(0, SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.allocator.numDirectArenas", (int)Math.min((long)n5, PlatformDependent.maxDirectMemory() / (long)n6 / 2L / 3L)));
        DEFAULT_SMALL_CACHE_SIZE = SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.allocator.smallCacheSize", 256);
        DEFAULT_NORMAL_CACHE_SIZE = SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.allocator.normalCacheSize", 64);
        DEFAULT_MAX_CACHED_BUFFER_CAPACITY = SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.allocator.maxCachedBufferCapacity", 32768);
        DEFAULT_CACHE_TRIM_INTERVAL = SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.allocator.cacheTrimInterval", 8192);
        if (SystemPropertyUtil.contains("com.gradle.maven.extension.internal.dep.io.netty.allocation.cacheTrimIntervalMillis")) {
            logger.warn("-Dio.netty.allocation.cacheTrimIntervalMillis is deprecated, use -Dio.netty.allocator.cacheTrimIntervalMillis");
            DEFAULT_CACHE_TRIM_INTERVAL_MILLIS = SystemPropertyUtil.contains("com.gradle.maven.extension.internal.dep.io.netty.allocator.cacheTrimIntervalMillis") ? SystemPropertyUtil.getLong("com.gradle.maven.extension.internal.dep.io.netty.allocator.cacheTrimIntervalMillis", 0L) : SystemPropertyUtil.getLong("com.gradle.maven.extension.internal.dep.io.netty.allocation.cacheTrimIntervalMillis", 0L);
        } else {
            DEFAULT_CACHE_TRIM_INTERVAL_MILLIS = SystemPropertyUtil.getLong("com.gradle.maven.extension.internal.dep.io.netty.allocator.cacheTrimIntervalMillis", 0L);
        }
        DEFAULT_USE_CACHE_FOR_ALL_THREADS = SystemPropertyUtil.getBoolean("com.gradle.maven.extension.internal.dep.io.netty.allocator.useCacheForAllThreads", false);
        DEFAULT_DISABLE_CACHE_FINALIZERS_FOR_FAST_THREAD_LOCAL_THREADS = SystemPropertyUtil.getBoolean("com.gradle.maven.extension.internal.dep.io.netty.allocator.disableCacheFinalizersForFastThreadLocalThreads", false);
        DEFAULT_MAX_CACHED_BYTEBUFFERS_PER_CHUNK = SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.allocator.maxCachedByteBuffersPerChunk", 1023);
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.allocator.numHeapArenas: {}", (Object)DEFAULT_NUM_HEAP_ARENA);
            logger.debug("-Dio.netty.allocator.numDirectArenas: {}", (Object)DEFAULT_NUM_DIRECT_ARENA);
            if (throwable == null) {
                logger.debug("-Dio.netty.allocator.pageSize: {}", (Object)DEFAULT_PAGE_SIZE);
            } else {
                logger.debug("-Dio.netty.allocator.pageSize: {}", (Object)DEFAULT_PAGE_SIZE, (Object)throwable);
            }
            if (throwable3 == null) {
                logger.debug("-Dio.netty.allocator.maxOrder: {}", (Object)DEFAULT_MAX_ORDER);
            } else {
                logger.debug("-Dio.netty.allocator.maxOrder: {}", (Object)DEFAULT_MAX_ORDER, (Object)throwable3);
            }
            logger.debug("-Dio.netty.allocator.chunkSize: {}", (Object)(DEFAULT_PAGE_SIZE << DEFAULT_MAX_ORDER));
            logger.debug("-Dio.netty.allocator.smallCacheSize: {}", (Object)DEFAULT_SMALL_CACHE_SIZE);
            logger.debug("-Dio.netty.allocator.normalCacheSize: {}", (Object)DEFAULT_NORMAL_CACHE_SIZE);
            logger.debug("-Dio.netty.allocator.maxCachedBufferCapacity: {}", (Object)DEFAULT_MAX_CACHED_BUFFER_CAPACITY);
            logger.debug("-Dio.netty.allocator.cacheTrimInterval: {}", (Object)DEFAULT_CACHE_TRIM_INTERVAL);
            logger.debug("-Dio.netty.allocator.cacheTrimIntervalMillis: {}", (Object)DEFAULT_CACHE_TRIM_INTERVAL_MILLIS);
            logger.debug("-Dio.netty.allocator.useCacheForAllThreads: {}", (Object)DEFAULT_USE_CACHE_FOR_ALL_THREADS);
            logger.debug("-Dio.netty.allocator.maxCachedByteBuffersPerChunk: {}", (Object)DEFAULT_MAX_CACHED_BYTEBUFFERS_PER_CHUNK);
            logger.debug("-Dio.netty.allocator.disableCacheFinalizersForFastThreadLocalThreads: {}", (Object)DEFAULT_DISABLE_CACHE_FINALIZERS_FOR_FAST_THREAD_LOCAL_THREADS);
        }
        DEFAULT = new PooledByteBufAllocator(!PlatformDependent.isExplicitNoPreferDirect());
    }

    private final class PoolThreadLocalCache
    extends FastThreadLocal<PoolThreadCache> {
        private final boolean useCacheForAllThreads;

        PoolThreadLocalCache(boolean bl2) {
            this.useCacheForAllThreads = bl2;
        }

        @Override
        protected synchronized PoolThreadCache initialValue() {
            PoolArena<byte[]> poolArena = this.leastUsedArena(PooledByteBufAllocator.this.heapArenas);
            PoolArena<ByteBuffer> poolArena2 = this.leastUsedArena(PooledByteBufAllocator.this.directArenas);
            Thread thread = Thread.currentThread();
            EventExecutor eventExecutor = ThreadExecutorMap.currentExecutor();
            if (this.useCacheForAllThreads || FastThreadLocalThread.currentThreadHasFastThreadLocal() || eventExecutor != null) {
                PoolThreadCache poolThreadCache = new PoolThreadCache(poolArena, poolArena2, PooledByteBufAllocator.this.smallCacheSize, PooledByteBufAllocator.this.normalCacheSize, DEFAULT_MAX_CACHED_BUFFER_CAPACITY, DEFAULT_CACHE_TRIM_INTERVAL, PooledByteBufAllocator.useCacheFinalizers());
                if (DEFAULT_CACHE_TRIM_INTERVAL_MILLIS > 0L && eventExecutor != null) {
                    eventExecutor.scheduleAtFixedRate(PooledByteBufAllocator.this.trimTask, DEFAULT_CACHE_TRIM_INTERVAL_MILLIS, DEFAULT_CACHE_TRIM_INTERVAL_MILLIS, TimeUnit.MILLISECONDS);
                }
                return poolThreadCache;
            }
            return new PoolThreadCache(poolArena, poolArena2, 0, 0, 0, 0, false);
        }

        @Override
        protected void onRemoval(PoolThreadCache poolThreadCache) {
            poolThreadCache.free(false);
        }

        private <T> PoolArena<T> leastUsedArena(PoolArena<T>[] poolArenaArray) {
            if (poolArenaArray == null || poolArenaArray.length == 0) {
                return null;
            }
            PoolArena<T> poolArena = poolArenaArray[0];
            if (poolArena.numThreadCaches.get() == 0) {
                return poolArena;
            }
            for (int i2 = 1; i2 < poolArenaArray.length; ++i2) {
                PoolArena<T> poolArena2 = poolArenaArray[i2];
                if (poolArena2.numThreadCaches.get() >= poolArena.numThreadCaches.get()) continue;
                poolArena = poolArena2;
            }
            return poolArena;
        }
    }
}

