/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.bootstrap;

import com.gradle.maven.extension.internal.dep.io.netty.bootstrap.AbstractBootstrap;
import com.gradle.maven.extension.internal.dep.io.netty.bootstrap.BootstrapConfig;
import com.gradle.maven.extension.internal.dep.io.netty.bootstrap.ChannelInitializerExtension;
import com.gradle.maven.extension.internal.dep.io.netty.channel.Channel;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelFuture;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelFutureListener;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPipeline;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.channel.EventLoop;
import com.gradle.maven.extension.internal.dep.io.netty.resolver.AddressResolver;
import com.gradle.maven.extension.internal.dep.io.netty.resolver.AddressResolverGroup;
import com.gradle.maven.extension.internal.dep.io.netty.resolver.DefaultAddressResolverGroup;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.Future;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.FutureListener;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.GenericFutureListener;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;

public class Bootstrap
extends AbstractBootstrap<Bootstrap, Channel> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Bootstrap.class);
    private final BootstrapConfig config = new BootstrapConfig(this);
    private ExternalAddressResolver externalResolver;
    private volatile boolean disableResolver;
    private volatile SocketAddress remoteAddress;

    public Bootstrap() {
    }

    private Bootstrap(Bootstrap bootstrap) {
        super(bootstrap);
        this.externalResolver = bootstrap.externalResolver;
        this.disableResolver = bootstrap.disableResolver;
        this.remoteAddress = bootstrap.remoteAddress;
    }

    public ChannelFuture connect(String string, int n2) {
        return this.connect(InetSocketAddress.createUnresolved(string, n2));
    }

    public ChannelFuture connect(SocketAddress socketAddress) {
        ObjectUtil.checkNotNull(socketAddress, "remoteAddress");
        this.validate();
        return this.doResolveAndConnect(socketAddress, this.config.localAddress());
    }

    private ChannelFuture doResolveAndConnect(final SocketAddress socketAddress, final SocketAddress socketAddress2) {
        ChannelFuture channelFuture = this.initAndRegister();
        final Channel channel = channelFuture.channel();
        if (channelFuture.isDone()) {
            if (!channelFuture.isSuccess()) {
                return channelFuture;
            }
            return this.doResolveAndConnect0(channel, socketAddress, socketAddress2, channel.newPromise());
        }
        final AbstractBootstrap.PendingRegistrationPromise pendingRegistrationPromise = new AbstractBootstrap.PendingRegistrationPromise(channel);
        channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                Throwable throwable = channelFuture.cause();
                if (throwable != null) {
                    pendingRegistrationPromise.setFailure(throwable);
                } else {
                    pendingRegistrationPromise.registered();
                    Bootstrap.this.doResolveAndConnect0(channel, socketAddress, socketAddress2, pendingRegistrationPromise);
                }
            }
        });
        return pendingRegistrationPromise;
    }

    private ChannelFuture doResolveAndConnect0(final Channel channel, SocketAddress socketAddress, final SocketAddress socketAddress2, final ChannelPromise channelPromise) {
        try {
            AddressResolver<SocketAddress> addressResolver;
            if (this.disableResolver) {
                Bootstrap.doConnect(socketAddress, socketAddress2, channelPromise);
                return channelPromise;
            }
            EventLoop eventLoop = channel.eventLoop();
            try {
                addressResolver = ExternalAddressResolver.getOrDefault(this.externalResolver).getResolver(eventLoop);
            }
            catch (Throwable throwable) {
                channel.close();
                return channelPromise.setFailure(throwable);
            }
            if (!addressResolver.isSupported(socketAddress) || addressResolver.isResolved(socketAddress)) {
                Bootstrap.doConnect(socketAddress, socketAddress2, channelPromise);
                return channelPromise;
            }
            Future<SocketAddress> future = addressResolver.resolve(socketAddress);
            if (future.isDone()) {
                Throwable throwable = future.cause();
                if (throwable != null) {
                    channel.close();
                    channelPromise.setFailure(throwable);
                } else {
                    Bootstrap.doConnect(future.getNow(), socketAddress2, channelPromise);
                }
                return channelPromise;
            }
            future.addListener((GenericFutureListener<Future<SocketAddress>>)new FutureListener<SocketAddress>(){

                public void operationComplete(Future<SocketAddress> future) throws Exception {
                    if (future.cause() != null) {
                        channel.close();
                        channelPromise.setFailure(future.cause());
                    } else {
                        Bootstrap.doConnect(future.getNow(), socketAddress2, channelPromise);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            channelPromise.tryFailure(throwable);
        }
        return channelPromise;
    }

    private static void doConnect(final SocketAddress socketAddress, final SocketAddress socketAddress2, final ChannelPromise channelPromise) {
        final Channel channel = channelPromise.channel();
        channel.eventLoop().execute(new Runnable(){

            @Override
            public void run() {
                if (socketAddress2 == null) {
                    channel.connect(socketAddress, channelPromise);
                } else {
                    channel.connect(socketAddress, socketAddress2, channelPromise);
                }
                channelPromise.addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
            }
        });
    }

    @Override
    void init(Channel channel) throws Throwable {
        ChannelPipeline channelPipeline = channel.pipeline();
        channelPipeline.addLast(this.config.handler());
        Bootstrap.setChannelOptions(channel, this.newOptionsArray(), logger);
        Bootstrap.setAttributes(channel, this.newAttributesArray());
        Collection<ChannelInitializerExtension> collection = this.getInitializerExtensions();
        if (!collection.isEmpty()) {
            for (ChannelInitializerExtension channelInitializerExtension : collection) {
                try {
                    channelInitializerExtension.postInitializeClientChannel(channel);
                }
                catch (Exception exception) {
                    logger.warn("Exception thrown from postInitializeClientChannel", exception);
                }
            }
        }
    }

    @Override
    public Bootstrap validate() {
        super.validate();
        if (this.config.handler() == null) {
            throw new IllegalStateException("handler not set");
        }
        return this;
    }

    @Override
    public Bootstrap clone() {
        return new Bootstrap(this);
    }

    public final BootstrapConfig config() {
        return this.config;
    }

    final SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    final AddressResolverGroup<?> resolver() {
        if (this.disableResolver) {
            return null;
        }
        return ExternalAddressResolver.getOrDefault(this.externalResolver);
    }

    static final class ExternalAddressResolver {
        final AddressResolverGroup<SocketAddress> resolverGroup;

        static AddressResolverGroup<SocketAddress> getOrDefault(ExternalAddressResolver externalAddressResolver) {
            if (externalAddressResolver == null) {
                DefaultAddressResolverGroup defaultAddressResolverGroup = DefaultAddressResolverGroup.INSTANCE;
                return defaultAddressResolverGroup;
            }
            return externalAddressResolver.resolverGroup;
        }
    }
}

