/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.dev.failsafe.spi;

import com.gradle.maven.extension.internal.dep.dev.failsafe.ExecutionContext;
import com.gradle.maven.extension.internal.dep.dev.failsafe.Policy;
import com.gradle.maven.extension.internal.dep.dev.failsafe.internal.EventHandler;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.AsyncExecutionInternal;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.ExecutionInternal;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.ExecutionResult;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.FailsafeFuture;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.FailurePolicy;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.Scheduler;
import com.gradle.maven.extension.internal.dep.dev.failsafe.spi.SyncExecutionInternal;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public abstract class PolicyExecutor<R> {
    private final int policyIndex;
    private final FailurePolicy<R> failurePolicy;
    private final EventHandler<R> successHandler;
    private final EventHandler<R> failureHandler;

    protected PolicyExecutor(Policy<R> policy, int n2) {
        this.policyIndex = n2;
        this.failurePolicy = policy instanceof FailurePolicy ? (FailurePolicy)policy : null;
        this.successHandler = EventHandler.ofExecutionCompleted(policy.getConfig().getSuccessListener());
        this.failureHandler = EventHandler.ofExecutionCompleted(policy.getConfig().getFailureListener());
    }

    public int getPolicyIndex() {
        return this.policyIndex;
    }

    protected ExecutionResult<R> preExecute() {
        return null;
    }

    protected CompletableFuture<ExecutionResult<R>> preExecuteAsync(Scheduler scheduler, FailsafeFuture<R> failsafeFuture) {
        ExecutionResult<R> executionResult = this.preExecute();
        return executionResult == null ? null : CompletableFuture.completedFuture(executionResult);
    }

    public Function<SyncExecutionInternal<R>, ExecutionResult<R>> apply(Function<SyncExecutionInternal<R>, ExecutionResult<R>> function, Scheduler scheduler) {
        return syncExecutionInternal -> {
            ExecutionResult<R> executionResult = this.preExecute();
            if (executionResult != null) {
                syncExecutionInternal.preExecute();
                return executionResult;
            }
            return this.postExecute((ExecutionInternal<R>)syncExecutionInternal, (ExecutionResult)function.apply((SyncExecutionInternal<R>)syncExecutionInternal));
        };
    }

    public Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> applyAsync(Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> function, Scheduler scheduler, FailsafeFuture<R> failsafeFuture) {
        return asyncExecutionInternal -> {
            CompletableFuture<ExecutionResult<R>> completableFuture;
            CompletableFuture completableFuture2 = new CompletableFuture();
            Runnable runnable = () -> ((CompletableFuture)((CompletableFuture)function.apply((AsyncExecutionInternal<R>)asyncExecutionInternal)).thenCompose(executionResult -> executionResult == null ? ExecutionResult.nullFuture() : this.postExecuteAsync((AsyncExecutionInternal<R>)asyncExecutionInternal, (ExecutionResult<R>)executionResult, scheduler, failsafeFuture))).whenComplete((executionResult, throwable) -> {
                if (throwable != null) {
                    completableFuture2.completeExceptionally((Throwable)throwable);
                } else {
                    completableFuture2.complete(executionResult);
                }
            });
            if (!asyncExecutionInternal.isRecorded() && (completableFuture = this.preExecuteAsync(scheduler, failsafeFuture)) != null) {
                completableFuture.whenComplete((executionResult, throwable) -> {
                    if (throwable != null) {
                        completableFuture2.completeExceptionally((Throwable)throwable);
                    } else if (executionResult != null) {
                        if (executionResult.isNonResult()) {
                            runnable.run();
                        } else {
                            asyncExecutionInternal.preExecute();
                            completableFuture2.complete(executionResult);
                        }
                    } else {
                        completableFuture2.complete(null);
                    }
                });
                return completableFuture2;
            }
            runnable.run();
            return completableFuture2;
        };
    }

    public ExecutionResult<R> postExecute(ExecutionInternal<R> executionInternal, ExecutionResult<R> executionResult) {
        executionInternal.recordAttempt();
        if (this.isFailure(executionResult)) {
            executionResult = this.onFailure(executionInternal, executionResult.withException());
            this.handleFailure(executionResult, executionInternal);
        } else {
            executionResult = executionResult.withSuccess();
            this.onSuccess(executionResult);
            this.handleSuccess(executionResult, executionInternal);
        }
        return executionResult;
    }

    protected synchronized CompletableFuture<ExecutionResult<R>> postExecuteAsync(AsyncExecutionInternal<R> asyncExecutionInternal, ExecutionResult<R> executionResult2, Scheduler scheduler, FailsafeFuture<R> failsafeFuture) {
        CompletableFuture<ExecutionResult<R>> completableFuture = null;
        if (!asyncExecutionInternal.isAsyncExecution() || !asyncExecutionInternal.isPostExecuted(this.policyIndex)) {
            asyncExecutionInternal.recordAttempt();
            if (this.isFailure(executionResult2)) {
                completableFuture = this.onFailureAsync(asyncExecutionInternal, executionResult2.withException(), scheduler, failsafeFuture).whenComplete((executionResult, throwable) -> this.handleFailure((ExecutionResult<R>)executionResult, asyncExecutionInternal));
            } else {
                executionResult2 = executionResult2.withSuccess();
                this.onSuccess(executionResult2);
                this.handleSuccess(executionResult2, asyncExecutionInternal);
                completableFuture = CompletableFuture.completedFuture(executionResult2);
            }
            if (asyncExecutionInternal.isAsyncExecution()) {
                asyncExecutionInternal.setPostExecuted(this.policyIndex);
            }
        }
        return completableFuture;
    }

    protected boolean isFailure(ExecutionResult<R> executionResult) {
        if (executionResult.isNonResult()) {
            return false;
        }
        if (this.failurePolicy != null) {
            return this.failurePolicy.isFailure(executionResult.getResult(), executionResult.getException());
        }
        return executionResult.getException() != null;
    }

    protected void onSuccess(ExecutionResult<R> executionResult) {
    }

    protected ExecutionResult<R> onFailure(ExecutionContext<R> executionContext, ExecutionResult<R> executionResult) {
        return executionResult;
    }

    protected CompletableFuture<ExecutionResult<R>> onFailureAsync(ExecutionContext<R> executionContext, ExecutionResult<R> executionResult, Scheduler scheduler, FailsafeFuture<R> failsafeFuture) {
        try {
            return CompletableFuture.completedFuture(this.onFailure(executionContext, executionResult));
        }
        catch (Throwable throwable) {
            CompletableFuture<ExecutionResult<R>> completableFuture = new CompletableFuture<ExecutionResult<R>>();
            completableFuture.completeExceptionally(throwable);
            return completableFuture;
        }
    }

    private void handleSuccess(ExecutionResult<R> executionResult, ExecutionContext<R> executionContext) {
        if (this.successHandler != null && executionResult.isComplete()) {
            this.successHandler.handle(executionResult, executionContext);
        }
    }

    private void handleFailure(ExecutionResult<R> executionResult, ExecutionContext<R> executionContext) {
        if (this.failureHandler != null && executionResult.isComplete()) {
            this.failureHandler.handle(executionResult, executionContext);
        }
    }
}

