/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaAnnotatedElement;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaConstructor;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaParameter;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaType;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaTypeVariable;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaExecutable;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaType;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DefaultJavaConstructor
extends DefaultJavaExecutable
implements JavaConstructor {
    private List<JavaTypeVariable<JavaConstructor>> typeParameters = Collections.emptyList();

    public void setTypeParameters(List<JavaTypeVariable<JavaConstructor>> list) {
        this.typeParameters = list;
    }

    public List<JavaTypeVariable<JavaConstructor>> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public boolean signatureMatches(List<JavaType> list, boolean bl2) {
        return super.signatureMatches(list, bl2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isPrivate()) {
            stringBuilder.append("private ");
        } else if (this.isProtected()) {
            stringBuilder.append("protected ");
        } else if (this.isPublic()) {
            stringBuilder.append("public ");
        }
        if (this.getDeclaringClass() != null) {
            stringBuilder.append(this.getDeclaringClass().getFullyQualifiedName());
        }
        stringBuilder.append("(");
        Iterator<JavaAnnotatedElement> iterator = this.getParameters().iterator();
        while (iterator.hasNext()) {
            String string = DefaultJavaType.getResolvedValue(iterator.next().getType(), this.getTypeParameters());
            stringBuilder.append(string);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        if (this.getExceptions().size() > 0) {
            stringBuilder.append(" throws ");
            iterator = this.getExceptions().iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(((JavaClass)iterator.next()).getValue());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(",");
            }
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n2 = 3 + this.getName().hashCode();
        return n2 *= 31 + this.getParameters().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JavaConstructor)) {
            return false;
        }
        JavaConstructor javaConstructor = (JavaConstructor)object;
        if (javaConstructor.getDeclaringClass() != null ? !javaConstructor.getDeclaringClass().equals(this.getDeclaringClass()) : this.getDeclaringClass() != null) {
            return false;
        }
        if (!javaConstructor.getName().equals(this.getName())) {
            return false;
        }
        List<JavaParameter> list = this.getParameters();
        List<JavaParameter> list2 = javaConstructor.getParameters();
        if (list2.size() != list.size()) {
            return false;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (list2.get(i2).equals(list.get(i2))) continue;
            return false;
        }
        return this.isVarArgs() == javaConstructor.isVarArgs();
    }
}

