/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.builder.Builder;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library.AbstractClassLibrary;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library.ErrorHandler;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaPackage;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaPackage;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.JavaLexer;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.ParseException;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.impl.BinaryClassParser;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.impl.JFlexLexer;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.impl.Parser;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ClassLoaderLibrary
extends AbstractClassLibrary {
    private transient List<ClassLoader> classLoaders = new LinkedList<ClassLoader>();
    private boolean defaultClassLoadersAdded = false;
    private boolean debugLexer;
    private boolean debugParser;
    private ErrorHandler errorHandler;

    public ClassLoaderLibrary(AbstractClassLibrary abstractClassLibrary) {
        super(abstractClassLibrary);
    }

    public void addDefaultLoader() {
        if (!this.defaultClassLoadersAdded) {
            this.classLoaders.add(this.getClass().getClassLoader());
            this.classLoaders.add(Thread.currentThread().getContextClassLoader());
        }
        this.defaultClassLoadersAdded = true;
    }

    @Override
    protected JavaClass resolveJavaClass(String string) {
        JavaClass javaClass = null;
        for (ClassLoader classLoader : this.classLoaders) {
            Object object;
            Object object2;
            Class<?> clazz;
            InputStream inputStream;
            String string2 = string;
            if (string2.indexOf(36) > 0) {
                string2 = string2.split("$")[0];
            }
            if ((inputStream = classLoader.getResourceAsStream(string2 = string2.replace('.', '/') + ".java")) != null) {
                clazz = this.getModelBuilder();
                object2 = new JFlexLexer(inputStream);
                object = new Parser((JavaLexer)object2, (Builder)((Object)clazz));
                ((Parser)object).setDebugLexer(this.debugLexer);
                ((Parser)object).setDebugParser(this.debugParser);
                try {
                    if (((Parser)object).parse()) {
                        javaClass = clazz.getSource().getClassByName(string);
                        break;
                    }
                }
                catch (ParseException parseException) {
                    parseException.setSourceInfo(string2);
                    if (this.errorHandler != null) {
                        this.errorHandler.handle(parseException);
                    }
                    throw parseException;
                }
            }
            if (javaClass != null) continue;
            try {
                clazz = classLoader.loadClass(string);
                if (clazz.getDeclaringClass() != null) {
                    clazz = clazz.getDeclaringClass();
                }
                if (!((BinaryClassParser)(object = new BinaryClassParser(clazz, (Builder)(object2 = this.getModelBuilder())))).parse()) continue;
                javaClass = object2.getSource().getClassByName(string);
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return javaClass;
    }

    @Override
    protected JavaPackage resolveJavaPackage(String string) {
        DefaultJavaPackage defaultJavaPackage = null;
        Package package_ = Package.getPackage(string);
        if (package_ != null) {
            defaultJavaPackage = new DefaultJavaPackage(string);
            defaultJavaPackage.setClassLibrary(this);
        }
        return defaultJavaPackage;
    }

    @Override
    protected boolean containsClassReference(String string) {
        boolean bl2 = false;
        Iterator<ClassLoader> iterator = this.classLoaders.iterator();
        while (!bl2 && iterator.hasNext()) {
            ClassLoader classLoader = iterator.next();
            try {
                Class<?> clazz = classLoader.loadClass(string);
                bl2 = clazz != null;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return bl2;
    }
}

