/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Equivalence;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Interner;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.MapMaker;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.MapMakerInternalMap;

public final class Interners {
    public static InternerBuilder newBuilder() {
        return new InternerBuilder();
    }

    public static <E> Interner<E> newWeakInterner() {
        return Interners.newBuilder().weak().build();
    }

    public static class InternerBuilder {
        private final MapMaker mapMaker = new MapMaker();
        private boolean strong = true;

        private InternerBuilder() {
        }

        public InternerBuilder weak() {
            this.strong = false;
            return this;
        }

        public <E> Interner<E> build() {
            if (!this.strong) {
                this.mapMaker.weakKeys();
            }
            return new InternerImpl(this.mapMaker);
        }
    }

    static final class InternerImpl<E>
    implements Interner<E> {
        final MapMakerInternalMap<E, MapMaker.Dummy, ?, ?> map;

        private InternerImpl(MapMaker mapMaker) {
            this.map = MapMakerInternalMap.createWithDummyValues(mapMaker.keyEquivalence(Equivalence.equals()));
        }

        @Override
        public E intern(E e2) {
            Object object;
            do {
                Object obj;
                if ((obj = this.map.getEntry(e2)) == null || (object = obj.getKey()) == null) continue;
                Object k2 = object;
                return (E)k2;
            } while ((object = this.map.putIfAbsent(e2, MapMaker.Dummy.VALUE)) != null);
            return e2;
        }
    }
}

