/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.ser;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.type.WritableTypeId;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;
import java.io.IOException;
import java.time.MonthDay;
import java.time.format.DateTimeFormatter;

public class MonthDaySerializer
extends JSR310FormattedSerializerBase<MonthDay> {
    public static final MonthDaySerializer INSTANCE = new MonthDaySerializer();

    protected MonthDaySerializer() {
        this((DateTimeFormatter)null);
    }

    public MonthDaySerializer(DateTimeFormatter dateTimeFormatter) {
        super(MonthDay.class, dateTimeFormatter);
    }

    private MonthDaySerializer(MonthDaySerializer monthDaySerializer, Boolean bl2, DateTimeFormatter dateTimeFormatter) {
        super(monthDaySerializer, bl2, dateTimeFormatter, null);
    }

    protected MonthDaySerializer withFormat(Boolean bl2, DateTimeFormatter dateTimeFormatter, JsonFormat.Shape shape) {
        return new MonthDaySerializer(this, bl2, dateTimeFormatter);
    }

    @Override
    public void serialize(MonthDay monthDay, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this._useTimestampExplicitOnly(serializerProvider)) {
            jsonGenerator.writeStartArray();
            this._serializeAsArrayContents(monthDay, jsonGenerator, serializerProvider);
            jsonGenerator.writeEndArray();
        } else {
            jsonGenerator.writeString(this._formatter == null ? monthDay.toString() : monthDay.format(this._formatter));
        }
    }

    @Override
    public void serializeWithType(MonthDay monthDay, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(monthDay, this.serializationShape(serializerProvider)));
        if (writableTypeId != null && writableTypeId.valueShape == JsonToken.START_ARRAY) {
            this._serializeAsArrayContents(monthDay, jsonGenerator, serializerProvider);
        } else {
            jsonGenerator.writeString(this._formatter == null ? monthDay.toString() : monthDay.format(this._formatter));
        }
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    protected void _serializeAsArrayContents(MonthDay monthDay, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeNumber(monthDay.getMonthValue());
        jsonGenerator.writeNumber(monthDay.getDayOfMonth());
    }

    @Override
    protected JsonToken serializationShape(SerializerProvider serializerProvider) {
        return this._useTimestampExplicitOnly(serializerProvider) ? JsonToken.START_ARRAY : JsonToken.VALUE_STRING;
    }
}

