/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.IOException;
import java.time.Month;

public class OneBasedMonthDeserializer
extends DelegatingDeserializer {
    public OneBasedMonthDeserializer(JsonDeserializer<?> jsonDeserializer) {
        super(jsonDeserializer);
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        switch (jsonParser.currentToken()) {
            case VALUE_NUMBER_INT: {
                return this._decodeMonth(jsonParser.getIntValue(), jsonParser);
            }
            case VALUE_STRING: {
                String string = jsonParser.getText();
                int n2 = this._decodeNumber(string);
                if (n2 < 0) break;
                return this._decodeMonth(n2, jsonParser);
            }
        }
        return this.getDelegatee().deserialize(jsonParser, deserializationContext);
    }

    private int _decodeNumber(String string) {
        int n2;
        switch (string.length()) {
            case 1: {
                char c2 = string.charAt(0);
                boolean bl2 = '0' <= c2 && c2 <= '9';
                n2 = bl2 ? c2 - 48 : -1;
                break;
            }
            case 2: {
                char c3 = string.charAt(0);
                char c4 = string.charAt(1);
                boolean bl3 = '0' <= c3 && c3 <= '9' && '0' <= c4 && c4 <= '9';
                n2 = bl3 ? 10 * (c3 - 48) + (c4 - 48) : -1;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        return n2;
    }

    private Month _decodeMonth(int n2, JsonParser jsonParser) throws InvalidFormatException {
        if (Month.JANUARY.getValue() <= n2 && n2 <= Month.DECEMBER.getValue()) {
            return Month.of(n2);
        }
        throw new InvalidFormatException(jsonParser, "Month number " + n2 + " not allowed for 1-based Month.", n2, Integer.class);
    }

    @Override
    protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> jsonDeserializer) {
        return new OneBasedMonthDeserializer(jsonDeserializer);
    }
}

