/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jdk14;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.PropertyName;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.PotentialCreator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.NativeImageUtil;
import java.lang.reflect.Method;
import java.util.List;

public class JDK14Util {
    public static String[] getRecordFieldNames(Class<?> clazz) {
        return RecordAccessor.instance().getRecordFieldNames(clazz);
    }

    public static PotentialCreator findCanonicalRecordConstructor(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, List<PotentialCreator> list) {
        Object object;
        RawTypeName[] rawTypeNameArray = RecordAccessor.instance().getRecordFields(annotatedClass.getRawType());
        if (rawTypeNameArray == null) {
            return null;
        }
        int n2 = rawTypeNameArray.length;
        if (n2 == 0 && (object = annotatedClass.getDefaultConstructor()) != null) {
            return new PotentialCreator((AnnotatedWithParams)object, null);
        }
        block0: for (PotentialCreator potentialCreator : list) {
            if (potentialCreator.paramCount() != n2) continue;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!potentialCreator.creator().getRawParameterType(i2).equals(rawTypeNameArray[i2].rawType)) continue block0;
            }
            PropertyName[] propertyNameArray = new PropertyName[n2];
            for (int i3 = 0; i3 < n2; ++i3) {
                propertyNameArray[i3] = PropertyName.construct(rawTypeNameArray[i3].name);
            }
            return potentialCreator.introspectParamNames(mapperConfig, propertyNameArray);
        }
        throw new IllegalArgumentException("Failed to find the canonical Record constructor of type " + ClassUtil.getTypeDescription(annotatedClass.getType()));
    }

    static class RawTypeName {
        public final Class<?> rawType;
        public final String name;

        public RawTypeName(Class<?> clazz, String string) {
            this.rawType = clazz;
            this.name = string;
        }
    }

    static class RecordAccessor {
        private final Method RECORD_GET_RECORD_COMPONENTS;
        private final Method RECORD_COMPONENT_GET_NAME;
        private final Method RECORD_COMPONENT_GET_TYPE;
        private static final RecordAccessor INSTANCE;
        private static final RuntimeException PROBLEM;

        private RecordAccessor() throws RuntimeException {
            try {
                this.RECORD_GET_RECORD_COMPONENTS = Class.class.getMethod("getRecordComponents", new Class[0]);
                Class<?> clazz = Class.forName("java.lang.reflect.RecordComponent");
                this.RECORD_COMPONENT_GET_NAME = clazz.getMethod("getName", new Class[0]);
                this.RECORD_COMPONENT_GET_TYPE = clazz.getMethod("getType", new Class[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(String.format("Failed to access Methods needed to support `java.lang.Record`: (%s) %s", exception.getClass().getName(), exception.getMessage()), exception);
            }
        }

        public static RecordAccessor instance() {
            if (PROBLEM != null) {
                throw PROBLEM;
            }
            return INSTANCE;
        }

        public String[] getRecordFieldNames(Class<?> clazz) throws IllegalArgumentException {
            Object[] objectArray = this.recordComponents(clazz);
            if (objectArray == null) {
                return null;
            }
            String[] stringArray = new String[objectArray.length];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                try {
                    stringArray[i2] = (String)this.RECORD_COMPONENT_GET_NAME.invoke(objectArray[i2], new Object[0]);
                    continue;
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(String.format("Failed to access name of field #%d (of %d) of Record type %s", i2, objectArray.length, ClassUtil.nameOf(clazz)), exception);
                }
            }
            return stringArray;
        }

        public RawTypeName[] getRecordFields(Class<?> clazz) throws IllegalArgumentException {
            Object[] objectArray = this.recordComponents(clazz);
            if (objectArray == null) {
                return null;
            }
            RawTypeName[] rawTypeNameArray = new RawTypeName[objectArray.length];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Class clazz2;
                String string;
                try {
                    string = (String)this.RECORD_COMPONENT_GET_NAME.invoke(objectArray[i2], new Object[0]);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(String.format("Failed to access name of field #%d (of %d) of Record type %s", i2, objectArray.length, ClassUtil.nameOf(clazz)), exception);
                }
                try {
                    clazz2 = (Class)this.RECORD_COMPONENT_GET_TYPE.invoke(objectArray[i2], new Object[0]);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(String.format("Failed to access type of field #%d (of %d) of Record type %s", i2, objectArray.length, ClassUtil.nameOf(clazz)), exception);
                }
                rawTypeNameArray[i2] = new RawTypeName(clazz2, string);
            }
            return rawTypeNameArray;
        }

        protected Object[] recordComponents(Class<?> clazz) throws IllegalArgumentException {
            try {
                return (Object[])this.RECORD_GET_RECORD_COMPONENTS.invoke(clazz, new Object[0]);
            }
            catch (Exception exception) {
                if (NativeImageUtil.isUnsupportedFeatureError(exception)) {
                    return null;
                }
                throw new IllegalArgumentException("Failed to access RecordComponents of type " + ClassUtil.nameOf(clazz));
            }
        }

        static {
            RuntimeException runtimeException = null;
            RecordAccessor recordAccessor = null;
            try {
                recordAccessor = new RecordAccessor();
            }
            catch (RuntimeException runtimeException2) {
                runtimeException = runtimeException2;
            }
            INSTANCE = recordAccessor;
            PROBLEM = runtimeException;
        }
    }
}

