/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.KeyDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.MapperFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.LogicalType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.util.EnumMap;

public class EnumMapDeserializer
extends ContainerDeserializerBase<EnumMap<?, ?>>
implements ContextualDeserializer,
ResolvableDeserializer {
    protected final Class<?> _enumClass;
    protected KeyDeserializer _keyDeserializer;
    protected JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final ValueInstantiator _valueInstantiator;
    protected JsonDeserializer<Object> _delegateDeserializer;
    protected PropertyBasedCreator _propertyBasedCreator;

    public EnumMapDeserializer(JavaType javaType, ValueInstantiator valueInstantiator, KeyDeserializer keyDeserializer, JsonDeserializer<?> jsonDeserializer, TypeDeserializer typeDeserializer, NullValueProvider nullValueProvider) {
        super(javaType, nullValueProvider, null);
        this._enumClass = javaType.getKeyType().getRawClass();
        this._keyDeserializer = keyDeserializer;
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
        this._valueInstantiator = valueInstantiator;
    }

    protected EnumMapDeserializer(EnumMapDeserializer enumMapDeserializer, KeyDeserializer keyDeserializer, JsonDeserializer<?> jsonDeserializer, TypeDeserializer typeDeserializer, NullValueProvider nullValueProvider) {
        super(enumMapDeserializer, nullValueProvider, enumMapDeserializer._unwrapSingle);
        this._enumClass = enumMapDeserializer._enumClass;
        this._keyDeserializer = keyDeserializer;
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
        this._valueInstantiator = enumMapDeserializer._valueInstantiator;
        this._delegateDeserializer = enumMapDeserializer._delegateDeserializer;
        this._propertyBasedCreator = enumMapDeserializer._propertyBasedCreator;
    }

    public EnumMapDeserializer withResolved(KeyDeserializer keyDeserializer, JsonDeserializer<?> jsonDeserializer, TypeDeserializer typeDeserializer, NullValueProvider nullValueProvider) {
        if (keyDeserializer == this._keyDeserializer && nullValueProvider == this._nullProvider && jsonDeserializer == this._valueDeserializer && typeDeserializer == this._valueTypeDeserializer) {
            return this;
        }
        return new EnumMapDeserializer(this, keyDeserializer, jsonDeserializer, typeDeserializer, nullValueProvider);
    }

    @Override
    public void resolve(DeserializationContext deserializationContext) throws JsonMappingException {
        if (this._valueInstantiator != null) {
            if (this._valueInstantiator.canCreateUsingDelegate()) {
                JavaType javaType = this._valueInstantiator.getDelegateType(deserializationContext.getConfig());
                if (javaType == null) {
                    deserializationContext.reportBadDefinition(this._containerType, String.format("Invalid delegate-creator definition for %s: value instantiator (%s) returned true for 'canCreateUsingDelegate()', but null for 'getDelegateType()'", this._containerType, this._valueInstantiator.getClass().getName()));
                }
                this._delegateDeserializer = this.findDeserializer(deserializationContext, javaType, null);
            } else if (this._valueInstantiator.canCreateUsingArrayDelegate()) {
                JavaType javaType = this._valueInstantiator.getArrayDelegateType(deserializationContext.getConfig());
                if (javaType == null) {
                    deserializationContext.reportBadDefinition(this._containerType, String.format("Invalid delegate-creator definition for %s: value instantiator (%s) returned true for 'canCreateUsingArrayDelegate()', but null for 'getArrayDelegateType()'", this._containerType, this._valueInstantiator.getClass().getName()));
                }
                this._delegateDeserializer = this.findDeserializer(deserializationContext, javaType, null);
            } else if (this._valueInstantiator.canCreateFromObjectWith()) {
                SettableBeanProperty[] settableBeanPropertyArray = this._valueInstantiator.getFromObjectArguments(deserializationContext.getConfig());
                this._propertyBasedCreator = PropertyBasedCreator.construct(deserializationContext, this._valueInstantiator, settableBeanPropertyArray, deserializationContext.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES));
            }
        }
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        KeyDeserializer keyDeserializer = this._keyDeserializer;
        if (keyDeserializer == null) {
            keyDeserializer = deserializationContext.findKeyDeserializer(this._containerType.getKeyType(), beanProperty);
        }
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        JavaType javaType = this._containerType.getContentType();
        jsonDeserializer = jsonDeserializer == null ? deserializationContext.findContextualValueDeserializer(javaType, beanProperty) : deserializationContext.handleSecondaryContextualization(jsonDeserializer, beanProperty, javaType);
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        if (typeDeserializer != null) {
            typeDeserializer = typeDeserializer.forProperty(beanProperty);
        }
        return this.withResolved(keyDeserializer, jsonDeserializer, typeDeserializer, this.findContentNullProvider(deserializationContext, beanProperty, jsonDeserializer));
    }

    @Override
    public boolean isCachable() {
        return this._valueDeserializer == null && this._keyDeserializer == null && this._valueTypeDeserializer == null;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Map;
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        return this._valueDeserializer;
    }

    @Override
    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) throws JsonMappingException {
        return this.constructMap(deserializationContext);
    }

    @Override
    public EnumMap<?, ?> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (this._propertyBasedCreator != null) {
            return this._deserializeUsingProperties(jsonParser, deserializationContext);
        }
        if (this._delegateDeserializer != null) {
            return (EnumMap)this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        switch (jsonParser.currentTokenId()) {
            case 1: 
            case 2: 
            case 5: {
                return this.deserialize(jsonParser, deserializationContext, this.constructMap(deserializationContext));
            }
            case 6: {
                return (EnumMap)this._deserializeFromString(jsonParser, deserializationContext);
            }
            case 3: {
                return (EnumMap)this._deserializeFromArray(jsonParser, deserializationContext);
            }
        }
        return (EnumMap)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
    }

    @Override
    public EnumMap<?, ?> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, EnumMap enumMap) throws IOException {
        Enum enum_;
        String string;
        jsonParser.assignCurrentValue(enumMap);
        if (jsonParser.isExpectedStartObjectToken()) {
            string = jsonParser.nextFieldName();
        } else {
            enum_ = jsonParser.currentToken();
            if (enum_ != JsonToken.FIELD_NAME) {
                if (enum_ == JsonToken.END_OBJECT) {
                    return enumMap;
                }
                deserializationContext.reportWrongTokenException(this, JsonToken.FIELD_NAME, null, new Object[0]);
            }
            string = jsonParser.currentName();
        }
        while (string != null) {
            block12: {
                enum_ = (Enum)this._keyDeserializer.deserializeKey(string, deserializationContext);
                JsonToken jsonToken = jsonParser.nextToken();
                if (enum_ == null) {
                    if (!deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
                        return (EnumMap)deserializationContext.handleWeirdStringValue(this._enumClass, string, "value not one of declared Enum instance names for %s", this._containerType.getKeyType());
                    }
                    jsonParser.skipChildren();
                } else {
                    Object object;
                    block13: {
                        try {
                            if (jsonToken == JsonToken.VALUE_NULL) {
                                if (this._skipNullValues) break block12;
                                object = null;
                            } else {
                                object = this._deserializeNoNullChecks(jsonParser, deserializationContext);
                            }
                            if (object != null || (object = this._nullProvider.getNullValue(deserializationContext)) != null || !this._skipNullValues) break block13;
                            break block12;
                        }
                        catch (Exception exception) {
                            return (EnumMap)this.wrapAndThrow(deserializationContext, exception, enumMap, string);
                        }
                    }
                    enumMap.put(enum_, object);
                }
            }
            string = jsonParser.nextFieldName();
        }
        return enumMap;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromObject(jsonParser, deserializationContext);
    }

    protected EnumMap<?, ?> constructMap(DeserializationContext deserializationContext) throws JsonMappingException {
        if (this._valueInstantiator == null) {
            return new EnumMap(this._enumClass);
        }
        try {
            if (!this._valueInstantiator.canCreateUsingDefault()) {
                return (EnumMap)deserializationContext.handleMissingInstantiator(this.handledType(), this.getValueInstantiator(), null, "no default constructor found", new Object[0]);
            }
            return (EnumMap)this._valueInstantiator.createUsingDefault(deserializationContext);
        }
        catch (IOException iOException) {
            return (EnumMap)ClassUtil.throwAsMappingException(deserializationContext, iOException);
        }
    }

    public EnumMap<?, ?> _deserializeUsingProperties(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        PropertyBasedCreator propertyBasedCreator = this._propertyBasedCreator;
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext, null);
        String string = jsonParser.isExpectedStartObjectToken() ? jsonParser.nextFieldName() : (jsonParser.hasToken(JsonToken.FIELD_NAME) ? jsonParser.currentName() : null);
        while (string != null) {
            block15: {
                Object object;
                JsonToken jsonToken = jsonParser.nextToken();
                SettableBeanProperty settableBeanProperty = propertyBasedCreator.findCreatorProperty(string);
                if (settableBeanProperty != null) {
                    if (propertyValueBuffer.assignParameter(settableBeanProperty, settableBeanProperty.deserialize(jsonParser, deserializationContext))) {
                        jsonParser.nextToken();
                        try {
                            object = (EnumMap)propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
                        }
                        catch (Exception exception) {
                            return (EnumMap)this.wrapAndThrow(deserializationContext, exception, this._containerType.getRawClass(), string);
                        }
                        return this.deserialize(jsonParser, deserializationContext, (EnumMap)object);
                    }
                } else {
                    object = (Enum)this._keyDeserializer.deserializeKey(string, deserializationContext);
                    if (object == null) {
                        if (!deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
                            return (EnumMap)deserializationContext.handleWeirdStringValue(this._enumClass, string, "value not one of declared Enum instance names for %s", this._containerType.getKeyType());
                        }
                        jsonParser.nextToken();
                        jsonParser.skipChildren();
                    } else {
                        Object object2;
                        block16: {
                            try {
                                if (jsonToken == JsonToken.VALUE_NULL) {
                                    if (this._skipNullValues) break block15;
                                    object2 = null;
                                } else {
                                    object2 = this._deserializeNoNullChecks(jsonParser, deserializationContext);
                                }
                                if (object2 != null || (object2 = this._nullProvider.getNullValue(deserializationContext)) != null || !this._skipNullValues) break block16;
                                break block15;
                            }
                            catch (Exception exception) {
                                this.wrapAndThrow(deserializationContext, exception, this._containerType.getRawClass(), string);
                                return null;
                            }
                        }
                        propertyValueBuffer.bufferMapProperty(object, object2);
                    }
                }
            }
            string = jsonParser.nextFieldName();
        }
        try {
            return (EnumMap)propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
        }
        catch (Exception exception) {
            this.wrapAndThrow(deserializationContext, exception, this._containerType.getRawClass(), string);
            return null;
        }
    }

    protected Object _deserializeNoNullChecks(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (this._valueTypeDeserializer == null) {
            return this._valueDeserializer.deserialize(jsonParser, deserializationContext);
        }
        return this._valueDeserializer.deserializeWithType(jsonParser, deserializationContext, this._valueTypeDeserializer);
    }
}

