/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.XmlWriter;
import java.io.IOException;
import java.io.Writer;

public abstract class XmlWriterWrapper
extends Writer {
    protected final XmlWriter mWriter;
    private char[] mBuffer = null;

    public static XmlWriterWrapper wrapWriteRaw(XmlWriter xmlWriter) {
        return new RawWrapper(xmlWriter);
    }

    public static XmlWriterWrapper wrapWriteCharacters(XmlWriter xmlWriter) {
        return new TextWrapper(xmlWriter);
    }

    protected XmlWriterWrapper(XmlWriter xmlWriter) {
        this.mWriter = xmlWriter;
    }

    @Override
    public final void close() throws IOException {
        this.mWriter.close(false);
    }

    @Override
    public final void flush() throws IOException {
        this.mWriter.flush();
    }

    @Override
    public final void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    @Override
    public abstract void write(char[] var1, int var2, int var3) throws IOException;

    @Override
    public final void write(int n2) throws IOException {
        if (this.mBuffer == null) {
            this.mBuffer = new char[1];
        }
        this.mBuffer[0] = (char)n2;
        this.write(this.mBuffer, 0, 1);
    }

    @Override
    public abstract void write(String var1) throws IOException;

    @Override
    public abstract void write(String var1, int var2, int var3) throws IOException;

    private static class TextWrapper
    extends XmlWriterWrapper {
        protected TextWrapper(XmlWriter xmlWriter) {
            super(xmlWriter);
        }

        @Override
        public void write(char[] cArray, int n2, int n3) throws IOException {
            this.mWriter.writeCharacters(cArray, n2, n3);
        }

        @Override
        public void write(String string) throws IOException {
            this.mWriter.writeCharacters(string);
        }

        @Override
        public void write(String string, int n2, int n3) throws IOException {
            this.mWriter.writeCharacters(string.substring(n2, n2 + n3));
        }
    }

    private static final class RawWrapper
    extends XmlWriterWrapper {
        protected RawWrapper(XmlWriter xmlWriter) {
            super(xmlWriter);
        }

        @Override
        public void write(char[] cArray, int n2, int n3) throws IOException {
            this.mWriter.writeRaw(cArray, n2, n3);
        }

        @Override
        public void write(String string, int n2, int n3) throws IOException {
            this.mWriter.writeRaw(string, n2, n3);
        }

        @Override
        public final void write(String string) throws IOException {
            this.mWriter.writeRaw(string, 0, string.length());
        }
    }
}

