/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.jaxp;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_isorelax.verifier.Schema;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_isorelax.verifier.Verifier;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_isorelax.verifier.VerifierFactory;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.org_isorelax.verifier.VerifierFilter;
import java.io.File;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderAdapter;

class SAXParserImpl
extends SAXParser {
    private final SAXParser core;
    private Verifier verifier;
    private final VerifierFactory factory;

    SAXParserImpl(SAXParser sAXParser, VerifierFactory verifierFactory, Verifier verifier) {
        this.core = sAXParser;
        this.factory = verifierFactory;
        this.verifier = verifier;
    }

    @Override
    public Parser getParser() throws SAXException {
        return new XMLReaderAdapter(this.getXMLReader());
    }

    @Override
    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.core.getProperty(string);
    }

    @Override
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://www.sun.com/xml/msv/schema".equals(string)) {
            try {
                if (object instanceof String) {
                    this.verifier = this.factory.newVerifier((String)object);
                    return;
                }
                if (object instanceof File) {
                    this.verifier = this.factory.newVerifier((File)object);
                    return;
                }
                if (object instanceof InputSource) {
                    this.verifier = this.factory.newVerifier((InputSource)object);
                    return;
                }
                if (object instanceof InputStream) {
                    this.verifier = this.factory.newVerifier((InputStream)object);
                    return;
                }
                if (object instanceof Schema) {
                    this.verifier = ((Schema)object).newVerifier();
                    return;
                }
                throw new SAXNotSupportedException("unrecognized value type: " + object.getClass().getName());
            }
            catch (Exception exception) {
                throw new SAXNotRecognizedException(exception.toString());
            }
        }
        this.core.setProperty(string, object);
    }

    @Override
    public XMLReader getXMLReader() throws SAXException {
        XMLReader xMLReader = this.core.getXMLReader();
        if (this.verifier == null) {
            return xMLReader;
        }
        VerifierFilter verifierFilter = this.verifier.getVerifierFilter();
        verifierFilter.setParent(xMLReader);
        return verifierFilter;
    }

    @Override
    public boolean isNamespaceAware() {
        return this.core.isNamespaceAware();
    }

    @Override
    public boolean isValidating() {
        return this.core.isValidating();
    }
}

