/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;

public class Uri {
    private static String utf8 = "UTF-8";
    private static final String HEX_DIGITS = "0123456789abcdef";
    private static String excluded = "<>\"{}|\\^`";

    public static boolean isValid(String string) {
        return Uri.isValidPercent(string) && Uri.isValidFragment(string) && Uri.isValidScheme(string);
    }

    public static String escapeDisallowedChars(String string) {
        StringBuffer stringBuffer = null;
        int n2 = string.length();
        int n3 = 0;
        while (true) {
            byte[] byArray;
            int n4 = n3;
            while (true) {
                if (n4 == n2) {
                    if (n3 != 0) break;
                    return string;
                }
                if (Uri.isExcluded(string.charAt(n4))) break;
                ++n4;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            if (n4 > n3) {
                stringBuffer.append(string.substring(n3, n4));
                n3 = n4;
            }
            if (n4 == n2) break;
            ++n4;
            while (n4 < n2 && Uri.isExcluded(string.charAt(n4))) {
                ++n4;
            }
            String string2 = string.substring(n3, n4);
            try {
                byArray = string2.getBytes(utf8);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                utf8 = "UTF8";
                try {
                    byArray = string2.getBytes(utf8);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    return string;
                }
            }
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                stringBuffer.append('%');
                stringBuffer.append(HEX_DIGITS.charAt((byArray[i2] & 0xFF) >> 4));
                stringBuffer.append(HEX_DIGITS.charAt(byArray[i2] & 0xF));
            }
            n3 = n4;
        }
        return stringBuffer.toString();
    }

    private static boolean isExcluded(char c2) {
        return c2 <= ' ' || c2 >= '\u007f' || excluded.indexOf(c2) >= 0;
    }

    private static boolean isAlpha(char c2) {
        return 'a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z';
    }

    private static boolean isHexDigit(char c2) {
        return 'a' <= c2 && c2 <= 'f' || 'A' <= c2 && c2 <= 'F' || Uri.isDigit(c2);
    }

    private static boolean isDigit(char c2) {
        return '0' <= c2 && c2 <= '9';
    }

    private static boolean isSchemeChar(char c2) {
        return Uri.isAlpha(c2) || Uri.isDigit(c2) || c2 == '+' || c2 == '-' || c2 == '.';
    }

    private static boolean isValidPercent(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (string.charAt(i2) != '%') continue;
            if (i2 + 2 >= n2) {
                return false;
            }
            if (Uri.isHexDigit(string.charAt(i2 + 1)) && Uri.isHexDigit(string.charAt(i2 + 2))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidFragment(String string) {
        int n2 = string.indexOf(35);
        return n2 < 0 || string.indexOf(35, n2 + 1) < 0;
    }

    private static boolean isValidScheme(String string) {
        if (!Uri.isAbsolute(string)) {
            return true;
        }
        int n2 = string.indexOf(58);
        if (n2 == 0 || n2 + 1 == string.length() || !Uri.isAlpha(string.charAt(0))) {
            return false;
        }
        while (--n2 > 0) {
            if (Uri.isSchemeChar(string.charAt(n2))) continue;
            return false;
        }
        return true;
    }

    public static String resolve(String string, String string2) {
        if (!Uri.isAbsolute(string2) && string != null && Uri.isAbsolute(string)) {
            try {
                return new URL(new URL(string), string2).toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return string2;
    }

    public static boolean hasFragmentId(String string) {
        return string.indexOf(35) >= 0;
    }

    public static boolean isAbsolute(String string) {
        int n2 = string.indexOf(58);
        if (n2 < 0) {
            return false;
        }
        while (--n2 >= 0) {
            switch (string.charAt(n2)) {
                case '#': 
                case '/': 
                case '?': {
                    return false;
                }
            }
        }
        return true;
    }
}

