/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.scanner.dtd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.scanner.dtd.DTDEventListener;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.scanner.dtd.DTDParser;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.scanner.dtd.EndOfInputException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.scanner.dtd.XmlChars;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.scanner.dtd.XmlReader;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Locale;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class InputEntity {
    private int start;
    private int finish;
    private char[] buf;
    private int lineNumber = 1;
    private boolean returnedFirstHalf = false;
    private boolean maybeInCRLF = false;
    private String name;
    private InputEntity next;
    private InputSource input;
    private Reader reader;
    private boolean isClosed;
    private DTDEventListener errHandler;
    private Locale locale;
    private StringBuffer rememberedText;
    private int startRemember;
    private boolean isPE;
    private static final int BUFSIZ = 8193;
    private static final char[] newline = new char[]{'\n'};

    public static InputEntity getInputEntity(DTDEventListener dTDEventListener, Locale locale) {
        InputEntity inputEntity = new InputEntity();
        inputEntity.errHandler = dTDEventListener;
        inputEntity.locale = locale;
        return inputEntity;
    }

    private InputEntity() {
    }

    public boolean isInternal() {
        return this.reader == null;
    }

    public boolean isDocument() {
        return this.next == null;
    }

    public boolean isParameterEntity() {
        return this.isPE;
    }

    public String getName() {
        return this.name;
    }

    public void init(InputSource inputSource, String string, InputEntity inputEntity, boolean bl2) throws IOException, SAXException {
        this.input = inputSource;
        this.isPE = bl2;
        this.reader = inputSource.getCharacterStream();
        if (this.reader == null) {
            InputStream inputStream = inputSource.getByteStream();
            this.reader = inputStream == null ? XmlReader.createReader(new URL(inputSource.getSystemId()).openStream()) : (inputSource.getEncoding() != null ? XmlReader.createReader(inputSource.getByteStream(), inputSource.getEncoding()) : XmlReader.createReader(inputSource.getByteStream()));
        }
        this.next = inputEntity;
        this.buf = new char[8193];
        this.name = string;
        this.checkRecursion(inputEntity);
    }

    public void init(char[] cArray, String string, InputEntity inputEntity, boolean bl2) throws SAXException {
        this.next = inputEntity;
        this.buf = cArray;
        this.finish = cArray.length;
        this.name = string;
        this.isPE = bl2;
        this.checkRecursion(inputEntity);
    }

    private void checkRecursion(InputEntity inputEntity) throws SAXException {
        if (inputEntity == null) {
            return;
        }
        inputEntity = inputEntity.next;
        while (inputEntity != null) {
            if (inputEntity.name != null && inputEntity.name.equals(this.name)) {
                this.fatal("P-069", new Object[]{this.name});
            }
            inputEntity = inputEntity.next;
        }
    }

    public InputEntity pop() throws IOException {
        this.close();
        return this.next;
    }

    public boolean isEOF() throws IOException, SAXException {
        if (this.start >= this.finish) {
            this.fillbuf();
            return this.start >= this.finish;
        }
        return false;
    }

    public String getEncoding() {
        if (this.reader == null) {
            return null;
        }
        if (this.reader instanceof XmlReader) {
            return ((XmlReader)this.reader).getEncoding();
        }
        if (this.reader instanceof InputStreamReader) {
            return ((InputStreamReader)this.reader).getEncoding();
        }
        return null;
    }

    public char getNameChar() throws IOException, SAXException {
        if (this.finish <= this.start) {
            this.fillbuf();
        }
        if (this.finish > this.start) {
            char c2;
            if (XmlChars.isNameChar(c2 = this.buf[this.start++])) {
                return c2;
            }
            --this.start;
        }
        return '\u0000';
    }

    public char getc() throws IOException, SAXException {
        if (this.finish <= this.start) {
            this.fillbuf();
        }
        if (this.finish > this.start) {
            char c2 = this.buf[this.start++];
            if (this.returnedFirstHalf) {
                if (c2 >= '\udc00' && c2 <= '\udfff') {
                    this.returnedFirstHalf = false;
                    return c2;
                }
                this.fatal("P-070", new Object[]{Integer.toHexString(c2)});
            }
            if (c2 >= ' ' && c2 <= '\ud7ff' || c2 == '\t' || c2 >= '\ue000' && c2 <= '\ufffd') {
                return c2;
            }
            if (c2 == '\r' && !this.isInternal()) {
                this.maybeInCRLF = true;
                c2 = this.getc();
                if (c2 != '\n') {
                    this.ungetc();
                }
                this.maybeInCRLF = false;
                ++this.lineNumber;
                return '\n';
            }
            if (c2 == '\n' || c2 == '\r') {
                if (!this.isInternal() && !this.maybeInCRLF) {
                    ++this.lineNumber;
                }
                return c2;
            }
            if (c2 >= '\ud800' && c2 < '\udc00') {
                this.returnedFirstHalf = true;
                return c2;
            }
            this.fatal("P-071", new Object[]{Integer.toHexString(c2)});
        }
        throw new EndOfInputException();
    }

    public boolean peekc(char c2) throws IOException, SAXException {
        if (this.finish <= this.start) {
            this.fillbuf();
        }
        if (this.finish > this.start) {
            if (this.buf[this.start] == c2) {
                ++this.start;
                return true;
            }
            return false;
        }
        return false;
    }

    public void ungetc() {
        if (this.start == 0) {
            throw new InternalError("ungetc");
        }
        --this.start;
        if (this.buf[this.start] == '\n' || this.buf[this.start] == '\r') {
            if (!this.isInternal()) {
                --this.lineNumber;
            }
        } else if (this.returnedFirstHalf) {
            this.returnedFirstHalf = false;
        }
    }

    public boolean maybeWhitespace() throws IOException, SAXException {
        boolean bl2 = false;
        boolean bl3 = false;
        while (true) {
            char c2;
            if (this.finish <= this.start) {
                this.fillbuf();
            }
            if (this.finish <= this.start) {
                return bl2;
            }
            if ((c2 = this.buf[this.start++]) != ' ' && c2 != '\t' && c2 != '\n' && c2 != '\r') break;
            bl2 = true;
            if (c2 != '\n' && c2 != '\r' || this.isInternal()) continue;
            if (c2 != '\n' || !bl3) {
                ++this.lineNumber;
                bl3 = false;
            }
            if (c2 != '\r') continue;
            bl3 = true;
        }
        --this.start;
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean parsedContent(DTDEventListener dTDEventListener) throws IOException, SAXException {
        int n2;
        int n3 = n2 = this.start;
        boolean bl2 = false;
        while (true) {
            block21: {
                char c2;
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    if (n2 < this.finish) break block22;
                                    if (n2 > n3) {
                                        dTDEventListener.characters(this.buf, n3, n2 - n3);
                                        bl2 = true;
                                        this.start = n2;
                                    }
                                    if (this.isEOF()) {
                                        return bl2;
                                    }
                                    n3 = this.start;
                                    n2 = n3 - 1;
                                    break block21;
                                }
                                c2 = this.buf[n2];
                                if (c2 > ']' && c2 <= '\ud7ff' || c2 < '&' && c2 >= ' ' || c2 > '<' && c2 < ']' || c2 > '&' && c2 < '<' || c2 == '\t' || c2 >= '\ue000' && c2 <= '\ufffd') break block21;
                                if (c2 == '<' || c2 == '&') break;
                                if (c2 != '\n') break block23;
                                if (!this.isInternal()) {
                                    ++this.lineNumber;
                                }
                                break block21;
                            }
                            if (c2 != '\r') break block24;
                            if (!this.isInternal()) {
                                dTDEventListener.characters(this.buf, n3, n2 - n3);
                                dTDEventListener.characters(newline, 0, 1);
                                bl2 = true;
                                ++this.lineNumber;
                                if (this.finish > n2 + 1 && this.buf[n2 + 1] == '\n') {
                                    ++n2;
                                }
                                n3 = this.start = n2 + 1;
                            }
                            break block21;
                        }
                        if (c2 != ']') break block25;
                        switch (this.finish - n2) {
                            case 2: {
                                if (this.buf[n2 + 1] != ']') break;
                            }
                            case 1: {
                                if (this.reader != null) {
                                    if (this.isClosed) break;
                                    if (n2 == n3) {
                                        throw new InternalError("fillbuf");
                                    }
                                    if (--n2 > n3) {
                                        dTDEventListener.characters(this.buf, n3, n2 - n3);
                                        bl2 = true;
                                        this.start = n2;
                                    }
                                    this.fillbuf();
                                    n3 = n2 = this.start;
                                    break;
                                }
                                break block21;
                            }
                            default: {
                                if (this.buf[n2 + 1] == ']' && this.buf[n2 + 2] == '>') {
                                    this.fatal("P-072", null);
                                    break;
                                }
                                break block21;
                            }
                        }
                        break block21;
                    }
                    if (c2 < '\ud800' || c2 > '\udfff') break block26;
                    if (n2 + 1 >= this.finish) {
                        if (n2 > n3) {
                            dTDEventListener.characters(this.buf, n3, n2 - n3);
                            bl2 = true;
                            this.start = n2 + 1;
                        }
                        if (this.isEOF()) {
                            this.fatal("P-081", new Object[]{Integer.toHexString(c2)});
                        }
                        n2 = n3 = this.start;
                        break block21;
                    } else if (this.checkSurrogatePair(n2)) {
                        ++n2;
                        break block21;
                    } else {
                        --n2;
                        break;
                    }
                }
                this.fatal("P-071", new Object[]{Integer.toHexString(c2)});
            }
            ++n2;
        }
        if (n2 == n3) {
            return bl2;
        }
        dTDEventListener.characters(this.buf, n3, n2 - n3);
        this.start = n2;
        return true;
    }

    public boolean unparsedContent(DTDEventListener dTDEventListener, boolean bl2, String string) throws IOException, SAXException {
        int n2;
        if (!this.peek("![CDATA[", null)) {
            return false;
        }
        dTDEventListener.startCDATA();
        while (true) {
            boolean bl3 = false;
            boolean bl4 = bl2;
            for (n2 = this.start; n2 < this.finish; ++n2) {
                char c2 = this.buf[n2];
                if (!XmlChars.isChar(c2)) {
                    bl4 = false;
                    if (c2 >= '\ud800' && c2 <= '\udfff') {
                        if (this.checkSurrogatePair(n2)) {
                            ++n2;
                            continue;
                        }
                        --n2;
                        break;
                    }
                    this.fatal("P-071", new Object[]{Integer.toHexString(this.buf[n2])});
                }
                if (c2 == '\n') {
                    if (this.isInternal()) continue;
                    ++this.lineNumber;
                    continue;
                }
                if (c2 == '\r') {
                    if (this.isInternal()) continue;
                    if (bl4) {
                        if (string != null) {
                            this.errHandler.error(new SAXParseException(DTDParser.messages.getMessage(this.locale, string), null));
                        }
                        dTDEventListener.ignorableWhitespace(this.buf, this.start, n2 - this.start);
                        dTDEventListener.ignorableWhitespace(newline, 0, 1);
                    } else {
                        dTDEventListener.characters(this.buf, this.start, n2 - this.start);
                        dTDEventListener.characters(newline, 0, 1);
                    }
                    ++this.lineNumber;
                    if (this.finish > n2 + 1 && this.buf[n2 + 1] == '\n') {
                        ++n2;
                    }
                    this.start = n2 + 1;
                    continue;
                }
                if (c2 != ']') {
                    if (c2 == ' ' || c2 == '\t') continue;
                    bl4 = false;
                    continue;
                }
                if (n2 + 2 >= this.finish) break;
                if (this.buf[n2 + 1] == ']' && this.buf[n2 + 2] == '>') {
                    bl3 = true;
                    break;
                }
                bl4 = false;
            }
            if (bl4) {
                if (string != null) {
                    this.errHandler.error(new SAXParseException(DTDParser.messages.getMessage(this.locale, string), null));
                }
                dTDEventListener.ignorableWhitespace(this.buf, this.start, n2 - this.start);
            } else {
                dTDEventListener.characters(this.buf, this.start, n2 - this.start);
            }
            if (bl3) break;
            this.start = n2;
            if (!this.isEOF()) continue;
            this.fatal("P-073", null);
        }
        this.start = n2 + 3;
        dTDEventListener.endCDATA();
        return true;
    }

    private boolean checkSurrogatePair(int n2) throws SAXException {
        if (n2 + 1 >= this.finish) {
            return false;
        }
        char c2 = this.buf[n2++];
        char c3 = this.buf[n2];
        if (c2 >= '\ud800' && c2 < '\udc00' && c3 >= '\udc00' && c3 <= '\udfff') {
            return true;
        }
        this.fatal("P-074", new Object[]{Integer.toHexString(c2 & 0xFFFF), Integer.toHexString(c3 & 0xFFFF)});
        return false;
    }

    public boolean ignorableWhitespace(DTDEventListener dTDEventListener) throws IOException, SAXException {
        boolean bl2 = false;
        int n2 = this.start;
        block5: while (true) {
            if (this.finish <= this.start) {
                if (bl2) {
                    dTDEventListener.ignorableWhitespace(this.buf, n2, this.start - n2);
                }
                this.fillbuf();
                n2 = this.start;
            }
            if (this.finish <= this.start) {
                return bl2;
            }
            char c2 = this.buf[this.start++];
            switch (c2) {
                case '\n': {
                    if (!this.isInternal()) {
                        ++this.lineNumber;
                    }
                }
                case '\t': 
                case ' ': {
                    bl2 = true;
                    continue block5;
                }
                case '\r': {
                    bl2 = true;
                    if (!this.isInternal()) {
                        ++this.lineNumber;
                    }
                    dTDEventListener.ignorableWhitespace(this.buf, n2, this.start - 1 - n2);
                    dTDEventListener.ignorableWhitespace(newline, 0, 1);
                    if (this.start >= this.finish || this.buf[this.start] == '\n') {
                        // empty if block
                    }
                    n2 = ++this.start;
                    continue block5;
                }
            }
            break;
        }
        this.ungetc();
        if (bl2) {
            dTDEventListener.ignorableWhitespace(this.buf, n2, this.start - n2);
        }
        return bl2;
    }

    public boolean peek(String string, char[] cArray) throws IOException, SAXException {
        int n2;
        int n3 = cArray != null ? cArray.length : string.length();
        if (this.finish <= this.start || this.finish - this.start < n3) {
            this.fillbuf();
        }
        if (this.finish <= this.start) {
            return false;
        }
        if (cArray != null) {
            for (n2 = 0; n2 < n3 && this.start + n2 < this.finish; ++n2) {
                if (this.buf[this.start + n2] == cArray[n2]) continue;
                return false;
            }
        } else {
            for (n2 = 0; n2 < n3 && this.start + n2 < this.finish; ++n2) {
                if (this.buf[this.start + n2] == string.charAt(n2)) continue;
                return false;
            }
        }
        if (n2 < n3) {
            if (this.reader == null || this.isClosed) {
                return false;
            }
            if (n3 > this.buf.length) {
                this.fatal("P-077", new Object[]{new Integer(this.buf.length)});
            }
            this.fillbuf();
            return this.peek(string, cArray);
        }
        this.start += n3;
        return true;
    }

    public void startRemembering() {
        if (this.startRemember != 0) {
            throw new InternalError();
        }
        this.startRemember = this.start;
    }

    public String rememberText() {
        String string;
        if (this.rememberedText != null) {
            this.rememberedText.append(this.buf, this.startRemember, this.start - this.startRemember);
            string = this.rememberedText.toString();
        } else {
            string = new String(this.buf, this.startRemember, this.start - this.startRemember);
        }
        this.startRemember = 0;
        this.rememberedText = null;
        return string;
    }

    private InputEntity getTopEntity() {
        InputEntity inputEntity = this;
        while (inputEntity != null && inputEntity.input == null) {
            inputEntity = inputEntity.next;
        }
        return inputEntity == null ? this : inputEntity;
    }

    public String getPublicId() {
        InputEntity inputEntity = this.getTopEntity();
        if (inputEntity == this) {
            return this.input.getPublicId();
        }
        return inputEntity.getPublicId();
    }

    public String getSystemId() {
        InputEntity inputEntity = this.getTopEntity();
        if (inputEntity == this) {
            return this.input.getSystemId();
        }
        return inputEntity.getSystemId();
    }

    public int getLineNumber() {
        InputEntity inputEntity = this.getTopEntity();
        if (inputEntity == this) {
            return this.lineNumber;
        }
        return inputEntity.getLineNumber();
    }

    public int getColumnNumber() {
        return -1;
    }

    private void fillbuf() throws IOException, SAXException {
        boolean bl2;
        if (this.reader == null || this.isClosed) {
            return;
        }
        if (this.startRemember != 0) {
            if (this.rememberedText == null) {
                this.rememberedText = new StringBuffer(this.buf.length);
            }
            this.rememberedText.append(this.buf, this.startRemember, this.start - this.startRemember);
        }
        boolean bl3 = bl2 = this.finish > 0 && this.start > 0;
        if (bl2) {
            --this.start;
        }
        int n2 = this.finish - this.start;
        System.arraycopy(this.buf, this.start, this.buf, 0, n2);
        this.start = 0;
        this.finish = n2;
        try {
            n2 = this.buf.length - n2;
            n2 = this.reader.read(this.buf, this.finish, n2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.fatal("P-075", new Object[]{unsupportedEncodingException.getMessage()});
        }
        catch (CharConversionException charConversionException) {
            this.fatal("P-076", new Object[]{charConversionException.getMessage()});
        }
        if (n2 >= 0) {
            this.finish += n2;
        } else {
            this.close();
        }
        if (bl2) {
            ++this.start;
        }
        if (this.startRemember != 0) {
            this.startRemember = 1;
        }
    }

    public void close() {
        try {
            if (this.reader != null && !this.isClosed) {
                this.reader.close();
            }
            this.isClosed = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void fatal(String string, Object[] objectArray) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(DTDParser.messages.getMessage(this.locale, string, objectArray), null);
        this.close();
        this.errHandler.fatalError(sAXParseException);
        throw sAXParseException;
    }
}

