/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.xmlschema;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.AttributeExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ChoiceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ElementExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.Expression;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.NameClass;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ReferenceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.SimpleNameClass;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.util.ExpressionWalker;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.xmlschema.AttWildcardExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.xmlschema.AttributeGroupExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.xmlschema.AttributeWildcard;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.xmlschema.ComplexTypeExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.xmlschema.XMLSchemaReader;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

public class AttributeWildcardComputer
extends ExpressionWalker {
    private final XMLSchemaReader reader;
    private final Set<Expression> visitedExps = new HashSet<Expression>();
    private final Stack<Expression> unprocessedElementExps = new Stack();
    private Set<AttributeWildcard> wildcards = null;

    public static void compute(XMLSchemaReader xMLSchemaReader, Expression expression) {
        new AttributeWildcardComputer(xMLSchemaReader).compute(expression);
    }

    private void compute(Expression expression) {
        expression.visit(this);
        while (!this.unprocessedElementExps.isEmpty()) {
            ((ElementExp)this.unprocessedElementExps.pop()).contentModel.visit(this);
        }
    }

    protected AttributeWildcardComputer(XMLSchemaReader xMLSchemaReader) {
        this.reader = xMLSchemaReader;
    }

    @Override
    public void onElement(ElementExp elementExp) {
        if (!this.visitedExps.add(elementExp)) {
            return;
        }
        this.unprocessedElementExps.add(elementExp);
    }

    @Override
    public void onRef(ReferenceExp referenceExp) {
        Object object;
        if (this.visitedExps.add(referenceExp)) {
            if (referenceExp instanceof AttributeGroupExp) {
                object = (AttributeGroupExp)referenceExp;
                Set<AttributeWildcard> set = this.wildcards;
                this.wildcards = new HashSet<AttributeWildcard>();
                referenceExp.exp.visit(this);
                ((AttributeGroupExp)object).wildcard = this.calcCompleteWildcard(((AttributeGroupExp)object).wildcard, this.wildcards);
                this.wildcards = set;
            } else if (referenceExp instanceof ComplexTypeExp) {
                object = (ComplexTypeExp)referenceExp;
                Set<AttributeWildcard> set = this.wildcards;
                this.wildcards = new HashSet<AttributeWildcard>();
                referenceExp.exp.visit(this);
                ((ComplexTypeExp)object).wildcard = this.calcCompleteWildcard(((ComplexTypeExp)object).wildcard, this.wildcards);
                if (((ComplexTypeExp)object).complexBaseType != null) {
                    ((ComplexTypeExp)object).complexBaseType.visit(this);
                    if (((ComplexTypeExp)object).derivationMethod == 2) {
                        ((ComplexTypeExp)object).wildcard = this.calcComplexTypeWildcard(((ComplexTypeExp)object).wildcard, ((ComplexTypeExp)object).complexBaseType.wildcard);
                    }
                    this.propagateAttributes((ComplexTypeExp)object);
                }
                if (((ComplexTypeExp)object).wildcard != null) {
                    ((ComplexTypeExp)object).attWildcard.exp = ((ComplexTypeExp)object).wildcard.createExpression(this.reader.grammar);
                }
                this.wildcards = set;
            } else {
                super.onRef(referenceExp);
            }
        }
        if (this.wildcards != null && referenceExp instanceof AttWildcardExp && (object = ((AttWildcardExp)((Object)referenceExp)).getAttributeWildcard()) != null) {
            this.wildcards.add((AttributeWildcard)object);
        }
    }

    private AttributeWildcard calcCompleteWildcard(AttributeWildcard attributeWildcard, Set<AttributeWildcard> set) {
        AttributeWildcard[] attributeWildcardArray = set.toArray(new AttributeWildcard[set.size()]);
        if (attributeWildcardArray.length == 0) {
            return attributeWildcard;
        }
        NameClass nameClass = attributeWildcardArray[0].getName();
        for (int i2 = 1; i2 < attributeWildcardArray.length; ++i2) {
            nameClass = NameClass.intersection(nameClass, attributeWildcardArray[i2].getName());
        }
        if (attributeWildcard != null) {
            return new AttributeWildcard(NameClass.intersection(attributeWildcard.getName(), nameClass), attributeWildcard.getProcessMode());
        }
        return new AttributeWildcard(nameClass, attributeWildcardArray[0].getProcessMode());
    }

    private AttributeWildcard calcComplexTypeWildcard(AttributeWildcard attributeWildcard, AttributeWildcard attributeWildcard2) {
        if (attributeWildcard2 != null) {
            if (attributeWildcard == null) {
                return attributeWildcard2;
            }
            return new AttributeWildcard(NameClass.union(attributeWildcard.getName(), attributeWildcard2.getName()), attributeWildcard.getProcessMode());
        }
        return attributeWildcard;
    }

    private void propagateAttributes(final ComplexTypeExp complexTypeExp) {
        if (complexTypeExp.derivationMethod != 1 || complexTypeExp.complexBaseType == null) {
            return;
        }
        if (complexTypeExp.complexBaseType == this.reader.complexUrType) {
            return;
        }
        final HashSet hashSet = new HashSet();
        complexTypeExp.body.visit(new ExpressionWalker(){

            @Override
            public void onElement(ElementExp elementExp) {
            }

            @Override
            public void onAttribute(AttributeExp attributeExp) {
                if (!(attributeExp.nameClass instanceof SimpleNameClass)) {
                    throw new RuntimeException(attributeExp.nameClass.toString());
                }
                hashSet.add(((SimpleNameClass)attributeExp.nameClass).toStringPair());
            }
        });
        complexTypeExp.complexBaseType.body.visit(new ExpressionWalker(){
            private boolean isOptional = false;

            @Override
            public void onChoice(ChoiceExp choiceExp) {
                boolean bl2 = this.isOptional;
                this.isOptional = true;
                super.onChoice(choiceExp);
                this.isOptional = bl2;
            }

            @Override
            public void onElement(ElementExp elementExp) {
            }

            @Override
            public void onAttribute(AttributeExp attributeExp) {
                if (!(attributeExp.nameClass instanceof SimpleNameClass)) {
                    throw new Error();
                }
                SimpleNameClass simpleNameClass = (SimpleNameClass)attributeExp.nameClass;
                if (!hashSet.contains(simpleNameClass.toStringPair())) {
                    complexTypeExp.body.exp = ((AttributeWildcardComputer)AttributeWildcardComputer.this).reader.pool.createSequence(complexTypeExp.body.exp, this.isOptional ? ((AttributeWildcardComputer)AttributeWildcardComputer.this).reader.pool.createOptional(attributeExp) : attributeExp);
                }
            }
        });
    }
}

