/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.util;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.AttributeExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.BinaryExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ChoiceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ConcurExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.DataExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ElementExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.Expression;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ExpressionVisitor;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.InterleaveExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ListExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.MixedExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.OneOrMoreExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.OtherExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ReferenceContainer;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ReferenceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.SequenceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ValueExp;
import java.util.Iterator;

public class ExpressionPrinter
implements ExpressionVisitor {
    public static final int FRAGMENT = 1;
    public static final int CONTENTMODEL = 2;
    public static final ExpressionPrinter fragmentInstance = new ExpressionPrinter(1);
    public static final ExpressionPrinter contentModelInstance = new ExpressionPrinter(2);
    public static final ExpressionPrinter smallestInstance = new ExpressionPrinter(3);
    protected final int mode;

    public static String printFragment(Expression expression) {
        return (String)expression.visit(fragmentInstance);
    }

    public static String printContentModel(Expression expression) {
        return (String)expression.visit(contentModelInstance);
    }

    public static String printSmallest(Expression expression) {
        return (String)expression.visit(smallestInstance);
    }

    protected ExpressionPrinter(int n2) {
        this.mode = n2;
    }

    public String printRefContainer(ReferenceContainer referenceContainer) {
        String string = "";
        Iterator<ReferenceExp> iterator = referenceContainer.iterator();
        while (iterator.hasNext()) {
            ReferenceExp referenceExp = iterator.next();
            string = string + referenceExp.name + "  : " + referenceExp.exp.visit(this) + "\n";
        }
        return string;
    }

    protected static boolean isComplex(Expression expression) {
        return expression instanceof BinaryExp;
    }

    protected String printBinary(BinaryExp binaryExp, String string) {
        String string2 = binaryExp.exp1.getClass() == binaryExp.getClass() || !ExpressionPrinter.isComplex(binaryExp.exp1) ? (String)binaryExp.exp1.visit(this) : "(" + binaryExp.exp1.visit(this) + ")";
        string2 = string2 + string;
        string2 = !ExpressionPrinter.isComplex(binaryExp.exp2) ? string2 + binaryExp.exp2.visit(this) : string2 + "(" + binaryExp.exp2.visit(this) + ")";
        return string2;
    }

    @Override
    public Object onAttribute(AttributeExp attributeExp) {
        return "@" + attributeExp.nameClass.toString() + "<" + attributeExp.exp.visit(this) + ">";
    }

    private Object optional(Expression expression) {
        if (expression instanceof OneOrMoreExp) {
            OneOrMoreExp oneOrMoreExp = (OneOrMoreExp)expression;
            if (ExpressionPrinter.isComplex(oneOrMoreExp.exp)) {
                return "(" + oneOrMoreExp.exp.visit(this) + ")*";
            }
            return oneOrMoreExp.exp.visit(this) + "*";
        }
        if (ExpressionPrinter.isComplex(expression)) {
            return "(" + expression.visit(this) + ")?";
        }
        return expression.visit(this) + "?";
    }

    @Override
    public Object onChoice(ChoiceExp choiceExp) {
        if (choiceExp.exp1 == Expression.epsilon) {
            return this.optional(choiceExp.exp2);
        }
        if (choiceExp.exp2 == Expression.epsilon) {
            return this.optional(choiceExp.exp1);
        }
        return this.printBinary(choiceExp, "|");
    }

    @Override
    public Object onConcur(ConcurExp concurExp) {
        return this.printBinary(concurExp, "&");
    }

    @Override
    public Object onInterleave(InterleaveExp interleaveExp) {
        return this.printBinary(interleaveExp, "^");
    }

    @Override
    public Object onElement(ElementExp elementExp) {
        if ((this.mode & 2) != 0) {
            return elementExp.getNameClass().toString();
        }
        return elementExp.getNameClass().toString() + "<" + elementExp.contentModel.visit(this) + ">";
    }

    @Override
    public Object onOneOrMore(OneOrMoreExp oneOrMoreExp) {
        if (ExpressionPrinter.isComplex(oneOrMoreExp.exp)) {
            return "(" + oneOrMoreExp.exp.visit(this) + ")+";
        }
        return oneOrMoreExp.exp.visit(this) + "+";
    }

    @Override
    public Object onMixed(MixedExp mixedExp) {
        return "mixed[" + mixedExp.exp.visit(this) + "]";
    }

    @Override
    public Object onList(ListExp listExp) {
        return "list[" + listExp.exp.visit(this) + "]";
    }

    @Override
    public Object onEpsilon() {
        return "#epsilon";
    }

    @Override
    public Object onNullSet() {
        return "#nullSet";
    }

    @Override
    public Object onAnyString() {
        return "<anyString>";
    }

    @Override
    public Object onSequence(SequenceExp sequenceExp) {
        return this.printBinary(sequenceExp, ",");
    }

    @Override
    public Object onData(DataExp dataExp) {
        return "$" + dataExp.name.localName;
    }

    @Override
    public Object onValue(ValueExp valueExp) {
        return "$$" + valueExp.value;
    }

    @Override
    public Object onOther(OtherExp otherExp) {
        return otherExp.printName() + "[" + otherExp.exp.visit(this) + "]";
    }

    @Override
    public Object onRef(ReferenceExp referenceExp) {
        if ((this.mode & 1) != 0) {
            return "{%" + referenceExp.name + "}";
        }
        return "(" + referenceExp.exp.visit(this) + ")";
    }
}

