/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.io;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.SystemId;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.WstxInputData;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.WstxInputLocation;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.WstxInputSource;
import java.io.IOException;
import java.net.URL;
import javax.xml.stream.XMLStreamException;

public abstract class BaseInputSource
extends WstxInputSource {
    final String mPublicId;
    SystemId mSystemId;
    protected char[] mBuffer;
    protected int mInputLast;
    long mSavedInputProcessed = 0L;
    int mSavedInputRow = 1;
    int mSavedInputRowStart = 0;
    int mSavedInputPtr = 0;
    transient WstxInputLocation mParentLocation = null;

    protected BaseInputSource(WstxInputSource wstxInputSource, String string, String string2, SystemId systemId) {
        super(wstxInputSource, string);
        this.mSystemId = systemId;
        this.mPublicId = string2;
    }

    @Override
    public void overrideSource(URL uRL) {
        this.mSystemId = SystemId.construct(uRL);
    }

    @Override
    public abstract boolean fromInternalEntity();

    @Override
    public URL getSource() throws IOException {
        return this.mSystemId == null ? null : this.mSystemId.asURL();
    }

    @Override
    public String getPublicId() {
        return this.mPublicId;
    }

    @Override
    public String getSystemId() {
        return this.mSystemId == null ? null : this.mSystemId.toString();
    }

    @Override
    protected abstract void doInitInputLocation(WstxInputData var1);

    @Override
    public abstract int readInto(WstxInputData var1) throws IOException, XMLStreamException;

    @Override
    public abstract boolean readMore(WstxInputData var1, int var2) throws IOException, XMLStreamException;

    @Override
    public void saveContext(WstxInputData wstxInputData) {
        this.mSavedInputPtr = wstxInputData.mInputPtr;
        this.mSavedInputProcessed = wstxInputData.mCurrInputProcessed;
        this.mSavedInputRow = wstxInputData.mCurrInputRow;
        this.mSavedInputRowStart = wstxInputData.mCurrInputRowStart;
    }

    @Override
    public void restoreContext(WstxInputData wstxInputData) {
        wstxInputData.mInputBuffer = this.mBuffer;
        wstxInputData.mInputEnd = this.mInputLast;
        wstxInputData.mInputPtr = this.mSavedInputPtr;
        wstxInputData.mCurrInputProcessed = this.mSavedInputProcessed;
        wstxInputData.mCurrInputRow = this.mSavedInputRow;
        wstxInputData.mCurrInputRowStart = this.mSavedInputRowStart;
    }

    @Override
    public abstract void close() throws IOException;

    @Override
    protected final WstxInputLocation getLocation() {
        return this.getLocation(this.mSavedInputProcessed + (long)this.mSavedInputPtr - 1L, this.mSavedInputRow, this.mSavedInputPtr - this.mSavedInputRowStart + 1);
    }

    @Override
    public final WstxInputLocation getLocation(long l2, int n2, int n3) {
        WstxInputLocation wstxInputLocation;
        if (this.mParent == null) {
            wstxInputLocation = null;
        } else {
            wstxInputLocation = this.mParentLocation;
            if (wstxInputLocation == null) {
                this.mParentLocation = wstxInputLocation = this.mParent.getLocation();
            }
            wstxInputLocation = this.mParent.getLocation();
        }
        return new WstxInputLocation(wstxInputLocation, this.getPublicId(), this.getSystemId(), l2, n2, n3);
    }
}

