/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.ReaderConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.ErrorConsts;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDAttribute;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDCdataAttr;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDEntitiesAttr;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDEntityAttr;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDEnumAttr;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDIdAttr;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDIdRefAttr;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDIdRefsAttr;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDNmTokenAttr;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDNmTokensAttr;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDNotationAttr;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DefaultAttrValue;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.StructValidator;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.InputProblemReporter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.ExceptionUtil;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.PrefixedName;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.WordResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

public final class DTDElement {
    final PrefixedName mName;
    final Location mLocation;
    StructValidator mValidator;
    int mAllowedContent;
    final boolean mNsAware;
    final boolean mXml11;
    HashMap<PrefixedName, DTDAttribute> mAttrMap = null;
    ArrayList<DTDAttribute> mSpecAttrList = null;
    boolean mAnyFixed = false;
    boolean mAnyDefaults = false;
    boolean mValidateAttrs = false;
    DTDAttribute mIdAttr;
    DTDAttribute mNotationAttr;
    HashMap<String, DTDAttribute> mNsDefaults = null;

    private DTDElement(Location location, PrefixedName prefixedName, StructValidator structValidator, int n2, boolean bl2, boolean bl3) {
        this.mName = prefixedName;
        this.mLocation = location;
        this.mValidator = structValidator;
        this.mAllowedContent = n2;
        this.mNsAware = bl2;
        this.mXml11 = bl3;
    }

    public static DTDElement createDefined(ReaderConfig readerConfig, Location location, PrefixedName prefixedName, StructValidator structValidator, int n2) {
        if (n2 == 5) {
            ExceptionUtil.throwInternal("trying to use XMLValidator.CONTENT_ALLOW_UNDEFINED via createDefined()");
        }
        return new DTDElement(location, prefixedName, structValidator, n2, readerConfig.willSupportNamespaces(), readerConfig.isXml11());
    }

    public static DTDElement createPlaceholder(ReaderConfig readerConfig, Location location, PrefixedName prefixedName) {
        return new DTDElement(location, prefixedName, null, 5, readerConfig.willSupportNamespaces(), readerConfig.isXml11());
    }

    public DTDElement define(Location location, StructValidator structValidator, int n2) {
        this.verifyUndefined();
        if (n2 == 5) {
            ExceptionUtil.throwInternal("trying to use CONTENT_ALLOW_UNDEFINED via define()");
        }
        DTDElement dTDElement = new DTDElement(location, this.mName, structValidator, n2, this.mNsAware, this.mXml11);
        dTDElement.mAttrMap = this.mAttrMap;
        dTDElement.mSpecAttrList = this.mSpecAttrList;
        dTDElement.mAnyFixed = this.mAnyFixed;
        dTDElement.mValidateAttrs = this.mValidateAttrs;
        dTDElement.mAnyDefaults = this.mAnyDefaults;
        dTDElement.mIdAttr = this.mIdAttr;
        dTDElement.mNotationAttr = this.mNotationAttr;
        dTDElement.mNsDefaults = this.mNsDefaults;
        return dTDElement;
    }

    public void defineFrom(InputProblemReporter inputProblemReporter, DTDElement dTDElement, boolean bl2) throws XMLStreamException {
        if (bl2) {
            this.verifyUndefined();
        }
        this.mValidator = dTDElement.mValidator;
        this.mAllowedContent = dTDElement.mAllowedContent;
        this.mergeMissingAttributesFrom(inputProblemReporter, dTDElement, bl2);
    }

    private void verifyUndefined() {
        if (this.mAllowedContent != 5) {
            ExceptionUtil.throwInternal("redefining defined element spec");
        }
    }

    public DTDAttribute addAttribute(InputProblemReporter inputProblemReporter, PrefixedName prefixedName, int n2, DefaultAttrValue defaultAttrValue, WordResolver wordResolver, boolean bl2) throws XMLStreamException {
        DTDAttribute dTDAttribute;
        HashMap<PrefixedName, DTDAttribute> hashMap = this.mAttrMap;
        if (hashMap == null) {
            this.mAttrMap = hashMap = new HashMap();
        }
        List<DTDAttribute> list = defaultAttrValue.isSpecial() ? this.getSpecialList() : null;
        int n3 = list == null ? -1 : list.size();
        switch (n2) {
            case 0: {
                dTDAttribute = new DTDCdataAttr(prefixedName, defaultAttrValue, n3, this.mNsAware, this.mXml11);
                break;
            }
            case 1: {
                dTDAttribute = new DTDEnumAttr(prefixedName, defaultAttrValue, n3, this.mNsAware, this.mXml11, wordResolver);
                break;
            }
            case 2: {
                dTDAttribute = new DTDIdAttr(prefixedName, defaultAttrValue, n3, this.mNsAware, this.mXml11);
                break;
            }
            case 3: {
                dTDAttribute = new DTDIdRefAttr(prefixedName, defaultAttrValue, n3, this.mNsAware, this.mXml11);
                break;
            }
            case 4: {
                dTDAttribute = new DTDIdRefsAttr(prefixedName, defaultAttrValue, n3, this.mNsAware, this.mXml11);
                break;
            }
            case 5: {
                dTDAttribute = new DTDEntityAttr(prefixedName, defaultAttrValue, n3, this.mNsAware, this.mXml11);
                break;
            }
            case 6: {
                dTDAttribute = new DTDEntitiesAttr(prefixedName, defaultAttrValue, n3, this.mNsAware, this.mXml11);
                break;
            }
            case 7: {
                dTDAttribute = new DTDNotationAttr(prefixedName, defaultAttrValue, n3, this.mNsAware, this.mXml11, wordResolver);
                break;
            }
            case 8: {
                dTDAttribute = new DTDNmTokenAttr(prefixedName, defaultAttrValue, n3, this.mNsAware, this.mXml11);
                break;
            }
            case 9: {
                dTDAttribute = new DTDNmTokensAttr(prefixedName, defaultAttrValue, n3, this.mNsAware, this.mXml11);
                break;
            }
            default: {
                ExceptionUtil.throwGenericInternal();
                dTDAttribute = null;
            }
        }
        DTDAttribute dTDAttribute2 = this.doAddAttribute(hashMap, inputProblemReporter, dTDAttribute, list, bl2);
        return dTDAttribute2 == null ? dTDAttribute : null;
    }

    public DTDAttribute addNsDefault(InputProblemReporter inputProblemReporter, PrefixedName prefixedName, int n2, DefaultAttrValue defaultAttrValue, boolean bl2) throws XMLStreamException {
        DTDAttribute dTDAttribute;
        switch (n2) {
            case 0: {
                dTDAttribute = new DTDCdataAttr(prefixedName, defaultAttrValue, -1, this.mNsAware, this.mXml11);
                break;
            }
            default: {
                dTDAttribute = new DTDNmTokenAttr(prefixedName, defaultAttrValue, -1, this.mNsAware, this.mXml11);
            }
        }
        String string = prefixedName.getPrefix();
        string = string == null || string.length() == 0 ? "" : prefixedName.getLocalName();
        if (this.mNsDefaults == null) {
            this.mNsDefaults = new HashMap();
        } else if (this.mNsDefaults.containsKey(string)) {
            return null;
        }
        this.mNsDefaults.put(string, dTDAttribute);
        return dTDAttribute;
    }

    public void mergeMissingAttributesFrom(InputProblemReporter inputProblemReporter, DTDElement dTDElement, boolean bl2) throws XMLStreamException {
        Object object;
        Object object2;
        HashMap<PrefixedName, DTDAttribute> hashMap = dTDElement.getAttributes();
        HashMap<PrefixedName, DTDAttribute> hashMap2 = this.mAttrMap;
        if (hashMap2 == null) {
            hashMap2 = new HashMap();
            this.mAttrMap = hashMap2;
        }
        if (hashMap != null && hashMap.size() > 0) {
            object2 = hashMap.entrySet().iterator();
            while (object2.hasNext()) {
                List<DTDAttribute> list;
                Map.Entry entry = (Map.Entry)object2.next();
                PrefixedName object3 = (PrefixedName)entry.getKey();
                if (hashMap2.containsKey(object3)) continue;
                object = (DTDAttribute)entry.getValue();
                if (((DTDAttribute)object).isSpecial()) {
                    list = this.getSpecialList();
                    object = ((DTDAttribute)object).cloneWith(list.size());
                } else {
                    list = null;
                }
                this.doAddAttribute(hashMap2, inputProblemReporter, (DTDAttribute)object, list, bl2);
            }
        }
        if ((object2 = dTDElement.mNsDefaults) != null) {
            if (this.mNsDefaults == null) {
                this.mNsDefaults = new HashMap();
            }
            for (Map.Entry entry : ((HashMap)object2).entrySet()) {
                object = (String)entry.getKey();
                if (this.mNsDefaults.containsKey(object)) continue;
                this.mNsDefaults.put((String)object, (DTDAttribute)entry.getValue());
            }
        }
    }

    private DTDAttribute doAddAttribute(Map<PrefixedName, DTDAttribute> map, InputProblemReporter inputProblemReporter, DTDAttribute dTDAttribute, List<DTDAttribute> list, boolean bl2) throws XMLStreamException {
        PrefixedName prefixedName = dTDAttribute.getName();
        DTDAttribute dTDAttribute2 = map.get(prefixedName);
        if (dTDAttribute2 != null) {
            inputProblemReporter.reportProblem(null, ErrorConsts.WT_ATTR_DECL, ErrorConsts.W_DTD_DUP_ATTR, prefixedName, this.mName);
            return dTDAttribute2;
        }
        switch (dTDAttribute.getValueType()) {
            case 2: {
                if (bl2 && this.mIdAttr != null) {
                    inputProblemReporter.throwParseError("Invalid id attribute \"{0}\" for element <{1}>: already had id attribute \"" + this.mIdAttr.getName() + "\"", prefixedName, this.mName);
                }
                this.mIdAttr = dTDAttribute;
                break;
            }
            case 7: {
                if (bl2 && this.mNotationAttr != null) {
                    inputProblemReporter.throwParseError("Invalid notation attribute '" + prefixedName + "' for element <" + this.mName + ">: already had notation attribute '" + this.mNotationAttr.getName() + "'");
                }
                this.mNotationAttr = dTDAttribute;
            }
        }
        map.put(prefixedName, dTDAttribute);
        if (list != null) {
            list.add(dTDAttribute);
        }
        if (!this.mAnyFixed) {
            this.mAnyFixed = dTDAttribute.isFixed();
        }
        if (!this.mValidateAttrs) {
            this.mValidateAttrs = dTDAttribute.needsValidation();
        }
        if (!this.mAnyDefaults) {
            this.mAnyDefaults = dTDAttribute.hasDefaultValue();
        }
        return null;
    }

    public PrefixedName getName() {
        return this.mName;
    }

    public String toString() {
        return this.mName.toString();
    }

    public String getDisplayName() {
        return this.mName.toString();
    }

    public Location getLocation() {
        return this.mLocation;
    }

    public boolean isDefined() {
        return this.mAllowedContent != 5;
    }

    public int getAllowedContent() {
        return this.mAllowedContent;
    }

    public int getAllowedContentIfSpace() {
        int n2 = this.mAllowedContent;
        return n2 <= 1 ? 2 : 4;
    }

    public HashMap<PrefixedName, DTDAttribute> getAttributes() {
        return this.mAttrMap;
    }

    public int getSpecialCount() {
        return this.mSpecAttrList == null ? 0 : this.mSpecAttrList.size();
    }

    public List<DTDAttribute> getSpecialAttrs() {
        return this.mSpecAttrList;
    }

    public boolean attrsNeedValidation() {
        return this.mValidateAttrs;
    }

    public boolean hasFixedAttrs() {
        return this.mAnyFixed;
    }

    public boolean hasAttrDefaultValues() {
        return this.mAnyDefaults;
    }

    public DTDAttribute getIdAttribute() {
        return this.mIdAttr;
    }

    public DTDAttribute getNotationAttribute() {
        return this.mNotationAttr;
    }

    public boolean hasNsDefaults() {
        return this.mNsDefaults != null;
    }

    public StructValidator getValidator() {
        return this.mValidator == null ? null : this.mValidator.newInstance();
    }

    protected HashMap<String, DTDAttribute> getNsDefaults() {
        return this.mNsDefaults;
    }

    private List<DTDAttribute> getSpecialList() {
        ArrayList<DTDAttribute> arrayList = this.mSpecAttrList;
        if (arrayList == null) {
            this.mSpecAttrList = arrayList = new ArrayList();
        }
        return arrayList;
    }
}

