/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.tools.api;

import com.gradle.maven.extension.internal.dep.org.objectweb.asm.ClassReader;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.ClassWriter;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.gradle.internal.tools.api.ApiClassExtractionException;
import org.gradle.internal.tools.api.ApiMemberWriterAdapter;
import org.gradle.internal.tools.api.ApiMemberWriterFactory;
import org.gradle.internal.tools.api.impl.ApiMemberSelector;
import org.gradle.internal.tools.api.impl.MethodStubbingApiMemberAdapter;

public class ApiClassExtractor {
    private static final Pattern LOCAL_CLASS_PATTERN = Pattern.compile(".+\\$[0-9]+(?:[\\p{Alnum}_$]+)?$");
    private final Predicate<String> packageNameFilter;
    private final boolean apiIncludesPackagePrivateMembers;
    private final ApiMemberWriterFactory apiMemberWriterFactory;

    public static Builder withWriter(ApiMemberWriterAdapter apiMemberWriterAdapter) {
        return new Builder(classWriter -> apiMemberWriterAdapter.createWriter(new MethodStubbingApiMemberAdapter(classWriter)));
    }

    private ApiClassExtractor(Predicate<String> predicate, boolean bl2, ApiMemberWriterFactory apiMemberWriterFactory) {
        this.packageNameFilter = predicate;
        this.apiIncludesPackagePrivateMembers = bl2;
        this.apiMemberWriterFactory = apiMemberWriterFactory;
    }

    public Optional<byte[]> extractApiClassFrom(byte[] byArray) {
        ClassReader classReader = new ClassReader(byArray);
        return this.extractApiClassFromReader(classReader).map(ClassWriter::toByteArray);
    }

    protected Optional<ClassWriter> extractApiClassFromReader(ClassReader classReader) {
        ApiMemberSelector apiMemberSelector;
        if (!this.shouldExtractApiClassFrom(classReader)) {
            return Optional.empty();
        }
        ClassWriter classWriter = new ClassWriter(1);
        try {
            apiMemberSelector = new ApiMemberSelector(classReader.getClassName(), this.apiMemberWriterFactory.makeApiMemberWriter(classWriter), this.apiIncludesPackagePrivateMembers);
            classReader.accept(apiMemberSelector, 6);
        }
        catch (ApiClassExtractionException apiClassExtractionException) {
            throw apiClassExtractionException.withClass(classReader.getClassName());
        }
        if (apiMemberSelector.isPrivateInnerClass()) {
            return Optional.empty();
        }
        return Optional.of(classWriter);
    }

    private boolean shouldExtractApiClassFrom(ClassReader classReader) {
        if (!ApiMemberSelector.isCandidateApiMember(classReader.getAccess(), this.apiIncludesPackagePrivateMembers)) {
            return false;
        }
        String string = classReader.getClassName();
        if (ApiClassExtractor.isLocalClass(string)) {
            return false;
        }
        return this.packageNameFilter.test(ApiClassExtractor.packageNameOf(string));
    }

    private static String packageNameOf(String string) {
        int n2 = string.lastIndexOf(47);
        return n2 > 0 ? string.substring(0, n2).replace('/', '.') : "";
    }

    private static boolean isLocalClass(String string) {
        return LOCAL_CLASS_PATTERN.matcher(string).matches();
    }

    public static class Builder {
        private final ApiMemberWriterFactory apiMemberWriterFactory;
        private boolean includePackagePrivateMembers;
        private Predicate<String> packageNameFilter = string -> true;

        Builder(ApiMemberWriterFactory apiMemberWriterFactory) {
            this.apiMemberWriterFactory = apiMemberWriterFactory;
        }

        public Builder includePackagePrivateMembers() {
            this.includePackagePrivateMembers = true;
            return this;
        }

        public ApiClassExtractor build() {
            return new ApiClassExtractor(this.packageNameFilter, this.includePackagePrivateMembers, this.apiMemberWriterFactory);
        }
    }
}

