/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.time;

import java.io.IOException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.time.CountdownTimer;
import org.gradle.internal.time.Time;

public class ExponentialBackoff<S extends Signal> {
    private final Random random = new Random();
    private final S signal;
    private final long slotTime;
    private final int timeoutMs;
    private CountdownTimer timer;

    public static <T extends Signal> ExponentialBackoff<T> of(int n2, TimeUnit timeUnit, T t2) {
        return new ExponentialBackoff<T>((int)TimeUnit.MILLISECONDS.convert(n2, timeUnit), t2, 25L);
    }

    private ExponentialBackoff(int n2, S s2, long l2) {
        this.timeoutMs = n2;
        this.signal = s2;
        this.slotTime = l2;
        this.restartTimer();
    }

    public void restartTimer() {
        this.timer = Time.startCountdownTimer(this.timeoutMs);
    }

    public <T> T retryUntil(Query<T> query) throws IOException, InterruptedException {
        Result<T> result;
        int n2 = 0;
        while (!(result = query.run()).isSuccessful() && !this.timer.hasExpired()) {
            boolean bl2;
            if (!(bl2 = this.signal.await(this.backoffPeriodFor(++n2)))) continue;
            n2 = 0;
        }
        return result.getValue();
    }

    long backoffPeriodFor(int n2) {
        return (long)this.random.nextInt(Math.min(n2, 100)) * this.slotTime;
    }

    public CountdownTimer getTimer() {
        return this.timer;
    }

    public S getSignal() {
        return this.signal;
    }

    public static interface Signal {
        public static final Signal SLEEP = new Signal(){

            @Override
            public boolean await(long l2) throws InterruptedException {
                Thread.sleep(l2);
                return false;
            }
        };

        public boolean await(long var1) throws InterruptedException;
    }

    public static interface Query<T> {
        public Result<T> run() throws IOException, InterruptedException;
    }

    public static abstract class Result<T> {
        public abstract boolean isSuccessful();

        public abstract T getValue();

        public static <T> Result<T> successful(final T t2) {
            if (t2 == null) {
                throw new IllegalArgumentException();
            }
            return new Result<T>(){

                @Override
                public boolean isSuccessful() {
                    return true;
                }

                @Override
                public T getValue() {
                    return t2;
                }
            };
        }

        public static <T> Result<T> notSuccessful(final T t2) {
            if (t2 == null) {
                throw new IllegalArgumentException();
            }
            return new Result<T>(){

                @Override
                public boolean isSuccessful() {
                    return false;
                }

                @Override
                public T getValue() {
                    return t2;
                }
            };
        }
    }
}

