/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations;

import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationIdFactory;
import org.gradle.internal.operations.BuildOperationInvocationException;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.BuildOperationState;
import org.gradle.internal.operations.BuildOperationWorker;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.time.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBuildOperationRunner
implements BuildOperationRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBuildOperationRunner.class);
    private static final BuildOperationWorker<RunnableBuildOperation> RUNNABLE_BUILD_OPERATION_WORKER = new BuildOperationWorker<RunnableBuildOperation>(){

        @Override
        public void execute(RunnableBuildOperation runnableBuildOperation, BuildOperationContext buildOperationContext) throws Exception {
            runnableBuildOperation.run(buildOperationContext);
        }
    };
    private final Clock clock;
    private final BuildOperationIdFactory buildOperationIdFactory;
    private final CurrentBuildOperationRef currentBuildOperationRef;
    private final BuildOperationExecutionListenerFactory listenerFactory;

    public DefaultBuildOperationRunner(CurrentBuildOperationRef currentBuildOperationRef, Clock clock, BuildOperationIdFactory buildOperationIdFactory, BuildOperationExecutionListenerFactory buildOperationExecutionListenerFactory) {
        this.currentBuildOperationRef = currentBuildOperationRef;
        this.clock = clock;
        this.buildOperationIdFactory = buildOperationIdFactory;
        this.listenerFactory = buildOperationExecutionListenerFactory;
    }

    @Override
    public void run(RunnableBuildOperation runnableBuildOperation) {
        this.execute(runnableBuildOperation, RUNNABLE_BUILD_OPERATION_WORKER, this.getCurrentBuildOperation());
    }

    @Override
    public <T> T call(CallableBuildOperation<T> callableBuildOperation) {
        CallableBuildOperationWorker callableBuildOperationWorker = new CallableBuildOperationWorker();
        this.execute(callableBuildOperation, callableBuildOperationWorker, this.getCurrentBuildOperation());
        return callableBuildOperationWorker.getReturnValue();
    }

    public <O extends BuildOperation> void execute(final O o2, final BuildOperationWorker<O> buildOperationWorker, BuildOperationState buildOperationState) {
        this.execute(o2.description(), buildOperationState, new BuildOperationExecution<O>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public O execute(BuildOperationDescriptor buildOperationDescriptor, BuildOperationState buildOperationState, BuildOperationState buildOperationState2, ReadableBuildOperationContext readableBuildOperationContext, BuildOperationExecutionListener buildOperationExecutionListener) {
                try {
                    buildOperationExecutionListener.start(buildOperationDescriptor, buildOperationState);
                    Throwable throwable = null;
                    try {
                        buildOperationWorker.execute(o2, readableBuildOperationContext);
                    }
                    catch (Throwable throwable2) {
                        if (readableBuildOperationContext.getFailure() == null) {
                            readableBuildOperationContext.failed(throwable2);
                        }
                        throwable = throwable2;
                    }
                    buildOperationExecutionListener.stop(buildOperationDescriptor, buildOperationState, buildOperationState2, readableBuildOperationContext);
                    if (throwable != null) {
                        throw DefaultBuildOperationRunner.throwAsBuildOperationInvocationException(throwable);
                    }
                    BuildOperation buildOperation = o2;
                    return buildOperation;
                }
                finally {
                    buildOperationExecutionListener.close(buildOperationDescriptor, buildOperationState);
                }
            }
        });
    }

    private <O> O execute(BuildOperationDescriptor.Builder builder, BuildOperationState buildOperationState, BuildOperationExecution<O> buildOperationExecution) {
        BuildOperationState buildOperationState2 = (BuildOperationState)builder.getParentState();
        BuildOperationState buildOperationState3 = buildOperationState2 == null ? buildOperationState : buildOperationState2;
        OperationIdentifier operationIdentifier = new OperationIdentifier(this.buildOperationIdFactory.nextId());
        BuildOperationDescriptor buildOperationDescriptor = builder.build(operationIdentifier, buildOperationState3 == null ? null : buildOperationState3.getDescription().getId());
        DefaultBuildOperationRunner.assertParentRunning("Cannot start operation (%s) as parent operation (%s) has already completed.", buildOperationDescriptor, buildOperationState3);
        BuildOperationState buildOperationState4 = new BuildOperationState(buildOperationDescriptor, this.clock.getCurrentTime());
        BuildOperationTrackingListener buildOperationTrackingListener = new BuildOperationTrackingListener(this.currentBuildOperationRef, this.listenerFactory.createListener());
        DefaultBuildOperationContext defaultBuildOperationContext = new DefaultBuildOperationContext(buildOperationDescriptor, buildOperationTrackingListener);
        return buildOperationExecution.execute(buildOperationDescriptor, buildOperationState4, buildOperationState3, defaultBuildOperationContext, buildOperationTrackingListener);
    }

    private static void assertParentRunning(String string, BuildOperationDescriptor buildOperationDescriptor, BuildOperationState buildOperationState) {
        if (buildOperationState != null && !buildOperationState.isRunning()) {
            String string2 = buildOperationState.getDescription().getDisplayName();
            throw new IllegalStateException(String.format(string, buildOperationDescriptor.getDisplayName(), string2));
        }
    }

    private BuildOperationState getCurrentBuildOperation() {
        return (BuildOperationState)this.currentBuildOperationRef.get();
    }

    private static RuntimeException throwAsBuildOperationInvocationException(Throwable throwable) {
        if (throwable instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new BuildOperationInvocationException(throwable.getMessage(), throwable);
    }

    public static interface BuildOperationExecutionListenerFactory {
        public BuildOperationExecutionListener createListener();
    }

    private static class CallableBuildOperationWorker<T>
    implements BuildOperationWorker<CallableBuildOperation<T>> {
        private T returnValue;

        private CallableBuildOperationWorker() {
        }

        @Override
        public void execute(CallableBuildOperation<T> callableBuildOperation, BuildOperationContext buildOperationContext) throws Exception {
            this.returnValue = callableBuildOperation.call(buildOperationContext);
        }

        public T getReturnValue() {
            return this.returnValue;
        }
    }

    private static interface BuildOperationExecution<O> {
        public O execute(BuildOperationDescriptor var1, BuildOperationState var2, BuildOperationState var3, ReadableBuildOperationContext var4, BuildOperationExecutionListener var5);
    }

    private static class BuildOperationTrackingListener
    implements BuildOperationExecutionListener {
        private final CurrentBuildOperationRef currentBuildOperationRef;
        private final BuildOperationExecutionListener delegate;
        private BuildOperationState originalCurrentBuildOperation;

        private BuildOperationTrackingListener(CurrentBuildOperationRef currentBuildOperationRef, BuildOperationExecutionListener buildOperationExecutionListener) {
            this.currentBuildOperationRef = currentBuildOperationRef;
            this.delegate = buildOperationExecutionListener;
        }

        @Override
        public void start(BuildOperationDescriptor buildOperationDescriptor, BuildOperationState buildOperationState) {
            this.originalCurrentBuildOperation = (BuildOperationState)this.currentBuildOperationRef.get();
            this.currentBuildOperationRef.set(buildOperationState);
            buildOperationState.setRunning(true);
            LOGGER.debug("Build operation '{}' started", (Object)buildOperationDescriptor.getDisplayName());
            this.delegate.start(buildOperationDescriptor, buildOperationState);
        }

        @Override
        public void progress(BuildOperationDescriptor buildOperationDescriptor, String string) {
            this.delegate.progress(buildOperationDescriptor, string);
        }

        @Override
        public void stop(BuildOperationDescriptor buildOperationDescriptor, BuildOperationState buildOperationState, BuildOperationState buildOperationState2, ReadableBuildOperationContext readableBuildOperationContext) {
            this.delegate.stop(buildOperationDescriptor, buildOperationState, buildOperationState2, readableBuildOperationContext);
            LOGGER.debug("Completing Build operation '{}'", (Object)buildOperationDescriptor.getDisplayName());
            DefaultBuildOperationRunner.assertParentRunning("Parent operation (%2$s) completed before this operation (%1$s).", buildOperationDescriptor, buildOperationState2);
        }

        @Override
        public void close(BuildOperationDescriptor buildOperationDescriptor, BuildOperationState buildOperationState) {
            this.delegate.close(buildOperationDescriptor, buildOperationState);
            this.currentBuildOperationRef.set(this.originalCurrentBuildOperation);
            buildOperationState.setRunning(false);
            LOGGER.debug("Build operation '{}' completed", (Object)buildOperationDescriptor.getDisplayName());
        }
    }

    public static interface BuildOperationExecutionListener {
        public static final BuildOperationExecutionListener NO_OP = new BuildOperationExecutionListener(){

            @Override
            public void start(BuildOperationDescriptor buildOperationDescriptor, BuildOperationState buildOperationState) {
            }

            @Override
            public void progress(BuildOperationDescriptor buildOperationDescriptor, String string) {
            }

            @Override
            public void stop(BuildOperationDescriptor buildOperationDescriptor, BuildOperationState buildOperationState, BuildOperationState buildOperationState2, ReadableBuildOperationContext readableBuildOperationContext) {
            }

            @Override
            public void close(BuildOperationDescriptor buildOperationDescriptor, BuildOperationState buildOperationState) {
            }
        };

        public void start(BuildOperationDescriptor var1, BuildOperationState var2);

        public void progress(BuildOperationDescriptor var1, String var2);

        public void stop(BuildOperationDescriptor var1, BuildOperationState var2, BuildOperationState var3, ReadableBuildOperationContext var4);

        public void close(BuildOperationDescriptor var1, BuildOperationState var2);
    }

    private static class DefaultBuildOperationContext
    implements ReadableBuildOperationContext {
        private final BuildOperationDescriptor descriptor;
        private final BuildOperationExecutionListener listener;
        private Throwable failure;
        private Object result;

        public DefaultBuildOperationContext(BuildOperationDescriptor buildOperationDescriptor, BuildOperationExecutionListener buildOperationExecutionListener) {
            this.descriptor = buildOperationDescriptor;
            this.listener = buildOperationExecutionListener;
        }

        @Override
        public Object getResult() {
            return this.result;
        }

        @Override
        public void setResult(Object object) {
            this.result = object;
        }

        @Override
        public Throwable getFailure() {
            return this.failure;
        }

        @Override
        public void failed(Throwable throwable) {
            this.failure = throwable;
        }

        @Override
        public void progress(String string) {
            this.listener.progress(this.descriptor, string);
        }
    }

    public static interface ReadableBuildOperationContext
    extends BuildOperationContext {
        public Object getResult();

        public Throwable getFailure();
    }
}

