/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.origin;

import java.time.Duration;
import java.util.Properties;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.origin.OriginReader;
import org.gradle.caching.internal.origin.OriginWriter;
import org.gradle.internal.hash.HashCode;

public class OriginMetadataFactory {
    private final String currentBuildInvocationId;
    private final PropertiesConfigurator additionalProperties;

    public OriginMetadataFactory(String string, PropertiesConfigurator propertiesConfigurator) {
        this.additionalProperties = propertiesConfigurator;
        this.currentBuildInvocationId = string;
    }

    public OriginWriter createWriter(String string, Class<?> clazz, HashCode hashCode, Duration duration) {
        return outputStream -> {
            Properties properties = new Properties();
            properties.setProperty("buildInvocationId", this.currentBuildInvocationId);
            properties.setProperty("type", clazz.getCanonicalName());
            properties.setProperty("identity", string);
            properties.setProperty("buildCacheKey", hashCode.toString());
            properties.setProperty("creationTime", Long.toString(System.currentTimeMillis()));
            properties.setProperty("executionTime", Long.toString(duration.toMillis()));
            this.additionalProperties.configure(properties);
            properties.store(outputStream, "Generated origin information");
        };
    }

    public OriginReader createReader() {
        return inputStream -> {
            Properties properties = new Properties();
            properties.load(inputStream);
            String string = properties.getProperty("buildInvocationId");
            String string2 = properties.getProperty("buildCacheKey");
            String string3 = properties.getProperty("executionTime");
            if (string == null || string3 == null) {
                throw new IllegalStateException("Cached result format error, corrupted origin metadata");
            }
            Duration duration = Duration.ofMillis(Long.parseLong(string3));
            return new OriginMetadata(string, HashCode.fromString(string2), duration);
        };
    }

    public static interface PropertiesConfigurator {
        public void configure(Properties var1);
    }
}

