/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.FileUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.internal.CacheInitializationAction;
import org.gradle.cache.internal.DefaultCacheCleanupExecutor;
import org.gradle.cache.internal.DefaultCacheCoordinator;
import org.gradle.cache.internal.ReferencablePersistentCache;
import org.gradle.internal.concurrent.ExecutorFactory;

public class DefaultPersistentDirectoryStore
implements ReferencablePersistentCache {
    private final File dir;
    private final LockOptions lockOptions;
    private final FileLockManager lockManager;
    private final ExecutorFactory executorFactory;
    private final String displayName;
    protected final File propertiesFile;
    private final File gcFile;
    private final DefaultCacheCleanupExecutor cleanupExecutor;
    private DefaultCacheCoordinator cacheAccess;

    public DefaultPersistentDirectoryStore(File file, String string, LockOptions lockOptions, CacheCleanupStrategy cacheCleanupStrategy, FileLockManager fileLockManager, ExecutorFactory executorFactory) {
        this.dir = file;
        this.lockOptions = lockOptions;
        this.lockManager = fileLockManager;
        this.executorFactory = executorFactory;
        this.propertiesFile = new File(file, "cache.properties");
        this.gcFile = new File(file, "gc.properties");
        this.displayName = string != null ? string + " (" + file + ")" : "cache directory " + file.getName() + " (" + file + ")";
        this.cleanupExecutor = new DefaultCacheCleanupExecutor(this, this.gcFile, cacheCleanupStrategy);
    }

    @Override
    public DefaultPersistentDirectoryStore open() {
        try {
            FileUtils.forceMkdir(this.dir);
            this.cacheAccess = this.createCacheAccess();
            this.cacheAccess.open();
        }
        catch (Throwable throwable) {
            throw new CacheOpenException(String.format("Could not open %s.", this), throwable);
        }
        return this;
    }

    private DefaultCacheCoordinator createCacheAccess() {
        return new DefaultCacheCoordinator(this.displayName, this.getLockTarget(), this.lockOptions, this.dir, this.lockManager, this.getInitAction(), this.cleanupExecutor, this.executorFactory);
    }

    private File getLockTarget() {
        return this.dir;
    }

    protected CacheInitializationAction getInitAction() {
        return CacheInitializationAction.NO_INIT_REQUIRED;
    }

    @Override
    public void close() {
        if (this.cacheAccess != null) {
            try {
                this.cacheAccess.close();
            }
            finally {
                this.cacheAccess = null;
            }
        }
    }

    @Override
    public File getBaseDir() {
        return this.dir;
    }

    @Override
    public Collection<File> getReservedCacheFiles() {
        return Arrays.asList(this.propertiesFile, this.gcFile, DefaultPersistentDirectoryStore.determineLockTargetFile(this.getLockTarget()));
    }

    static File determineLockTargetFile(File file) {
        return new File(file, file.getName() + ".lock");
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void withFileLock(Runnable runnable) {
        this.cacheAccess.withFileLock(runnable);
    }

    @Override
    public void useCache(Runnable runnable) {
        this.cacheAccess.useCache(runnable);
    }
}

