/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.FileLockReleasedSignal;
import org.gradle.cache.InsufficientLockModeException;
import org.gradle.cache.LockOptions;
import org.gradle.cache.LockTimeoutException;
import org.gradle.cache.internal.AbstractFileAccess;
import org.gradle.cache.internal.ProcessMetaDataProvider;
import org.gradle.cache.internal.filelock.DefaultLockStateSerializer;
import org.gradle.cache.internal.filelock.FileLockOutcome;
import org.gradle.cache.internal.filelock.LockFileAccess;
import org.gradle.cache.internal.filelock.LockInfo;
import org.gradle.cache.internal.filelock.LockState;
import org.gradle.cache.internal.filelock.LockStateAccess;
import org.gradle.cache.internal.filelock.LockStateSerializer;
import org.gradle.cache.internal.filelock.Version1LockStateSerializer;
import org.gradle.cache.internal.locklistener.FileLockContentionHandler;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.time.ExponentialBackoff;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileLockManager
implements FileLockManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFileLockManager.class);
    private final Set<File> lockedFiles = new CopyOnWriteArraySet<File>();
    private final ProcessMetaDataProvider metaDataProvider;
    private final int lockTimeoutMs;
    private final LongSupplier generator;
    private final FileLockContentionHandler fileLockContentionHandler;
    private final int shortTimeoutMs = 10000;

    public DefaultFileLockManager(ProcessMetaDataProvider processMetaDataProvider, FileLockContentionHandler fileLockContentionHandler) {
        this(processMetaDataProvider, 60000, fileLockContentionHandler);
    }

    public DefaultFileLockManager(ProcessMetaDataProvider processMetaDataProvider, int n2, FileLockContentionHandler fileLockContentionHandler) {
        this(processMetaDataProvider, n2, fileLockContentionHandler, new RandomLongIdGenerator());
    }

    DefaultFileLockManager(ProcessMetaDataProvider processMetaDataProvider, int n2, FileLockContentionHandler fileLockContentionHandler, LongSupplier longSupplier) {
        this.metaDataProvider = processMetaDataProvider;
        this.lockTimeoutMs = n2;
        this.fileLockContentionHandler = fileLockContentionHandler;
        this.generator = longSupplier;
    }

    @Override
    public FileLock lock(File file, LockOptions lockOptions, String string) throws LockTimeoutException {
        return this.lock(file, lockOptions, string, "");
    }

    @Override
    public FileLock lock(File file, LockOptions lockOptions, String string, String string2) {
        return this.lock(file, lockOptions, string, string2, null);
    }

    @Override
    public FileLock lock(File file, LockOptions lockOptions, String string, String string2, Consumer<FileLockReleasedSignal> consumer) {
        File file2;
        if (!this.isSupportedMode(lockOptions.getMode())) {
            throw new UnsupportedOperationException(String.format("No %s mode lock implementation available.", lockOptions));
        }
        try {
            file2 = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            throw UncheckedException.throwAsUncheckedException(iOException);
        }
        if (!this.lockedFiles.add(file2)) {
            throw new IllegalStateException(String.format("Cannot lock %s as it has already been locked by this process.", string));
        }
        try {
            int n2 = this.fileLockContentionHandler.reservePort();
            return new DefaultFileLock(file2, lockOptions, string, string2, n2, consumer);
        }
        catch (Throwable throwable) {
            this.lockedFiles.remove(file2);
            throw UncheckedException.throwAsUncheckedException(throwable);
        }
    }

    static File determineLockTargetFile(File file) {
        if (file.isDirectory()) {
            return new File(file, file.getName() + ".lock");
        }
        return new File(file.getParentFile(), file.getName() + ".lock");
    }

    private boolean isSupportedMode(FileLockManager.LockMode lockMode) {
        return lockMode != FileLockManager.LockMode.OnDemand && lockMode != FileLockManager.LockMode.OnDemandEagerRelease;
    }

    private ExponentialBackoff<AwaitableFileLockReleasedSignal> newExponentialBackoff(int n2) {
        return ExponentialBackoff.of(n2, TimeUnit.MILLISECONDS, new AwaitableFileLockReleasedSignal());
    }

    private static class RandomLongIdGenerator
    implements LongSupplier {
        private final Random random = new Random();

        private RandomLongIdGenerator() {
        }

        @Override
        public long getAsLong() {
            return this.random.nextLong();
        }
    }

    private class DefaultFileLock
    extends AbstractFileAccess
    implements FileLock {
        private final File lockFile;
        private final File target;
        private final FileLockManager.LockMode mode;
        private final String displayName;
        private final String operationDisplayName;
        private java.nio.channels.FileLock lock;
        private LockFileAccess lockFileAccess;
        private LockState lockState;
        private final int port;
        private final long lockId;

        public DefaultFileLock(File file, LockOptions lockOptions, String string, String string2, int n2, Consumer<FileLockReleasedSignal> consumer) throws Throwable {
            this.port = n2;
            this.lockId = DefaultFileLockManager.this.generator.getAsLong();
            FileLockManager.LockMode lockMode = lockOptions.getMode();
            if (!DefaultFileLockManager.this.isSupportedMode(lockMode)) {
                throw new UnsupportedOperationException("Locking mode " + (Object)((Object)lockMode) + " is not supported.");
            }
            this.target = file;
            this.displayName = string;
            this.operationDisplayName = string2;
            this.lockFile = DefaultFileLockManager.determineLockTargetFile(file);
            try {
                FileUtils.forceMkdirParent(this.lockFile);
                this.lockFile.createNewFile();
            }
            catch (IOException iOException) {
                LOGGER.info("Couldn't create lock file for {}", (Object)this.lockFile);
                throw iOException;
            }
            LockStateSerializer lockStateSerializer = lockOptions.isUseCrossVersionImplementation() ? new Version1LockStateSerializer() : new DefaultLockStateSerializer();
            this.lockFileAccess = new LockFileAccess(this.lockFile, new LockStateAccess(lockStateSerializer));
            try {
                if (consumer != null) {
                    DefaultFileLockManager.this.fileLockContentionHandler.start(this.lockId, consumer);
                }
                this.lockState = this.lock(lockMode);
            }
            catch (Throwable throwable) {
                this.lockFileAccess.close();
                throw throwable;
            }
            this.mode = this.lock.isShared() ? FileLockManager.LockMode.Shared : FileLockManager.LockMode.Exclusive;
        }

        @Override
        public boolean isLockFile(File file) {
            return file.equals(this.lockFile);
        }

        @Override
        public boolean getUnlockedCleanly() {
            this.assertOpen();
            return !this.lockState.isDirty();
        }

        @Override
        public FileLock.State getState() {
            this.assertOpen();
            return this.lockState;
        }

        @Override
        public void writeFile(Runnable runnable) throws LockTimeoutException {
            this.assertOpen();
            this.doWriteAction(runnable);
        }

        private void doWriteAction(Runnable runnable) {
            if (this.mode != FileLockManager.LockMode.Exclusive) {
                throw new InsufficientLockModeException("An exclusive lock is required for this operation");
            }
            try {
                this.lockState = this.lockFileAccess.markDirty(this.lockState);
                runnable.run();
                this.lockState = this.lockFileAccess.markClean(this.lockState);
            }
            catch (Throwable throwable) {
                throw UncheckedException.throwAsUncheckedException(throwable);
            }
        }

        private void assertOpen() {
            if (this.lock == null) {
                throw new IllegalStateException("This lock has been closed.");
            }
        }

        @Override
        public void close() {
            CompositeStoppable compositeStoppable = new CompositeStoppable();
            compositeStoppable.add(() -> {
                block11: {
                    if (this.lockFileAccess == null) {
                        return;
                    }
                    try {
                        LOGGER.debug("Releasing lock on {}.", (Object)this.displayName);
                        try {
                            FileLockOutcome fileLockOutcome;
                            if (this.lock == null || this.lock.isShared()) break block11;
                            try {
                                fileLockOutcome = this.lockInformationRegion(FileLockManager.LockMode.Exclusive, DefaultFileLockManager.this.newExponentialBackoff(10000));
                            }
                            catch (InterruptedException interruptedException) {
                                throw UncheckedException.throwAsUncheckedException(interruptedException);
                            }
                            if (!fileLockOutcome.isLockWasAcquired()) break block11;
                            try {
                                this.lockFileAccess.clearLockInfo();
                            }
                            finally {
                                fileLockOutcome.getFileLock().release();
                            }
                        }
                        finally {
                            this.lockFileAccess.close();
                        }
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Failed to release lock on " + this.displayName, exception);
                    }
                }
            });
            compositeStoppable.add(() -> {
                try {
                    DefaultFileLockManager.this.fileLockContentionHandler.stop(this.lockId);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Unable to stop listening for file lock requests for " + this.displayName, exception);
                }
            });
            compositeStoppable.add(() -> {
                this.lock = null;
                this.lockFileAccess = null;
                DefaultFileLockManager.this.lockedFiles.remove(this.target);
            });
            compositeStoppable.stop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LockState lock(FileLockManager.LockMode lockMode) throws Throwable {
            LOGGER.debug("Waiting to acquire {} lock on {}.", (Object)lockMode.toString().toLowerCase(Locale.ROOT), (Object)this.displayName);
            FileLockOutcome fileLockOutcome = this.lockStateRegion(lockMode);
            if (!fileLockOutcome.isLockWasAcquired()) {
                LockInfo lockInfo = this.readInformationRegion(DefaultFileLockManager.this.newExponentialBackoff(10000));
                throw this.timeoutException(this.displayName, this.operationDisplayName, this.lockFile, DefaultFileLockManager.this.metaDataProvider.getProcessIdentifier(), fileLockOutcome, lockInfo);
            }
            java.nio.channels.FileLock fileLock = fileLockOutcome.getFileLock();
            try {
                LockState lockState;
                if (!fileLock.isShared()) {
                    lockState = this.lockFileAccess.ensureLockState();
                    FileLockOutcome fileLockOutcome2 = this.lockInformationRegion(FileLockManager.LockMode.Exclusive, DefaultFileLockManager.this.newExponentialBackoff(10000));
                    if (!fileLockOutcome2.isLockWasAcquired()) {
                        throw new IllegalStateException(String.format("Unable to lock the information region for %s", this.displayName));
                    }
                    try {
                        this.lockFileAccess.writeLockInfo(this.port, this.lockId, DefaultFileLockManager.this.metaDataProvider.getProcessIdentifier(), this.operationDisplayName);
                    }
                    finally {
                        fileLockOutcome2.getFileLock().release();
                    }
                } else {
                    lockState = this.lockFileAccess.readLockState();
                }
                LOGGER.debug("Lock acquired on {}.", (Object)this.displayName);
                this.lock = fileLock;
                return lockState;
            }
            catch (Throwable throwable) {
                fileLock.release();
                throw throwable;
            }
        }

        private LockTimeoutException timeoutException(String string, String string2, File file, String string3, FileLockOutcome fileLockOutcome, LockInfo lockInfo) {
            if (fileLockOutcome == FileLockOutcome.LOCKED_BY_ANOTHER_PROCESS) {
                String string4 = String.format("Timeout waiting to lock %s. It is currently in use by another process.%nOwner PID: %s%nOur PID: %s%nOwner Operation: %s%nOur operation: %s%nLock file: %s", string, lockInfo.pid, string3, lockInfo.operation, string2, file);
                return new LockTimeoutException(string4, file);
            }
            if (fileLockOutcome == FileLockOutcome.LOCKED_BY_THIS_PROCESS) {
                String string5 = String.format("Timeout waiting to lock %s. It is currently in use by this process. Owner Operation: %s%nOur operation: %s%nLock file: %s", string, lockInfo.operation, string2, file);
                return new LockTimeoutException(string5, file);
            }
            throw new IllegalArgumentException("Unexpected lock outcome: " + fileLockOutcome);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LockInfo readInformationRegion(ExponentialBackoff<AwaitableFileLockReleasedSignal> exponentialBackoff) throws IOException, InterruptedException {
            LockInfo lockInfo = new LockInfo();
            FileLockOutcome fileLockOutcome = this.lockInformationRegion(FileLockManager.LockMode.Shared, exponentialBackoff);
            if (!fileLockOutcome.isLockWasAcquired()) {
                LOGGER.debug("Could not lock information region for {}. Ignoring.", (Object)this.displayName);
            } else {
                try {
                    lockInfo = this.lockFileAccess.readLockInfo();
                }
                finally {
                    fileLockOutcome.getFileLock().release();
                }
            }
            return lockInfo;
        }

        private FileLockOutcome lockStateRegion(final FileLockManager.LockMode lockMode) throws IOException, InterruptedException {
            final ExponentialBackoff exponentialBackoff = DefaultFileLockManager.this.newExponentialBackoff(DefaultFileLockManager.this.lockTimeoutMs);
            return exponentialBackoff.retryUntil(new ExponentialBackoff.Query<FileLockOutcome>(){
                private long lastPingTime;
                private int lastLockHolderPort;

                @Override
                public ExponentialBackoff.Result<FileLockOutcome> run() throws IOException, InterruptedException {
                    FileLockOutcome fileLockOutcome = DefaultFileLock.this.lockFileAccess.tryLockState(lockMode == FileLockManager.LockMode.Shared);
                    if (fileLockOutcome.isLockWasAcquired()) {
                        return ExponentialBackoff.Result.successful(fileLockOutcome);
                    }
                    if (DefaultFileLock.this.port != -1) {
                        LockInfo lockInfo = DefaultFileLock.this.readInformationRegion(exponentialBackoff);
                        if (lockInfo.port != -1) {
                            if (lockInfo.port != this.lastLockHolderPort) {
                                exponentialBackoff.restartTimer();
                                this.lastLockHolderPort = lockInfo.port;
                                this.lastPingTime = 0L;
                            }
                            if (DefaultFileLockManager.this.fileLockContentionHandler.maybePingOwner(lockInfo.port, lockInfo.lockId, DefaultFileLock.this.displayName, exponentialBackoff.getTimer().getElapsedMillis() - this.lastPingTime, (FileLockReleasedSignal)exponentialBackoff.getSignal())) {
                                this.lastPingTime = exponentialBackoff.getTimer().getElapsedMillis();
                                LOGGER.debug("The file lock for {} is held by a different process (pid: {}, lockId: {}). Pinged owner at port {}", new Object[]{DefaultFileLock.this.displayName, lockInfo.pid, lockInfo.lockId, lockInfo.port});
                            }
                        } else {
                            LOGGER.debug("The file lock for {} is held by a different process. I was unable to read on which port the owner listens for lock access requests.", (Object)DefaultFileLock.this.displayName);
                        }
                    }
                    return ExponentialBackoff.Result.notSuccessful(fileLockOutcome);
                }
            });
        }

        private FileLockOutcome lockInformationRegion(FileLockManager.LockMode lockMode, ExponentialBackoff<AwaitableFileLockReleasedSignal> exponentialBackoff) throws IOException, InterruptedException {
            return (FileLockOutcome)exponentialBackoff.retryUntil(() -> {
                FileLockOutcome fileLockOutcome = this.lockFileAccess.tryLockInfo(lockMode == FileLockManager.LockMode.Shared);
                if (fileLockOutcome.isLockWasAcquired()) {
                    return ExponentialBackoff.Result.successful(fileLockOutcome);
                }
                return ExponentialBackoff.Result.notSuccessful(fileLockOutcome);
            });
        }
    }

    static class AwaitableFileLockReleasedSignal
    implements FileLockReleasedSignal,
    ExponentialBackoff.Signal {
        private final Lock lock = new ReentrantLock();
        private final Condition condition = this.lock.newCondition();
        private int waiting;

        AwaitableFileLockReleasedSignal() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean await(long l2) throws InterruptedException {
            this.lock.lock();
            try {
                ++this.waiting;
                boolean bl2 = this.condition.await(l2, TimeUnit.MILLISECONDS);
                return bl2;
            }
            finally {
                --this.waiting;
                this.lock.unlock();
            }
        }

        @Override
        public void trigger() {
            this.lock.lock();
            try {
                if (this.waiting > 0) {
                    this.condition.signalAll();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

