/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.gradle.cache.ExclusiveCacheAccessCoordinator;
import org.gradle.cache.FileAccess;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.InsufficientLockModeException;
import org.gradle.cache.LockOptions;
import org.gradle.cache.LockTimeoutException;
import org.gradle.cache.MultiProcessSafeIndexedCache;
import org.gradle.cache.internal.AbstractCrossProcessCacheAccess;
import org.gradle.cache.internal.AbstractFileAccess;
import org.gradle.cache.internal.CacheCleanupExecutor;
import org.gradle.cache.internal.CacheCreationCoordinator;
import org.gradle.cache.internal.CacheInitializationAction;
import org.gradle.cache.internal.ExclusiveCacheAccessingWorker;
import org.gradle.cache.internal.FixedExclusiveModeCrossProcessCacheAccess;
import org.gradle.cache.internal.FixedSharedModeCrossProcessCacheAccess;
import org.gradle.cache.internal.LockOnDemandCrossProcessCacheAccess;
import org.gradle.cache.internal.LockOnDemandEagerReleaseCrossProcessCacheAccess;
import org.gradle.cache.internal.NoLockingCacheAccess;
import org.gradle.cache.internal.cacheops.CacheAccessOperationsStack;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCacheCoordinator
implements ExclusiveCacheAccessCoordinator,
CacheCreationCoordinator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCacheCoordinator.class);
    private final String cacheDisplayName;
    private final File baseDir;
    private final CacheCleanupExecutor cleanupAction;
    private final ExecutorFactory executorFactory;
    private final FileAccess fileAccess;
    private final Map<String, IndexedCacheEntry<?, ?>> caches = new HashMap();
    private final AbstractCrossProcessCacheAccess crossProcessCacheAccess;
    private final CacheAccessOperationsStack operations;
    private ManagedExecutor cacheUpdateExecutor;
    private ExclusiveCacheAccessingWorker cacheAccessWorker;
    private final Lock stateLock = new ReentrantLock();
    private final Condition condition = this.stateLock.newCondition();
    private boolean open;
    private Thread owner;
    private FileLock fileLock;
    private FileLock.State stateAtOpen;
    private Runnable fileLockHeldByOwner;
    private int cacheClosedCount;
    private boolean alreadyCleaned;

    public DefaultCacheCoordinator(String string, File file, LockOptions lockOptions, File file2, FileLockManager fileLockManager, CacheInitializationAction cacheInitializationAction, CacheCleanupExecutor cacheCleanupExecutor, ExecutorFactory executorFactory) {
        this.cacheDisplayName = string;
        this.baseDir = file2;
        this.cleanupAction = cacheCleanupExecutor;
        this.executorFactory = executorFactory;
        this.operations = new CacheAccessOperationsStack();
        Consumer<FileLock> consumer = this::afterLockAcquire;
        Consumer<FileLock> consumer2 = this::beforeLockRelease;
        switch (lockOptions.getMode()) {
            case Shared: {
                this.crossProcessCacheAccess = new FixedSharedModeCrossProcessCacheAccess(string, file, lockOptions, fileLockManager, cacheInitializationAction, consumer, consumer2);
                this.fileAccess = new UnitOfWorkFileAccess();
                break;
            }
            case Exclusive: {
                this.crossProcessCacheAccess = new FixedExclusiveModeCrossProcessCacheAccess(string, file, lockOptions, fileLockManager, cacheInitializationAction, consumer, consumer2);
                this.fileAccess = new UnitOfWorkFileAccess();
                break;
            }
            case OnDemand: {
                this.crossProcessCacheAccess = new LockOnDemandCrossProcessCacheAccess(string, file, lockOptions.copyWithMode(FileLockManager.LockMode.Exclusive), fileLockManager, this.stateLock, cacheInitializationAction, consumer, consumer2);
                this.fileAccess = new UnitOfWorkFileAccess();
                break;
            }
            case OnDemandEagerRelease: {
                this.crossProcessCacheAccess = new LockOnDemandEagerReleaseCrossProcessCacheAccess(string, file, lockOptions.copyWithMode(FileLockManager.LockMode.Exclusive), fileLockManager, this.stateLock, cacheInitializationAction, consumer, consumer2);
                this.fileAccess = new UnitOfWorkFileAccess();
                break;
            }
            case None: {
                this.crossProcessCacheAccess = new NoLockingCacheAccess(this::notifyFinish);
                this.fileAccess = TransparentFileAccess.INSTANCE;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void open() {
        this.withOwnershipNow(() -> {
            if (this.open) {
                throw new IllegalStateException("Cache is already open.");
            }
            try {
                this.crossProcessCacheAccess.open();
                this.open = true;
            }
            catch (Throwable throwable) {
                this.crossProcessCacheAccess.close();
                throw UncheckedException.throwAsUncheckedException(throwable);
            }
        });
    }

    private void doCleanup() {
        try {
            this.cleanupAction.cleanup();
            this.alreadyCleaned = true;
        }
        catch (Exception exception) {
            LOG.debug("Cache {} could not run cleanup action {}", (Object)this.cacheDisplayName, (Object)this.cleanupAction);
        }
    }

    @Override
    public synchronized void close() {
        if (this.cacheAccessWorker != null) {
            this.cacheAccessWorker.stop();
            this.cacheAccessWorker = null;
        }
        if (this.cacheUpdateExecutor != null) {
            this.cacheUpdateExecutor.stop();
            this.cacheUpdateExecutor = null;
        }
        this.withOwnershipNow(() -> {
            try {
                if (this.fileLockHeldByOwner != null) {
                    this.fileLockHeldByOwner.run();
                }
                this.crossProcessCacheAccess.close();
                if (this.cleanupAction != null && !this.alreadyCleaned) {
                    this.doCleanup();
                }
                if (this.cacheClosedCount != 1) {
                    LOG.debug("Cache {} was closed {} times.", (Object)this.cacheDisplayName, (Object)this.cacheClosedCount);
                }
            }
            finally {
                this.owner = null;
                this.fileLockHeldByOwner = null;
            }
        });
    }

    private void withOwnershipNow(Runnable runnable) {
        this.stateLock.lock();
        try {
            this.takeOwnershipNow();
            try {
                runnable.run();
            }
            finally {
                this.releaseOwnership();
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    public void withFileLock(Runnable runnable) {
        this.crossProcessCacheAccess.withFileLock(DefaultCacheCoordinator.toSupplier(runnable));
    }

    @Override
    public void useCache(Runnable runnable) {
        this.useCache(DefaultCacheCoordinator.toSupplier(runnable));
    }

    private static <T> Supplier<T> toSupplier(Runnable runnable) {
        return () -> {
            runnable.run();
            return null;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T useCache(Supplier<? extends T> supplier) {
        boolean bl2;
        this.stateLock.lock();
        try {
            this.takeOwnership();
            try {
                bl2 = this.onStartWork();
            }
            catch (Throwable throwable) {
                this.releaseOwnership();
                throw UncheckedException.throwAsUncheckedException(throwable);
            }
        }
        finally {
            this.stateLock.unlock();
        }
        try {
            T t2 = supplier.get();
            return t2;
        }
        finally {
            this.stateLock.lock();
            try {
                try {
                    if (bl2) {
                        this.onEndWork();
                    }
                }
                finally {
                    this.releaseOwnership();
                }
            }
            finally {
                this.stateLock.unlock();
            }
        }
    }

    private void takeOwnership() {
        while (this.owner != null && this.owner != Thread.currentThread()) {
            try {
                this.condition.await();
            }
            catch (InterruptedException interruptedException) {
                throw UncheckedException.throwAsUncheckedException(interruptedException);
            }
        }
        this.owner = Thread.currentThread();
        this.operations.pushCacheAction();
    }

    private void takeOwnershipNow() {
        if (this.owner != null && this.owner != Thread.currentThread()) {
            throw new IllegalStateException(String.format("Cannot take ownership of %s as it is currently being used by another thread.", this.cacheDisplayName));
        }
        this.owner = Thread.currentThread();
        this.operations.pushCacheAction();
    }

    private void releaseOwnership() {
        this.operations.popCacheAction();
        if (!this.operations.isInCacheAction()) {
            this.owner = null;
            this.condition.signalAll();
        }
    }

    private void afterLockAcquire(FileLock fileLock) {
        assert (this.fileLock == null);
        this.fileLock = fileLock;
        this.stateAtOpen = fileLock.getState();
        this.withOwnershipNow(() -> {
            for (IndexedCacheEntry<?, ?> indexedCacheEntry : this.caches.values()) {
                indexedCacheEntry.getCache().afterLockAcquire(this.stateAtOpen);
            }
        });
    }

    private void beforeLockRelease(FileLock fileLock) {
        assert (this.fileLock == fileLock);
        try {
            ++this.cacheClosedCount;
            this.withOwnershipNow(() -> {
                this.notifyFinish();
                FileLock.State state = fileLock.getState();
                for (IndexedCacheEntry<?, ?> indexedCacheEntry : this.caches.values()) {
                    indexedCacheEntry.getCache().beforeLockRelease(state);
                }
            });
        }
        finally {
            this.fileLock = null;
            this.stateAtOpen = null;
        }
    }

    private void notifyFinish() {
        for (IndexedCacheEntry<?, ?> indexedCacheEntry : this.caches.values()) {
            indexedCacheEntry.getCache().finishWork();
        }
    }

    private boolean onStartWork() {
        if (this.fileLockHeldByOwner != null) {
            return false;
        }
        this.fileLockHeldByOwner = this.crossProcessCacheAccess.acquireFileLock();
        return true;
    }

    private boolean onEndWork() {
        if (this.fileLockHeldByOwner == null) {
            return false;
        }
        try {
            this.fileLockHeldByOwner.run();
        }
        finally {
            this.fileLockHeldByOwner = null;
        }
        return true;
    }

    private FileLock getFileLock() {
        this.stateLock.lock();
        try {
            if (Thread.currentThread() != this.owner) {
                throw new IllegalStateException(String.format("The %s has not been locked for this thread. File lock: %s, owner: %s", this.cacheDisplayName, this.fileLock != null, this.owner));
            }
        }
        finally {
            this.stateLock.unlock();
        }
        return this.fileLock;
    }

    private class UnitOfWorkFileAccess
    extends AbstractFileAccess {
        private UnitOfWorkFileAccess() {
        }

        public String toString() {
            return DefaultCacheCoordinator.this.cacheDisplayName;
        }

        @Override
        public void writeFile(Runnable runnable) throws LockTimeoutException {
            DefaultCacheCoordinator.this.getFileLock().writeFile(runnable);
        }
    }

    private static class TransparentFileAccess
    implements FileAccess {
        private static final FileAccess INSTANCE = new TransparentFileAccess();

        private TransparentFileAccess() {
        }

        @Override
        public void writeFile(Runnable runnable) throws LockTimeoutException, InsufficientLockModeException {
            runnable.run();
        }
    }

    private static class IndexedCacheEntry<K, V> {
        private final MultiProcessSafeIndexedCache<K, V> cache;

        public MultiProcessSafeIndexedCache<K, V> getCache() {
            return this.cache;
        }
    }
}

