/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.internal.fingerprint.hashing.RegularFileSnapshotContext;
import org.gradle.internal.fingerprint.hashing.ResourceHasher;
import org.gradle.internal.fingerprint.hashing.ZipEntryContext;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.io.IoFunction;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.tools.api.ApiClassExtractor;
import org.gradle.internal.tools.api.impl.JavaApiMemberWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbiExtractingClasspathResourceHasher
implements ResourceHasher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbiExtractingClasspathResourceHasher.class);
    public static final AbiExtractingClasspathResourceHasher DEFAULT = AbiExtractingClasspathResourceHasher.withFallback(ApiClassExtractor.withWriter(JavaApiMemberWriter.adapter()).includePackagePrivateMembers().build());
    private final ApiClassExtractor extractor;
    private final FallbackStrategy fallbackStrategy;

    private AbiExtractingClasspathResourceHasher(ApiClassExtractor apiClassExtractor, FallbackStrategy fallbackStrategy) {
        this.extractor = apiClassExtractor;
        this.fallbackStrategy = fallbackStrategy;
    }

    public static AbiExtractingClasspathResourceHasher withFallback(ApiClassExtractor apiClassExtractor) {
        return new AbiExtractingClasspathResourceHasher(apiClassExtractor, FallbackStrategy.FULL_HASH);
    }

    private HashCode hashClassBytes(byte[] byArray) {
        return this.extractor.extractApiClassFrom(byArray).map(Hashing::hashBytes).orElse(null);
    }

    @Override
    public HashCode hash(RegularFileSnapshotContext regularFileSnapshotContext) throws IOException {
        RegularFileSnapshot regularFileSnapshot2 = regularFileSnapshotContext.getSnapshot();
        if (AbiExtractingClasspathResourceHasher.isNotClassFile(regularFileSnapshot2.getName())) {
            return null;
        }
        return this.fallbackStrategy.handle(regularFileSnapshot2, regularFileSnapshot -> {
            Path path = Paths.get(regularFileSnapshot.getAbsolutePath(), new String[0]);
            byte[] byArray = Files.readAllBytes(path);
            return this.hashClassBytes(byArray);
        });
    }

    @Override
    public HashCode hash(ZipEntryContext zipEntryContext) throws IOException {
        ZipEntry zipEntry = zipEntryContext.getEntry();
        if (AbiExtractingClasspathResourceHasher.isNotClassFile(zipEntry.getName())) {
            return null;
        }
        byte[] byArray = zipEntry.getContent();
        return this.fallbackStrategy.handle(new ZipEntryContent(zipEntry.getName(), byArray), zipEntryContent -> this.hashClassBytes(byArray));
    }

    private static boolean isNotClassFile(String string) {
        return !string.endsWith(".class");
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        hasher.putString(this.getClass().getName());
        hasher.putString(this.extractor.getClass().getName());
    }

    static enum FallbackStrategy {
        FULL_HASH{

            @Override
            HashCode handle(RegularFileSnapshot regularFileSnapshot, IoFunction<RegularFileSnapshot, HashCode> ioFunction) {
                try {
                    return ioFunction.apply(regularFileSnapshot);
                }
                catch (Exception exception) {
                    LOGGER.debug("Malformed class file '{}' found on compile classpath. Falling back to full file hash instead of ABI hashing.", (Object)regularFileSnapshot.getName(), (Object)exception);
                    return regularFileSnapshot.getHash();
                }
            }

            @Override
            HashCode handle(ZipEntryContent zipEntryContent, IoFunction<ZipEntryContent, HashCode> ioFunction) {
                try {
                    return ioFunction.apply(zipEntryContent);
                }
                catch (Exception exception) {
                    LOGGER.debug("Malformed class file '{}' found on compile classpath. Falling back to full file hash instead of ABI hashing.", (Object)zipEntryContent.name, (Object)exception);
                    return Hashing.hashBytes(zipEntryContent.content);
                }
            }
        }
        ,
        NONE{

            @Override
            HashCode handle(RegularFileSnapshot regularFileSnapshot, IoFunction<RegularFileSnapshot, HashCode> ioFunction) throws IOException {
                return ioFunction.apply(regularFileSnapshot);
            }

            @Override
            HashCode handle(ZipEntryContent zipEntryContent, IoFunction<ZipEntryContent, HashCode> ioFunction) throws IOException {
                return ioFunction.apply(zipEntryContent);
            }
        };


        abstract HashCode handle(RegularFileSnapshot var1, IoFunction<RegularFileSnapshot, HashCode> var2) throws IOException;

        abstract HashCode handle(ZipEntryContent var1, IoFunction<ZipEntryContent, HashCode> var2) throws IOException;
    }

    private static class ZipEntryContent {
        final String name;
        final byte[] content;

        ZipEntryContent(String string, byte[] byArray) {
            this.name = string;
            this.content = byArray;
        }
    }
}

