/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.util.platform.windows;

import com.gradle.maven.extension.internal.dep.oshi.jna.ByRef;
import com.gradle.maven.extension.internal.dep.oshi.jna.Struct;
import com.gradle.maven.extension.internal.dep.oshi.util.FormatUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.ParseUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.Util;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.Pdh;
import com.sun.jna.platform.win32.VersionHelpers;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PerfDataUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PerfDataUtil.class);
    private static final BaseTSD.DWORD_PTR PZERO = new BaseTSD.DWORD_PTR(0L);
    private static final WinDef.DWORDByReference PDH_FMT_RAW = new WinDef.DWORDByReference(new WinDef.DWORD(16L));
    private static final Pdh PDH = Pdh.INSTANCE;
    private static final boolean IS_VISTA_OR_GREATER = VersionHelpers.IsWindowsVistaOrGreater();

    private PerfDataUtil() {
    }

    public static PerfCounter createCounter(String string, String string2, String string3) {
        return new PerfCounter(string, string2, string3);
    }

    public static long updateQueryTimestamp(WinNT.HANDLEByReference hANDLEByReference) {
        try (ByRef.CloseableLONGLONGByReference closeableLONGLONGByReference = new ByRef.CloseableLONGLONGByReference();){
            int n2 = IS_VISTA_OR_GREATER ? PDH.PdhCollectQueryDataWithTime(hANDLEByReference.getValue(), closeableLONGLONGByReference) : PDH.PdhCollectQueryData(hANDLEByReference.getValue());
            int n3 = 0;
            while (n2 == -2147481643 && n3++ < 3) {
                Util.sleep(1 << n3);
                n2 = IS_VISTA_OR_GREATER ? PDH.PdhCollectQueryDataWithTime(hANDLEByReference.getValue(), closeableLONGLONGByReference) : PDH.PdhCollectQueryData(hANDLEByReference.getValue());
            }
            if (n2 != 0) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Failed to update counter. Error code: {}", (Object)String.format(Locale.ROOT, FormatUtil.formatError(n2), new Object[0]));
                }
                long l2 = 0L;
                return l2;
            }
            long l3 = IS_VISTA_OR_GREATER ? ParseUtil.filetimeToUtcMs(closeableLONGLONGByReference.getValue().longValue(), true) : System.currentTimeMillis();
            return l3;
        }
    }

    public static boolean openQuery(WinNT.HANDLEByReference hANDLEByReference) {
        int n2 = PDH.PdhOpenQuery(null, PZERO, hANDLEByReference);
        if (n2 != 0) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Failed to open PDH Query. Error code: {}", (Object)String.format(Locale.ROOT, FormatUtil.formatError(n2), new Object[0]));
            }
            return false;
        }
        return true;
    }

    public static boolean closeQuery(WinNT.HANDLEByReference hANDLEByReference) {
        return 0 == PDH.PdhCloseQuery(hANDLEByReference.getValue());
    }

    public static long queryCounter(WinNT.HANDLEByReference hANDLEByReference) {
        try (Struct.CloseablePdhRawCounter closeablePdhRawCounter = new Struct.CloseablePdhRawCounter();){
            int n2 = PDH.PdhGetRawCounterValue(hANDLEByReference.getValue(), PDH_FMT_RAW, closeablePdhRawCounter);
            if (n2 != 0) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Failed to get counter. Error code: {}", (Object)String.format(Locale.ROOT, FormatUtil.formatError(n2), new Object[0]));
                }
                long l2 = n2;
                return l2;
            }
            long l3 = closeablePdhRawCounter.FirstValue;
            return l3;
        }
    }

    public static long querySecondCounter(WinNT.HANDLEByReference hANDLEByReference) {
        try (Struct.CloseablePdhRawCounter closeablePdhRawCounter = new Struct.CloseablePdhRawCounter();){
            int n2 = PDH.PdhGetRawCounterValue(hANDLEByReference.getValue(), PDH_FMT_RAW, closeablePdhRawCounter);
            if (n2 != 0) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Failed to get counter. Error code: {}", (Object)String.format(Locale.ROOT, FormatUtil.formatError(n2), new Object[0]));
                }
                long l2 = n2;
                return l2;
            }
            long l3 = closeablePdhRawCounter.SecondValue;
            return l3;
        }
    }

    public static boolean addCounter(WinNT.HANDLEByReference hANDLEByReference, String string, WinNT.HANDLEByReference hANDLEByReference2) {
        int n2;
        int n3 = n2 = IS_VISTA_OR_GREATER ? PDH.PdhAddEnglishCounter(hANDLEByReference.getValue(), string, PZERO, hANDLEByReference2) : PDH.PdhAddCounter(hANDLEByReference.getValue(), string, PZERO, hANDLEByReference2);
        if (n2 != 0) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Failed to add PDH Counter: {}, Error code: {}", (Object)string, (Object)String.format(Locale.ROOT, FormatUtil.formatError(n2), new Object[0]));
            }
            return false;
        }
        return true;
    }

    public static boolean removeCounter(WinNT.HANDLEByReference hANDLEByReference) {
        return 0 == PDH.PdhRemoveCounter(hANDLEByReference.getValue());
    }

    public static class PerfCounter {
        private final String object;
        private final String instance;
        private final String counter;
        private final boolean baseCounter;

        public PerfCounter(String string, String string2, String string3) {
            this.object = string;
            this.instance = string2;
            int n2 = string3.indexOf("_Base");
            if (n2 > 0) {
                this.counter = string3.substring(0, n2);
                this.baseCounter = true;
            } else {
                this.counter = string3;
                this.baseCounter = false;
            }
        }

        public boolean isBaseCounter() {
            return this.baseCounter;
        }

        public String getCounterPath() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('\\').append(this.object);
            if (this.instance != null) {
                stringBuilder.append('(').append(this.instance).append(')');
            }
            stringBuilder.append('\\').append(this.counter);
            return stringBuilder.toString();
        }
    }
}

