/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.software.os.mac;

import com.gradle.maven.extension.internal.dep.oshi.jna.Struct;
import com.gradle.maven.extension.internal.dep.oshi.software.common.AbstractOperatingSystem;
import com.gradle.maven.extension.internal.dep.oshi.software.os.ApplicationInfo;
import com.gradle.maven.extension.internal.dep.oshi.software.os.OSProcess;
import com.gradle.maven.extension.internal.dep.oshi.software.os.OperatingSystem;
import com.gradle.maven.extension.internal.dep.oshi.software.os.mac.MacInstalledApps;
import com.gradle.maven.extension.internal.dep.oshi.software.os.mac.MacOSProcess;
import com.gradle.maven.extension.internal.dep.oshi.util.ExecutingCommand;
import com.gradle.maven.extension.internal.dep.oshi.util.FileUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.Memoizer;
import com.gradle.maven.extension.internal.dep.oshi.util.ParseUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.Util;
import com.gradle.maven.extension.internal.dep.oshi.util.platform.mac.SysctlUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.tuples.Pair;
import com.sun.jna.platform.mac.SystemB;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacOperatingSystem
extends AbstractOperatingSystem {
    private static final Logger LOG = LoggerFactory.getLogger(MacOperatingSystem.class);
    private int maxProc = 1024;
    private final String osXVersion;
    private final int major;
    private final int minor;
    private final Supplier<List<ApplicationInfo>> installedAppsSupplier = Memoizer.memoize(MacInstalledApps::queryInstalledApps, Memoizer.installedAppsExpiration());
    private static final long BOOTTIME;

    public MacOperatingSystem() {
        String string = System.getProperty("os.version");
        int n2 = ParseUtil.getFirstIntValue(string);
        int n3 = ParseUtil.getNthIntValue(string, 2);
        if (n2 == 10 && n3 > 15) {
            String string2 = ExecutingCommand.getFirstAnswer("sw_vers -productVersion");
            if (!string2.isEmpty()) {
                string = string2;
            }
            n2 = ParseUtil.getFirstIntValue(string);
            n3 = ParseUtil.getNthIntValue(string, 2);
        }
        this.osXVersion = string;
        this.major = n2;
        this.minor = n3;
        this.maxProc = SysctlUtil.sysctl("kern.maxproc", 4096);
    }

    @Override
    public String queryManufacturer() {
        return "Apple";
    }

    @Override
    public Pair<String, OperatingSystem.OSVersionInfo> queryFamilyVersionInfo() {
        String string = this.major > 10 || this.major == 10 && this.minor >= 12 ? "macOS" : System.getProperty("os.name");
        String string2 = this.parseCodeName();
        String string3 = SysctlUtil.sysctl("kern.osversion", "");
        return new Pair<String, OperatingSystem.OSVersionInfo>(string, new OperatingSystem.OSVersionInfo(this.osXVersion, string2, string3));
    }

    private String parseCodeName() {
        Properties properties = FileUtil.readPropertiesFromFilename("oshi.macos.versions.properties");
        String string = null;
        if (this.major > 10) {
            string = properties.getProperty(Integer.toString(this.major));
        } else if (this.major == 10) {
            string = properties.getProperty(this.major + "." + this.minor);
        }
        if (Util.isBlank(string)) {
            LOG.warn("Unable to parse version {}.{} to a codename.", (Object)this.major, (Object)this.minor);
        }
        return string;
    }

    @Override
    protected int queryBitness(int n2) {
        if (n2 == 64 || this.major == 10 && this.minor > 6) {
            return 64;
        }
        return ParseUtil.parseIntOrDefault(ExecutingCommand.getFirstAnswer("getconf LONG_BIT"), 32);
    }

    @Override
    public List<OSProcess> queryAllProcesses() {
        ArrayList<OSProcess> arrayList = new ArrayList<OSProcess>();
        int[] nArray = new int[this.maxProc];
        Arrays.fill(nArray, -1);
        int n2 = SystemB.INSTANCE.proc_listpids(1, 0, nArray, nArray.length * SystemB.INT_SIZE) / SystemB.INT_SIZE;
        for (int i2 = 0; i2 < n2; ++i2) {
            OSProcess oSProcess;
            if (nArray[i2] < 0 || (oSProcess = this.getProcess(nArray[i2])) == null) continue;
            arrayList.add(oSProcess);
        }
        return arrayList;
    }

    public OSProcess getProcess(int n2) {
        MacOSProcess macOSProcess = new MacOSProcess(n2, this.major, this.minor, this);
        return macOSProcess.getState().equals((Object)OSProcess.State.INVALID) ? null : macOSProcess;
    }

    @Override
    public int getProcessId() {
        return SystemB.INSTANCE.getpid();
    }

    static {
        try (Struct.CloseableTimeval closeableTimeval = new Struct.CloseableTimeval();){
            BOOTTIME = !SysctlUtil.sysctl("kern.boottime", closeableTimeval) || closeableTimeval.tv_sec.longValue() == 0L ? ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("sysctl -n kern.boottime").split(",")[0].replaceAll("\\D", ""), System.currentTimeMillis() / 1000L) : closeableTimeval.tv_sec.longValue();
        }
    }
}

