/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.software.os.mac;

import com.gradle.maven.extension.internal.dep.oshi.jna.platform.mac.CoreFoundation;
import com.gradle.maven.extension.internal.dep.oshi.software.os.ApplicationInfo;
import com.gradle.maven.extension.internal.dep.oshi.util.ExecutingCommand;
import com.gradle.maven.extension.internal.dep.oshi.util.ParseUtil;
import com.sun.jna.platform.mac.CoreFoundation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public final class MacInstalledApps {
    private static final CoreFoundation CF = CoreFoundation.INSTANCE;

    public static List<ApplicationInfo> queryInstalledApps() {
        List<String> list = ExecutingCommand.runNative("system_profiler SPApplicationsDataType");
        return MacInstalledApps.parseMacAppInfo(list);
    }

    private static List<ApplicationInfo> parseMacAppInfo(List<String> list) {
        LinkedHashSet<ApplicationInfo> linkedHashSet = new LinkedHashSet<ApplicationInfo>();
        String string = null;
        HashMap<String, String> hashMap = null;
        boolean bl2 = false;
        String string2 = MacInstalledApps.getLocaleDateTimeFormat(CoreFoundation.CFDateFormatterStyle.kCFDateFormatterShortStyle);
        for (String string3 : list) {
            if ((string3 = string3.trim()).endsWith(":")) {
                if (string != null && !hashMap.isEmpty()) {
                    linkedHashSet.add(MacInstalledApps.createAppInfo(string, (Map<String, String>)hashMap, string2));
                }
                string = string3.substring(0, string3.length() - 1);
                hashMap = new HashMap<String, String>();
                bl2 = true;
                continue;
            }
            if (!bl2 || !string3.contains(":")) continue;
            int n2 = string3.indexOf(":");
            String string4 = string3.substring(0, n2).trim();
            String string5 = string3.substring(n2 + 1).trim();
            hashMap.put(string4, string5);
        }
        return new ArrayList<ApplicationInfo>(linkedHashSet);
    }

    private static ApplicationInfo createAppInfo(String string, Map<String, String> map, String string2) {
        String string3 = ParseUtil.getValueOrUnknown(map, "Obtained from");
        String string4 = ParseUtil.getValueOrUnknown(map, "Signed by");
        String string5 = string3.equals("Identified Developer") ? string4 : string3;
        String string6 = map.getOrDefault("Last Modified", "unknown");
        long l2 = ParseUtil.parseDateToEpoch(string6, string2);
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("Kind", ParseUtil.getValueOrUnknown(map, "Kind"));
        linkedHashMap.put("Location", ParseUtil.getValueOrUnknown(map, "Location"));
        linkedHashMap.put("Get Info String", ParseUtil.getValueOrUnknown(map, "Get Info String"));
        return new ApplicationInfo(string, ParseUtil.getValueOrUnknown(map, "Version"), string5, l2, linkedHashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getLocaleDateTimeFormat(CoreFoundation.CFDateFormatterStyle cFDateFormatterStyle) {
        CoreFoundation.CFIndex cFIndex = cFDateFormatterStyle.index();
        CoreFoundation.CFLocale cFLocale = CF.CFLocaleCopyCurrent();
        try {
            String string;
            CoreFoundation.CFDateFormatter cFDateFormatter = CF.CFDateFormatterCreate(null, cFLocale, cFIndex, cFIndex);
            if (cFDateFormatter == null) {
                String string2 = "";
                return string2;
            }
            try {
                CoreFoundation.CFStringRef cFStringRef = CF.CFDateFormatterGetFormat(cFDateFormatter);
                string = cFStringRef == null ? "" : cFStringRef.stringValue();
            }
            catch (Throwable throwable) {
                CF.CFRelease(cFDateFormatter);
                throw throwable;
            }
            CF.CFRelease(cFDateFormatter);
            return string;
        }
        finally {
            CF.CFRelease(cFLocale);
        }
    }
}

