/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.hardware.platform.linux;

import com.gradle.maven.extension.internal.dep.oshi.driver.linux.Lshw;
import com.gradle.maven.extension.internal.dep.oshi.driver.linux.proc.CpuInfo;
import com.gradle.maven.extension.internal.dep.oshi.driver.linux.proc.CpuStat;
import com.gradle.maven.extension.internal.dep.oshi.hardware.CentralProcessor;
import com.gradle.maven.extension.internal.dep.oshi.hardware.common.AbstractCentralProcessor;
import com.gradle.maven.extension.internal.dep.oshi.software.os.linux.LinuxOperatingSystem;
import com.gradle.maven.extension.internal.dep.oshi.util.ExecutingCommand;
import com.gradle.maven.extension.internal.dep.oshi.util.FileUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.ParseUtil;
import com.gradle.maven.extension.internal.dep.oshi.util.Util;
import com.gradle.maven.extension.internal.dep.oshi.util.platform.linux.ProcPath;
import com.gradle.maven.extension.internal.dep.oshi.util.platform.linux.SysPath;
import com.gradle.maven.extension.internal.dep.oshi.util.tuples.Quartet;
import com.sun.jna.platform.linux.Udev;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LinuxCentralProcessor
extends AbstractCentralProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(LinuxCentralProcessor.class);

    LinuxCentralProcessor() {
    }

    @Override
    protected CentralProcessor.ProcessorIdentifier queryProcessorId() {
        Object object;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        long l2 = 0L;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = new String[]{};
        List<String> list = FileUtil.readFile(ProcPath.CPUINFO);
        block25: for (String object2 : list) {
            object = ParseUtil.whitespacesColonWhitespace.split(object2);
            if (((String[])object).length < 2) {
                if (!object2.startsWith("CPU architecture: ")) continue;
                string3 = object2.replace("CPU architecture: ", "").trim();
                continue;
            }
            block14 : switch (object[0].toLowerCase(Locale.ROOT)) {
                case "vendor_id": 
                case "cpu implementer": {
                    string = object[1];
                    break;
                }
                case "model name": 
                case "processor": {
                    if (object[1].matches("[0-9]+")) break;
                    string2 = object[1];
                    break;
                }
                case "flags": {
                    for (String string6 : stringArray = object[1].toLowerCase(Locale.ROOT).split(" ")) {
                        if (!"lm".equals(string6)) continue;
                        bl2 = true;
                        break block14;
                    }
                    continue block25;
                }
                case "stepping": {
                    string5 = object[1];
                    break;
                }
                case "cpu variant": {
                    if (stringBuilder.toString().startsWith("r")) break;
                    int n2 = ParseUtil.parseLastInt(object[1], 0);
                    stringBuilder.insert(0, "r" + n2);
                    break;
                }
                case "cpu revision": {
                    if (stringBuilder.toString().contains("p")) break;
                    stringBuilder.append('p').append(object[1]);
                    break;
                }
                case "model": 
                case "cpu part": {
                    string4 = object[1];
                    break;
                }
                case "cpu family": {
                    string3 = object[1];
                    break;
                }
                case "cpu mhz": {
                    l2 = ParseUtil.parseHertz(object[1]);
                    break;
                }
            }
        }
        if (string2.isEmpty()) {
            string2 = FileUtil.getStringFromFile(ProcPath.MODEL).trim();
        }
        if (string2.contains("Hz")) {
            l2 = -1L;
        } else {
            long l3 = Lshw.queryCpuCapacity();
            if (l3 > l2) {
                l2 = l3;
            }
        }
        if (string5.isEmpty()) {
            string5 = stringBuilder.toString();
        }
        String string7 = LinuxCentralProcessor.getProcessorID(string, string5, string4, string3, stringArray);
        if (string.startsWith("0x") || string4.isEmpty() || string2.isEmpty()) {
            List<String> list2 = ExecutingCommand.runNative("lscpu");
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (((String)object).startsWith("Architecture:") && string.startsWith("0x")) {
                    string = ((String)object).replace("Architecture:", "").trim();
                    continue;
                }
                if (((String)object).startsWith("Vendor ID:")) {
                    string = ((String)object).replace("Vendor ID:", "").trim();
                    continue;
                }
                if (!((String)object).startsWith("Model name:")) continue;
                String string8 = ((String)object).replace("Model name:", "").trim();
                string4 = string4.isEmpty() ? string8 : string4;
                string2 = string2.isEmpty() ? string8 : string2;
            }
        }
        return new CentralProcessor.ProcessorIdentifier(string, string2, string3, string4, string5, string7, bl2, l2);
    }

    @Override
    protected Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>, List<String>> initProcessorCounts() {
        Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.ProcessorCache>, Map<Integer, Integer>, Map<Integer, String>> quartet;
        Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.ProcessorCache>, Map<Integer, Integer>, Map<Integer, String>> quartet2 = quartet = LinuxOperatingSystem.HAS_UDEV ? LinuxCentralProcessor.readTopologyFromUdev() : LinuxCentralProcessor.readTopologyFromSysfs();
        if (quartet.getA().isEmpty()) {
            quartet = LinuxCentralProcessor.readTopologyFromCpuinfo();
        }
        List<CentralProcessor.LogicalProcessor> list = quartet.getA();
        List<CentralProcessor.ProcessorCache> list2 = quartet.getB();
        Map<Integer, Integer> map = quartet.getC();
        Map<Integer, String> map2 = quartet.getD();
        if (list.isEmpty()) {
            list.add(new CentralProcessor.LogicalProcessor(0, 0, 0));
        }
        if (map.isEmpty()) {
            map.put(0, 0);
        }
        list.sort(Comparator.comparingInt(CentralProcessor.LogicalProcessor::getProcessorNumber));
        List list3 = map.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> {
            int n2 = (Integer)entry.getKey() >> 16;
            int n3 = (Integer)entry.getKey() & 0xFFFF;
            return new CentralProcessor.PhysicalProcessor(n2, n3, (Integer)entry.getValue(), map2.getOrDefault(entry.getKey(), ""));
        }).collect(Collectors.toList());
        List<String> list4 = CpuInfo.queryFeatureFlags();
        return new Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>, List<String>>(list, list3, list2, list4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.ProcessorCache>, Map<Integer, Integer>, Map<Integer, String>> readTopologyFromUdev() {
        ArrayList<CentralProcessor.LogicalProcessor> arrayList = new ArrayList<CentralProcessor.LogicalProcessor>();
        HashSet<CentralProcessor.ProcessorCache> hashSet = new HashSet<CentralProcessor.ProcessorCache>();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        HashMap<Integer, String> hashMap2 = new HashMap<Integer, String>();
        Udev.UdevContext udevContext = Udev.INSTANCE.udev_new();
        try {
            Udev.UdevEnumerate udevEnumerate = udevContext.enumerateNew();
            try {
                udevEnumerate.addMatchSubsystem("cpu");
                udevEnumerate.scanDevices();
                for (Udev.UdevListEntry udevListEntry = udevEnumerate.getListEntry(); udevListEntry != null; udevListEntry = udevListEntry.getNext()) {
                    String string = udevListEntry.getName();
                    Udev.UdevDevice udevDevice = udevContext.deviceNewFromSyspath(string);
                    String string2 = null;
                    if (udevDevice != null) {
                        try {
                            string2 = udevDevice.getPropertyValue("MODALIAS");
                        }
                        finally {
                            udevDevice.unref();
                        }
                    }
                    arrayList.add(LinuxCentralProcessor.getLogicalProcessorFromSyspath(string, hashSet, string2, hashMap, hashMap2));
                }
            }
            finally {
                udevEnumerate.unref();
            }
        }
        finally {
            udevContext.unref();
        }
        return new Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.ProcessorCache>, Map<Integer, Integer>, Map<Integer, String>>(arrayList, LinuxCentralProcessor.orderedProcCaches(hashSet), hashMap, hashMap2);
    }

    private static Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.ProcessorCache>, Map<Integer, Integer>, Map<Integer, String>> readTopologyFromSysfs() {
        ArrayList arrayList = new ArrayList();
        HashSet<CentralProcessor.ProcessorCache> hashSet = new HashSet<CentralProcessor.ProcessorCache>();
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        try (Stream<Path> stream = Files.find(Paths.get(SysPath.CPU, new String[0]), Integer.MAX_VALUE, (path, basicFileAttributes) -> path.toFile().getName().matches("cpu\\d+"), new FileVisitOption[0]);){
            stream.forEach(path -> {
                String string = path.toString();
                Map<String, String> map3 = FileUtil.getKeyValueMapFromFile(string + "/uevent", "=");
                String string2 = map3.get("MODALIAS");
                arrayList.add(LinuxCentralProcessor.getLogicalProcessorFromSyspath(string, hashSet, string2, hashMap, hashMap2));
            });
        }
        catch (IOException iOException) {
            LOG.warn("Unable to find CPU information in sysfs at path {}", (Object)SysPath.CPU);
        }
        return new Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.ProcessorCache>, Map<Integer, Integer>, Map<Integer, String>>(arrayList, LinuxCentralProcessor.orderedProcCaches(hashSet), hashMap, hashMap2);
    }

    private static CentralProcessor.LogicalProcessor getLogicalProcessorFromSyspath(String string, Set<CentralProcessor.ProcessorCache> set, String string2, Map<Integer, Integer> map, Map<Integer, String> map2) {
        Object object;
        Object object2;
        int n2 = ParseUtil.getFirstIntValue(string);
        int n3 = FileUtil.getIntFromFile(string + "/topology/core_id");
        int n4 = FileUtil.getIntFromFile(string + "/topology/physical_package_id");
        int n5 = (n4 << 16) + n3;
        map.put(n5, FileUtil.getIntFromFile(string + "/cpu_capacity"));
        if (!Util.isBlank(string2)) {
            map2.put(n5, string2);
        }
        int n6 = 0;
        String string3 = string + "/node";
        try {
            object2 = Files.list(Paths.get(string, new String[0]));
            try {
                object = object2.filter(path -> path.toString().startsWith(string3)).findFirst();
                if (((Optional)object).isPresent()) {
                    n6 = ParseUtil.getFirstIntValue(((Optional)object).get().getFileName().toString());
                }
            }
            finally {
                if (object2 != null) {
                    object2.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object2 = string + "/cache";
        object = (String)object2 + "/index";
        try (Stream<Path> stream = Files.list(Paths.get((String)object2, new String[0]));){
            stream.filter(arg_0 -> LinuxCentralProcessor.lambda$getLogicalProcessorFromSyspath$4((String)object, arg_0)).forEach(path -> {
                int n2 = FileUtil.getIntFromFile(path + "/level");
                CentralProcessor.ProcessorCache.Type type = LinuxCentralProcessor.parseCacheType(FileUtil.getStringFromFile(path + "/type"));
                int n3 = FileUtil.getIntFromFile(path + "/ways_of_associativity");
                int n4 = FileUtil.getIntFromFile(path + "/coherency_line_size");
                long l2 = ParseUtil.parseDecimalMemorySizeToBinary(FileUtil.getStringFromFile(path + "/size"));
                set.add(new CentralProcessor.ProcessorCache(n2, n3, n4, l2, type));
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new CentralProcessor.LogicalProcessor(n2, n3, n4, n6);
    }

    private static CentralProcessor.ProcessorCache.Type parseCacheType(String string) {
        try {
            return CentralProcessor.ProcessorCache.Type.valueOf(string.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return CentralProcessor.ProcessorCache.Type.UNIFIED;
        }
    }

    private static Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.ProcessorCache>, Map<Integer, Integer>, Map<Integer, String>> readTopologyFromCpuinfo() {
        ArrayList<CentralProcessor.LogicalProcessor> arrayList = new ArrayList<CentralProcessor.LogicalProcessor>();
        Set<CentralProcessor.ProcessorCache> set = LinuxCentralProcessor.mapCachesFromLscpu();
        Map<Integer, Integer> map = LinuxCentralProcessor.mapNumaNodesFromLscpu();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        List<String> list = FileUtil.readFile(ProcPath.CPUINFO);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = true;
        for (String string : list) {
            if (string.startsWith("processor")) {
                if (bl2) {
                    bl2 = false;
                } else {
                    arrayList.add(new CentralProcessor.LogicalProcessor(n2, n3, n4, map.getOrDefault(n2, 0)));
                    hashMap.put((n4 << 16) + n3, 0);
                }
                n2 = ParseUtil.parseLastInt(string, 0);
                continue;
            }
            if (string.startsWith("core id") || string.startsWith("cpu number")) {
                n3 = ParseUtil.parseLastInt(string, 0);
                continue;
            }
            if (!string.startsWith("physical id")) continue;
            n4 = ParseUtil.parseLastInt(string, 0);
        }
        arrayList.add(new CentralProcessor.LogicalProcessor(n2, n3, n4, map.getOrDefault(n2, 0)));
        hashMap.put((n4 << 16) + n3, 0);
        return new Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.ProcessorCache>, Map<Integer, Integer>, Map<Integer, String>>(arrayList, LinuxCentralProcessor.orderedProcCaches(set), hashMap, Collections.emptyMap());
    }

    private static Map<Integer, Integer> mapNumaNodesFromLscpu() {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        List<String> list = ExecutingCommand.runNative("lscpu -p=cpu,node");
        for (String string : list) {
            int n2;
            if (string.startsWith("#") || (n2 = string.indexOf(44)) <= 0 || n2 >= string.length()) continue;
            hashMap.put(ParseUtil.parseIntOrDefault(string.substring(0, n2), 0), ParseUtil.parseIntOrDefault(string.substring(n2 + 1), 0));
        }
        return hashMap;
    }

    private static Set<CentralProcessor.ProcessorCache> mapCachesFromLscpu() {
        HashSet<CentralProcessor.ProcessorCache> hashSet = new HashSet<CentralProcessor.ProcessorCache>();
        int n2 = 0;
        CentralProcessor.ProcessorCache.Type type = null;
        int n3 = 0;
        int n4 = 0;
        long l2 = 0L;
        List<String> list = ExecutingCommand.runNative("lscpu -B -C --json");
        for (String string : list) {
            String[] stringArray;
            String string2 = string.trim();
            if (string2.startsWith("}")) {
                if (n2 > 0 && type != null) {
                    hashSet.add(new CentralProcessor.ProcessorCache(n2, n3, n4, l2, type));
                }
                n2 = 0;
                type = null;
                n3 = 0;
                n4 = 0;
                l2 = 0L;
                continue;
            }
            if (string2.contains("one-size")) {
                stringArray = ParseUtil.notDigits.split(string2);
                if (stringArray.length <= 1) continue;
                l2 = ParseUtil.parseLongOrDefault(stringArray[1], 0L);
                continue;
            }
            if (string2.contains("ways")) {
                stringArray = ParseUtil.notDigits.split(string2);
                if (stringArray.length <= 1) continue;
                n3 = ParseUtil.parseIntOrDefault(stringArray[1], 0);
                continue;
            }
            if (string2.contains("type")) {
                stringArray = string2.split("\"");
                if (stringArray.length <= 2) continue;
                type = LinuxCentralProcessor.parseCacheType(stringArray[stringArray.length - 2]);
                continue;
            }
            if (string2.contains("level")) {
                stringArray = ParseUtil.notDigits.split(string2);
                if (stringArray.length <= 1) continue;
                n2 = ParseUtil.parseIntOrDefault(stringArray[1], 0);
                continue;
            }
            if (!string2.contains("coherency-size") || (stringArray = ParseUtil.notDigits.split(string2)).length <= 1) continue;
            n4 = ParseUtil.parseIntOrDefault(stringArray[1], 0);
        }
        return hashSet;
    }

    @Override
    public long[] querySystemCpuLoadTicks() {
        long[] lArray = CpuStat.getSystemCpuLoadTicks();
        if (LongStream.of(lArray).sum() == 0L) {
            lArray = CpuStat.getSystemCpuLoadTicks();
        }
        long l2 = LinuxOperatingSystem.getHz();
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            lArray[i2] = lArray[i2] * 1000L / l2;
        }
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] queryCurrentFreq() {
        Object object;
        Object object2;
        long[] lArray = new long[this.getLogicalProcessorCount()];
        long l2 = 0L;
        Udev.UdevContext udevContext = Udev.INSTANCE.udev_new();
        try {
            object2 = udevContext.enumerateNew();
            try {
                ((Udev.UdevEnumerate)object2).addMatchSubsystem("cpu");
                ((Udev.UdevEnumerate)object2).scanDevices();
                for (Udev.UdevListEntry udevListEntry = ((Udev.UdevEnumerate)object2).getListEntry(); udevListEntry != null; udevListEntry = udevListEntry.getNext()) {
                    object = udevListEntry.getName();
                    int n2 = ParseUtil.getFirstIntValue((String)object);
                    if (n2 >= 0 && n2 < lArray.length) {
                        lArray[n2] = FileUtil.getLongFromFile((String)object + "/cpufreq/scaling_cur_freq");
                        if (lArray[n2] == 0L) {
                            lArray[n2] = FileUtil.getLongFromFile((String)object + "/cpufreq/cpuinfo_cur_freq");
                        }
                    }
                    if (l2 >= lArray[n2]) continue;
                    l2 = lArray[n2];
                }
                if (l2 > 0L) {
                    int n3 = 0;
                    while (n3 < lArray.length) {
                        int n4 = n3++;
                        lArray[n4] = lArray[n4] * 1000L;
                    }
                    long[] lArray2 = lArray;
                    return lArray2;
                }
            }
            finally {
                ((Udev.UdevEnumerate)object2).unref();
            }
        }
        finally {
            udevContext.unref();
        }
        Arrays.fill(lArray, -1L);
        object2 = FileUtil.readFile(ProcPath.CPUINFO);
        int n5 = 0;
        object = object2.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (!string.toLowerCase(Locale.ROOT).contains("cpu mhz")) continue;
            lArray[n5] = Math.round(ParseUtil.parseLastDouble(string, 0.0) * 1000000.0);
            if (++n5 < lArray.length) continue;
            break;
        }
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long queryMaxFreq() {
        long l2;
        block15: {
            l2 = -1L;
            Udev.UdevContext udevContext = Udev.INSTANCE.udev_new();
            try {
                Udev.UdevEnumerate udevEnumerate = udevContext.enumerateNew();
                try {
                    udevEnumerate.addMatchSubsystem("cpu");
                    udevEnumerate.scanDevices();
                    Udev.UdevListEntry udevListEntry = udevEnumerate.getListEntry();
                    if (udevListEntry == null) break block15;
                    String string = udevListEntry.getName();
                    String string2 = string.substring(0, string.lastIndexOf(File.separatorChar)) + "/cpufreq";
                    String string3 = string2 + "/policy";
                    try (Stream<Path> stream = Files.list(Paths.get(string2, new String[0]));){
                        Optional<Long> optional = stream.filter(path -> path.toString().startsWith(string3)).map(path -> {
                            long l2 = FileUtil.getLongFromFile(path.toString() + "/scaling_max_freq");
                            if (l2 == 0L) {
                                l2 = FileUtil.getLongFromFile(path.toString() + "/cpuinfo_max_freq");
                            }
                            return l2;
                        }).max(Long::compare);
                        if (optional.isPresent()) {
                            l2 = optional.get() * 1000L;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                finally {
                    udevEnumerate.unref();
                }
            }
            finally {
                udevContext.unref();
            }
        }
        long l3 = Lshw.queryCpuCapacity();
        return LongStream.concat(LongStream.of(l2, l3), Arrays.stream(this.getCurrentFreq())).max().orElse(-1L);
    }

    @Override
    public long[][] queryProcessorCpuLoadTicks() {
        long[][] lArray = CpuStat.getProcessorCpuLoadTicks(this.getLogicalProcessorCount());
        if (LongStream.of(lArray[0]).sum() == 0L) {
            lArray = CpuStat.getProcessorCpuLoadTicks(this.getLogicalProcessorCount());
        }
        long l2 = LinuxOperatingSystem.getHz();
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            for (int i3 = 0; i3 < lArray[i2].length; ++i3) {
                lArray[i2][i3] = lArray[i2][i3] * 1000L / l2;
            }
        }
        return lArray;
    }

    private static String getProcessorID(String string, String string2, String string3, String string4, String[] stringArray) {
        boolean bl2 = false;
        String string5 = "Processor Information";
        for (String string6 : ExecutingCommand.runNative("dmidecode -t 4")) {
            if (!bl2 && string6.contains(string5)) {
                string5 = "ID:";
                bl2 = true;
                continue;
            }
            if (!bl2 || !string6.contains(string5)) continue;
            return string6.split(string5)[1].trim();
        }
        string5 = "eax=";
        for (String string6 : ExecutingCommand.runNative("cpuid -1r")) {
            if (!string6.contains(string5) || !string6.trim().startsWith("0x00000001")) continue;
            String string7 = "";
            String string8 = "";
            for (String string9 : ParseUtil.whitespaces.split(string6)) {
                if (string9.startsWith("eax=")) {
                    string7 = ParseUtil.removeMatchingString(string9, "eax=0x");
                    continue;
                }
                if (!string9.startsWith("edx=")) continue;
                string8 = ParseUtil.removeMatchingString(string9, "edx=0x");
            }
            return string8 + string7;
        }
        if (string.startsWith("0x")) {
            return LinuxCentralProcessor.createMIDR(string, string2, string3, string4) + "00000000";
        }
        return LinuxCentralProcessor.createProcessorID(string2, string3, string4, stringArray);
    }

    private static String createMIDR(String string, String string2, String string3, String string4) {
        int n2 = 0;
        if (string2.startsWith("r") && string2.contains("p")) {
            String[] stringArray = string2.substring(1).split("p");
            n2 |= ParseUtil.parseLastInt(stringArray[1], 0);
            n2 |= ParseUtil.parseLastInt(stringArray[0], 0) << 20;
        }
        n2 |= ParseUtil.parseLastInt(string3, 0) << 4;
        n2 |= ParseUtil.parseLastInt(string4, 0) << 16;
        return String.format(Locale.ROOT, "%08X", n2 |= ParseUtil.parseLastInt(string, 0) << 24);
    }

    @Override
    public long queryContextSwitches() {
        return CpuStat.getContextSwitches();
    }

    @Override
    public long queryInterrupts() {
        return CpuStat.getInterrupts();
    }

    private static /* synthetic */ boolean lambda$getLogicalProcessorFromSyspath$4(String string, Path path) {
        return path.toString().startsWith(string);
    }
}

