/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support;

import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.Converter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.ConverterFactory;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support.ConversionUtils;

final class StringToEnumConverterFactory
implements ConverterFactory<String, Enum> {
    StringToEnumConverterFactory() {
    }

    @Override
    public <T extends Enum> Converter<String, T> getConverter(Class<T> clazz) {
        return new StringToEnum(ConversionUtils.getEnumType(clazz));
    }

    private static class StringToEnum<T extends Enum>
    implements Converter<String, T> {
        private final Class<T> enumType;

        StringToEnum(Class<T> clazz) {
            this.enumType = clazz;
        }

        @Override
        public T convert(String string) {
            if (string.isEmpty()) {
                return null;
            }
            return Enum.valueOf(this.enumType, string.trim());
        }
    }
}

