/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support;

import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.ConversionService;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.ConditionalGenericConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.GenericConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ClassUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ReflectionUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Set;

final class IdToEntityConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    public IdToEntityConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Object.class));
    }

    @Override
    public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        Method method = this.getFinder(typeDescriptor2.getType());
        return method != null && this.conversionService.canConvert(typeDescriptor, TypeDescriptor.valueOf(method.getParameterTypes()[0]));
    }

    @Override
    public Object convert(Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        if (object == null) {
            return null;
        }
        Method method = this.getFinder(typeDescriptor2.getType());
        Assert.state(method != null, "No finder method");
        Object object2 = this.conversionService.convert(object, typeDescriptor, TypeDescriptor.valueOf(method.getParameterTypes()[0]));
        return ReflectionUtils.invokeMethod(method, object, object2);
    }

    private Method getFinder(Class<?> clazz) {
        boolean bl2;
        Method[] methodArray;
        String string = "find" + this.getEntityName(clazz);
        try {
            methodArray = clazz.getDeclaredMethods();
            bl2 = true;
        }
        catch (SecurityException securityException) {
            methodArray = clazz.getMethods();
            bl2 = false;
        }
        for (Method method : methodArray) {
            if (!Modifier.isStatic(method.getModifiers()) || !method.getName().equals(string) || method.getParameterCount() != 1 || !method.getReturnType().equals(clazz) || !bl2 && !method.getDeclaringClass().equals(clazz)) continue;
            return method;
        }
        return null;
    }

    private String getEntityName(Class<?> clazz) {
        String string = ClassUtils.getShortName(clazz);
        int n2 = string.lastIndexOf(46);
        if (n2 != -1) {
            return string.substring(n2 + 1);
        }
        return string;
    }
}

