/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.logging.impl;

import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.Log;
import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.LogConfigurationException;
import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.LogFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.spi.LocationAwareLogger;

public final class Slf4jLogFactory
extends LogFactory {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Marker MARKER = MarkerFactory.getMarker((String)"COMMONS-LOGGING");
    private final ConcurrentMap<String, Log> loggers = new ConcurrentHashMap<String, Log>();
    private final ConcurrentMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    @Override
    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    @Override
    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    @Override
    public Log getInstance(Class<?> clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    @Override
    public Log getInstance(String string2) {
        return this.loggers.computeIfAbsent(string2, string -> {
            Logger logger = LoggerFactory.getLogger((String)string);
            return logger instanceof LocationAwareLogger ? new Slf4jLocationAwareLog((LocationAwareLogger)logger) : new Slf4jLog(logger);
        });
    }

    @Override
    public void release() {
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        try {
            iLoggerFactory.getClass().getMethod("stop", new Class[0]).invoke((Object)iLoggerFactory, new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    @Override
    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (object != null) {
            this.attributes.put(string, object);
        } else {
            this.removeAttribute(string);
        }
    }

    private static final class Slf4jLocationAwareLog
    implements Log {
        private static final String FQCN = Slf4jLocationAwareLog.class.getName();
        private final LocationAwareLogger logger;

        public Slf4jLocationAwareLog(LocationAwareLogger locationAwareLogger) {
            this.logger = locationAwareLogger;
        }

        @Override
        public void debug(Object object) {
            this.log(10, object, null);
        }

        @Override
        public void debug(Object object, Throwable throwable) {
            this.log(10, object, throwable);
        }

        @Override
        public void error(Object object) {
            this.log(40, object, null);
        }

        @Override
        public void error(Object object, Throwable throwable) {
            this.log(40, object, throwable);
        }

        public void fatal(Object object) {
            this.error(object);
        }

        public void fatal(Object object, Throwable throwable) {
            this.error(object, throwable);
        }

        @Override
        public void info(Object object) {
            this.log(20, object, null);
        }

        public void info(Object object, Throwable throwable) {
            this.log(20, object, throwable);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled(MARKER);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled(MARKER);
        }

        public boolean isFatalEnabled() {
            return this.isErrorEnabled();
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled(MARKER);
        }

        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled(MARKER);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled(MARKER);
        }

        private void log(int n2, Object object, Throwable throwable) {
            this.logger.log(MARKER, FQCN, n2, String.valueOf(object), EMPTY_OBJECT_ARRAY, throwable);
        }

        @Override
        public void trace(Object object) {
            this.log(0, object, null);
        }

        public void trace(Object object, Throwable throwable) {
            this.log(0, object, throwable);
        }

        @Override
        public void warn(Object object) {
            this.log(30, object, null);
        }

        @Override
        public void warn(Object object, Throwable throwable) {
            this.log(30, object, throwable);
        }
    }

    private static class Slf4jLog
    implements Log {
        private final Logger logger;

        public Slf4jLog(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void debug(Object object) {
            this.logger.debug(MARKER, String.valueOf(object));
        }

        @Override
        public void debug(Object object, Throwable throwable) {
            this.logger.debug(MARKER, String.valueOf(object), throwable);
        }

        @Override
        public void error(Object object) {
            this.logger.error(MARKER, String.valueOf(object));
        }

        @Override
        public void error(Object object, Throwable throwable) {
            this.logger.debug(MARKER, String.valueOf(object), throwable);
        }

        public void fatal(Object object) {
            this.error(object);
        }

        public void fatal(Object object, Throwable throwable) {
            this.error(object, throwable);
        }

        @Override
        public void info(Object object) {
            this.logger.info(MARKER, String.valueOf(object));
        }

        public void info(Object object, Throwable throwable) {
            this.logger.info(MARKER, String.valueOf(object), throwable);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled(MARKER);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled(MARKER);
        }

        public boolean isFatalEnabled() {
            return this.isErrorEnabled();
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled(MARKER);
        }

        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled(MARKER);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled(MARKER);
        }

        @Override
        public void trace(Object object) {
            this.logger.trace(MARKER, String.valueOf(object));
        }

        public void trace(Object object, Throwable throwable) {
            this.logger.trace(MARKER, String.valueOf(object), throwable);
        }

        @Override
        public void warn(Object object) {
            this.logger.warn(MARKER, String.valueOf(object));
        }

        @Override
        public void warn(Object object, Throwable throwable) {
            this.logger.warn(MARKER, String.valueOf(object), throwable);
        }
    }
}

