/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.logging.impl;

import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.Log;
import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.LogConfigurationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.security.AccessController;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;

public class SimpleLog
implements Serializable,
Log {
    private static final long serialVersionUID = 136942970684951178L;
    protected static final String systemPrefix = "com.gradle.maven.extension.internal.dep.org.apache.commons.logging.simplelog.";
    protected static final Properties simpleLogProps = new Properties();
    protected static final String DEFAULT_DATE_TIME_FORMAT = "yyyy/MM/dd HH:mm:ss:SSS zzz";
    protected static volatile boolean showLogName;
    protected static volatile boolean showShortName;
    protected static volatile boolean showDateTime;
    protected static volatile String dateTimeFormat;
    protected static DateFormat dateFormatter;
    public static final int LOG_LEVEL_TRACE = 1;
    public static final int LOG_LEVEL_DEBUG = 2;
    public static final int LOG_LEVEL_INFO = 3;
    public static final int LOG_LEVEL_WARN = 4;
    public static final int LOG_LEVEL_ERROR = 5;
    public static final int LOG_LEVEL_FATAL = 6;
    public static final int LOG_LEVEL_ALL = 0;
    public static final int LOG_LEVEL_OFF = 7;
    protected volatile String logName;
    protected volatile int currentLogLevel;
    private volatile String shortLogName;

    private static boolean getBooleanProperty(String string, boolean bl2) {
        String string2 = SimpleLog.getStringProperty(string);
        return string2 == null ? bl2 : Boolean.parseBoolean(string2);
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader classLoader;
        block3: {
            classLoader = null;
            try {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException instanceof SecurityException) break block3;
                throw new LogConfigurationException("Unexpected SecurityException", runtimeException);
            }
        }
        if (classLoader == null) {
            classLoader = SimpleLog.class.getClassLoader();
        }
        return classLoader;
    }

    private static InputStream getResourceAsStream(String string) {
        return AccessController.doPrivileged(() -> {
            ClassLoader classLoader = SimpleLog.getContextClassLoader();
            if (classLoader != null) {
                return classLoader.getResourceAsStream(string);
            }
            return ClassLoader.getSystemResourceAsStream(string);
        });
    }

    private static String getStringProperty(String string) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return string2 == null ? simpleLogProps.getProperty(string) : string2;
    }

    private static String getStringProperty(String string, String string2) {
        String string3 = SimpleLog.getStringProperty(string);
        return string3 == null ? string2 : string3;
    }

    public SimpleLog(String string) {
        this.logName = string;
        this.setLevel(3);
        String string2 = SimpleLog.getStringProperty("com.gradle.maven.extension.internal.dep.org.apache.commons.logging.simplelog.log." + this.logName);
        int n2 = String.valueOf(string).lastIndexOf(".");
        while (string2 == null && n2 > -1) {
            string = string.substring(0, n2);
            string2 = SimpleLog.getStringProperty("com.gradle.maven.extension.internal.dep.org.apache.commons.logging.simplelog.log." + string);
            n2 = String.valueOf(string).lastIndexOf(".");
        }
        if (string2 == null) {
            string2 = SimpleLog.getStringProperty("com.gradle.maven.extension.internal.dep.org.apache.commons.logging.simplelog.defaultlog");
        }
        if (string2 != null) {
            string2 = string2.toLowerCase(Locale.ROOT);
        }
        if (string2 != null) {
            switch (string2) {
                case "all": {
                    this.setLevel(0);
                    break;
                }
                case "trace": {
                    this.setLevel(1);
                    break;
                }
                case "debug": {
                    this.setLevel(2);
                    break;
                }
                case "info": {
                    this.setLevel(3);
                    break;
                }
                case "warn": {
                    this.setLevel(4);
                    break;
                }
                case "error": {
                    this.setLevel(5);
                    break;
                }
                case "fatal": {
                    this.setLevel(6);
                    break;
                }
                case "off": {
                    this.setLevel(7);
                    break;
                }
            }
        }
    }

    @Override
    public final void debug(Object object) {
        if (this.isLevelEnabled(2)) {
            this.log(2, object, null);
        }
    }

    @Override
    public final void debug(Object object, Throwable throwable) {
        if (this.isLevelEnabled(2)) {
            this.log(2, object, throwable);
        }
    }

    @Override
    public final void error(Object object) {
        if (this.isLevelEnabled(5)) {
            this.log(5, object, null);
        }
    }

    @Override
    public final void error(Object object, Throwable throwable) {
        if (this.isLevelEnabled(5)) {
            this.log(5, object, throwable);
        }
    }

    public final void fatal(Object object) {
        if (this.isLevelEnabled(6)) {
            this.log(6, object, null);
        }
    }

    public final void fatal(Object object, Throwable throwable) {
        if (this.isLevelEnabled(6)) {
            this.log(6, object, throwable);
        }
    }

    public int getLevel() {
        return this.currentLogLevel;
    }

    @Override
    public final void info(Object object) {
        if (this.isLevelEnabled(3)) {
            this.log(3, object, null);
        }
    }

    public final void info(Object object, Throwable throwable) {
        if (this.isLevelEnabled(3)) {
            this.log(3, object, throwable);
        }
    }

    @Override
    public final boolean isDebugEnabled() {
        return this.isLevelEnabled(2);
    }

    @Override
    public final boolean isErrorEnabled() {
        return this.isLevelEnabled(5);
    }

    public final boolean isFatalEnabled() {
        return this.isLevelEnabled(6);
    }

    @Override
    public final boolean isInfoEnabled() {
        return this.isLevelEnabled(3);
    }

    protected boolean isLevelEnabled(int n2) {
        return n2 >= this.currentLogLevel;
    }

    public final boolean isTraceEnabled() {
        return this.isLevelEnabled(1);
    }

    @Override
    public final boolean isWarnEnabled() {
        return this.isLevelEnabled(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(int n2, Object object, Throwable throwable) {
        Object object2;
        Object object3;
        StringBuilder stringBuilder = new StringBuilder();
        if (showDateTime) {
            object3 = new Date();
            DateFormat dateFormat = dateFormatter;
            synchronized (dateFormat) {
                object2 = dateFormatter.format((Date)object3);
            }
            stringBuilder.append((String)object2);
            stringBuilder.append(" ");
        }
        switch (n2) {
            case 1: {
                stringBuilder.append("[TRACE] ");
                break;
            }
            case 2: {
                stringBuilder.append("[DEBUG] ");
                break;
            }
            case 3: {
                stringBuilder.append("[INFO] ");
                break;
            }
            case 4: {
                stringBuilder.append("[WARN] ");
                break;
            }
            case 5: {
                stringBuilder.append("[ERROR] ");
                break;
            }
            case 6: {
                stringBuilder.append("[FATAL] ");
                break;
            }
            default: {
                stringBuilder.append("[UNDEFINED] ");
            }
        }
        if (showShortName) {
            if (this.shortLogName == null) {
                object3 = this.logName.substring(this.logName.lastIndexOf(".") + 1);
                this.shortLogName = ((String)object3).substring(((String)object3).lastIndexOf("/") + 1);
            }
            stringBuilder.append(String.valueOf(this.shortLogName)).append(" - ");
        } else if (showLogName) {
            stringBuilder.append(String.valueOf(this.logName)).append(" - ");
        }
        stringBuilder.append(String.valueOf(object));
        if (throwable != null) {
            stringBuilder.append(" <");
            stringBuilder.append(throwable.toString());
            stringBuilder.append(">");
            object3 = new StringWriter(1024);
            object2 = new PrintWriter((Writer)object3);
            try {
                throwable.printStackTrace((PrintWriter)object2);
            }
            finally {
                ((PrintWriter)object2).close();
            }
            stringBuilder.append(((StringWriter)object3).toString());
        }
        this.write(stringBuilder);
    }

    public void setLevel(int n2) {
        this.currentLogLevel = n2;
    }

    @Override
    public final void trace(Object object) {
        if (this.isLevelEnabled(1)) {
            this.log(1, object, null);
        }
    }

    public final void trace(Object object, Throwable throwable) {
        if (this.isLevelEnabled(1)) {
            this.log(1, object, throwable);
        }
    }

    @Override
    public final void warn(Object object) {
        if (this.isLevelEnabled(4)) {
            this.log(4, object, null);
        }
    }

    @Override
    public final void warn(Object object, Throwable throwable) {
        if (this.isLevelEnabled(4)) {
            this.log(4, object, throwable);
        }
    }

    private void write(Object object) {
        System.err.println(Objects.toString(object));
    }

    protected void write(StringBuffer stringBuffer) {
        System.err.println(Objects.toString(stringBuffer));
    }

    static {
        showShortName = true;
        dateTimeFormat = DEFAULT_DATE_TIME_FORMAT;
        try (InputStream inputStream = SimpleLog.getResourceAsStream("simplelog.properties");){
            if (null != inputStream) {
                simpleLogProps.load(inputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        showLogName = SimpleLog.getBooleanProperty("com.gradle.maven.extension.internal.dep.org.apache.commons.logging.simplelog.showlogname", showLogName);
        showShortName = SimpleLog.getBooleanProperty("com.gradle.maven.extension.internal.dep.org.apache.commons.logging.simplelog.showShortLogname", showShortName);
        showDateTime = SimpleLog.getBooleanProperty("com.gradle.maven.extension.internal.dep.org.apache.commons.logging.simplelog.showdatetime", showDateTime);
        if (showDateTime) {
            dateTimeFormat = SimpleLog.getStringProperty("com.gradle.maven.extension.internal.dep.org.apache.commons.logging.simplelog.dateTimeFormat", dateTimeFormat);
            try {
                dateFormatter = new SimpleDateFormat(dateTimeFormat);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                dateTimeFormat = DEFAULT_DATE_TIME_FORMAT;
                dateFormatter = new SimpleDateFormat(dateTimeFormat);
            }
        }
    }
}

