/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.AbstractShortCollection;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortArrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortCollection;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortConsumer;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortIterators;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortList;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortListIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortSpliterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.shorts.ShortSpliterators;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;

public abstract class AbstractShortList
extends AbstractShortCollection
implements ShortList {
    protected AbstractShortList() {
    }

    protected void ensureIndex(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    @Override
    public void add(int n2, short s2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(short s2) {
        this.add(this.size(), s2);
        return true;
    }

    @Override
    public short removeShort(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short set(int n2, short s2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int n2, Collection<? extends Short> collection) {
        if (collection instanceof ShortCollection) {
            return this.addAll(n2, (ShortCollection)collection);
        }
        this.ensureIndex(n2);
        Iterator<? extends Short> iterator = collection.iterator();
        boolean bl2 = iterator.hasNext();
        while (iterator.hasNext()) {
            this.add(n2++, (short)iterator.next());
        }
        return bl2;
    }

    @Override
    public boolean addAll(Collection<? extends Short> collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public ShortListIterator iterator() {
        return this.listIterator();
    }

    @Override
    public ShortListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ShortListIterator listIterator(int n2) {
        this.ensureIndex(n2);
        return new ShortIterators.AbstractIndexBasedListIterator(0, n2){

            @Override
            protected final short get(int n2) {
                return AbstractShortList.this.getShort(n2);
            }

            @Override
            protected final void add(int n2, short s2) {
                AbstractShortList.this.add(n2, s2);
            }

            @Override
            protected final void set(int n2, short s2) {
                AbstractShortList.this.set(n2, s2);
            }

            @Override
            protected final void remove(int n2) {
                AbstractShortList.this.removeShort(n2);
            }

            @Override
            protected final int getMaxPos() {
                return AbstractShortList.this.size();
            }
        };
    }

    @Override
    public boolean contains(short s2) {
        return this.indexOf(s2) >= 0;
    }

    @Override
    public int indexOf(short s2) {
        ShortListIterator shortListIterator = this.listIterator();
        while (shortListIterator.hasNext()) {
            short s3 = shortListIterator.nextShort();
            if (s2 != s3) continue;
            return shortListIterator.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(short s2) {
        ShortListIterator shortListIterator = this.listIterator(this.size());
        while (shortListIterator.hasPrevious()) {
            short s3 = shortListIterator.previousShort();
            if (s2 != s3) continue;
            return shortListIterator.nextIndex();
        }
        return -1;
    }

    @Override
    public ShortList subList(int n2, int n3) {
        this.ensureIndex(n2);
        this.ensureIndex(n3);
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
        }
        return this instanceof RandomAccess ? new ShortRandomAccessSubList(this, n2, n3) : new ShortSubList(this, n2, n3);
    }

    @Override
    public void forEach(ShortConsumer shortConsumer) {
        if (this instanceof RandomAccess) {
            int n2 = this.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                shortConsumer.accept(this.getShort(i2));
            }
        } else {
            ShortList.super.forEach(shortConsumer);
        }
    }

    @Override
    public void removeElements(int n2, int n3) {
        this.ensureIndex(n3);
        ShortListIterator shortListIterator = this.listIterator(n2);
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw new IllegalArgumentException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
        }
        while (n4-- != 0) {
            shortListIterator.nextShort();
            shortListIterator.remove();
        }
    }

    @Override
    public void getElements(int n2, short[] sArray, int n3, int n4) {
        this.ensureIndex(n2);
        ShortArrays.ensureOffsetLength(sArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        if (this instanceof RandomAccess) {
            int n5 = n2;
            while (n4-- != 0) {
                sArray[n3++] = this.getShort(n5++);
            }
        } else {
            ShortListIterator shortListIterator = this.listIterator(n2);
            while (n4-- != 0) {
                sArray[n3++] = shortListIterator.nextShort();
            }
        }
    }

    @Override
    public void setElements(int n2, short[] sArray, int n3, int n4) {
        this.ensureIndex(n2);
        ShortArrays.ensureOffsetLength(sArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        if (this instanceof RandomAccess) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.set(i2 + n2, sArray[i2 + n3]);
            }
        } else {
            ShortListIterator shortListIterator = this.listIterator(n2);
            int n5 = 0;
            while (n5 < n4) {
                shortListIterator.nextShort();
                shortListIterator.set(sArray[n3 + n5++]);
            }
        }
    }

    @Override
    public void clear() {
        this.removeElements(0, this.size());
    }

    @Override
    public int hashCode() {
        ShortListIterator shortListIterator = this.iterator();
        int n2 = 1;
        int n3 = this.size();
        while (n3-- != 0) {
            short s2 = shortListIterator.nextShort();
            n2 = 31 * n2 + s2;
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        int n2 = this.size();
        if (n2 != list.size()) {
            return false;
        }
        if (list instanceof ShortList) {
            ShortListIterator shortListIterator = this.listIterator();
            ShortListIterator shortListIterator2 = ((ShortList)list).listIterator();
            while (n2-- != 0) {
                if (shortListIterator.nextShort() == shortListIterator2.nextShort()) continue;
                return false;
            }
            return true;
        }
        ShortListIterator shortListIterator = this.listIterator();
        ListIterator listIterator = list.listIterator();
        while (n2-- != 0) {
            if (Objects.equals(shortListIterator.next(), listIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(List<? extends Short> list) {
        if (list == this) {
            return 0;
        }
        if (list instanceof ShortList) {
            ShortListIterator shortListIterator = this.listIterator();
            ShortListIterator shortListIterator2 = ((ShortList)list).listIterator();
            while (shortListIterator.hasNext() && shortListIterator2.hasNext()) {
                short s2;
                short s3 = shortListIterator.nextShort();
                int n2 = Short.compare(s3, s2 = shortListIterator2.nextShort());
                if (n2 == 0) continue;
                return n2;
            }
            return shortListIterator2.hasNext() ? -1 : (shortListIterator.hasNext() ? 1 : 0);
        }
        ShortListIterator shortListIterator = this.listIterator();
        ListIterator<? extends Short> listIterator = list.listIterator();
        while (shortListIterator.hasNext() && listIterator.hasNext()) {
            int n3 = ((Comparable)shortListIterator.next()).compareTo(listIterator.next());
            if (n3 == 0) continue;
            return n3;
        }
        return listIterator.hasNext() ? -1 : (shortListIterator.hasNext() ? 1 : 0);
    }

    @Override
    public boolean rem(short s2) {
        int n2 = this.indexOf(s2);
        if (n2 == -1) {
            return false;
        }
        this.removeShort(n2);
        return true;
    }

    @Override
    public short[] toShortArray() {
        int n2 = this.size();
        if (n2 == 0) {
            return ShortArrays.EMPTY_ARRAY;
        }
        short[] sArray = new short[n2];
        this.getElements(0, sArray, 0, n2);
        return sArray;
    }

    public boolean addAll(int n2, ShortCollection shortCollection) {
        this.ensureIndex(n2);
        ShortIterator shortIterator = shortCollection.iterator();
        boolean bl2 = shortIterator.hasNext();
        while (shortIterator.hasNext()) {
            this.add(n2++, shortIterator.nextShort());
        }
        return bl2;
    }

    @Override
    public boolean addAll(ShortCollection shortCollection) {
        return this.addAll(this.size(), shortCollection);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        ShortListIterator shortListIterator = this.iterator();
        int n2 = this.size();
        boolean bl2 = true;
        stringBuilder.append("[");
        while (n2-- != 0) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(", ");
            }
            short s2 = shortListIterator.nextShort();
            stringBuilder.append(String.valueOf(s2));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static class ShortRandomAccessSubList
    extends ShortSubList
    implements RandomAccess {
        public ShortRandomAccessSubList(ShortList shortList, int n2, int n3) {
            super(shortList, n2, n3);
        }

        @Override
        public ShortList subList(int n2, int n3) {
            this.ensureIndex(n2);
            this.ensureIndex(n3);
            if (n2 > n3) {
                throw new IllegalArgumentException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
            }
            return new ShortRandomAccessSubList(this, n2, n3);
        }
    }

    public static class ShortSubList
    extends AbstractShortList
    implements Serializable {
        protected final ShortList l;
        protected final int from;
        protected int to;

        public ShortSubList(ShortList shortList, int n2, int n3) {
            this.l = shortList;
            this.from = n2;
            this.to = n3;
        }

        private boolean assertRange() {
            assert (this.from <= this.l.size());
            assert (this.to <= this.l.size());
            assert (this.to >= this.from);
            return true;
        }

        @Override
        public boolean add(short s2) {
            this.l.add(this.to, s2);
            ++this.to;
            assert (this.assertRange());
            return true;
        }

        @Override
        public void add(int n2, short s2) {
            this.ensureIndex(n2);
            this.l.add(this.from + n2, s2);
            ++this.to;
            assert (this.assertRange());
        }

        @Override
        public boolean addAll(int n2, Collection<? extends Short> collection) {
            this.ensureIndex(n2);
            this.to += collection.size();
            return this.l.addAll(this.from + n2, collection);
        }

        @Override
        public short getShort(int n2) {
            this.ensureRestrictedIndex(n2);
            return this.l.getShort(this.from + n2);
        }

        @Override
        public short removeShort(int n2) {
            this.ensureRestrictedIndex(n2);
            --this.to;
            return this.l.removeShort(this.from + n2);
        }

        @Override
        public short set(int n2, short s2) {
            this.ensureRestrictedIndex(n2);
            return this.l.set(this.from + n2, s2);
        }

        @Override
        public int size() {
            return this.to - this.from;
        }

        @Override
        public void getElements(int n2, short[] sArray, int n3, int n4) {
            this.ensureIndex(n2);
            if (n2 + n4 > this.size()) {
                throw new IndexOutOfBoundsException("End index (" + n2 + n4 + ") is greater than list size (" + this.size() + ")");
            }
            this.l.getElements(this.from + n2, sArray, n3, n4);
        }

        @Override
        public void removeElements(int n2, int n3) {
            this.ensureIndex(n2);
            this.ensureIndex(n3);
            this.l.removeElements(this.from + n2, this.from + n3);
            this.to -= n3 - n2;
            assert (this.assertRange());
        }

        @Override
        public void setElements(int n2, short[] sArray, int n3, int n4) {
            this.ensureIndex(n2);
            this.l.setElements(this.from + n2, sArray, n3, n4);
            assert (this.assertRange());
        }

        @Override
        public ShortListIterator listIterator(int n2) {
            this.ensureIndex(n2);
            return this.l instanceof RandomAccess ? new RandomAccessIter(n2) : new ParentWrappingIter(this.l.listIterator(n2 + this.from));
        }

        @Override
        public ShortSpliterator spliterator() {
            return this.l instanceof RandomAccess ? new IndexBasedSpliterator(this.l, this.from, this.to) : super.spliterator();
        }

        @Override
        public ShortList subList(int n2, int n3) {
            this.ensureIndex(n2);
            this.ensureIndex(n3);
            if (n2 > n3) {
                throw new IllegalArgumentException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
            }
            return new ShortSubList(this, n2, n3);
        }

        @Override
        public boolean rem(short s2) {
            int n2 = this.indexOf(s2);
            if (n2 == -1) {
                return false;
            }
            --this.to;
            this.l.removeShort(this.from + n2);
            assert (this.assertRange());
            return true;
        }

        @Override
        public boolean addAll(int n2, ShortCollection shortCollection) {
            this.ensureIndex(n2);
            return super.addAll(n2, shortCollection);
        }

        private final class RandomAccessIter
        extends ShortIterators.AbstractIndexBasedListIterator {
            RandomAccessIter(int n2) {
                super(0, n2);
            }

            @Override
            protected final short get(int n2) {
                return ShortSubList.this.l.getShort(ShortSubList.this.from + n2);
            }

            @Override
            protected final void add(int n2, short s2) {
                ShortSubList.this.add(n2, s2);
            }

            @Override
            protected final void set(int n2, short s2) {
                ShortSubList.this.set(n2, s2);
            }

            @Override
            protected final void remove(int n2) {
                ShortSubList.this.removeShort(n2);
            }

            @Override
            protected final int getMaxPos() {
                return ShortSubList.this.to - ShortSubList.this.from;
            }

            @Override
            public void add(short s2) {
                super.add(s2);
                assert (ShortSubList.this.assertRange());
            }

            @Override
            public void remove() {
                super.remove();
                assert (ShortSubList.this.assertRange());
            }
        }

        private class ParentWrappingIter
        implements ShortListIterator {
            private ShortListIterator parent;

            ParentWrappingIter(ShortListIterator shortListIterator) {
                this.parent = shortListIterator;
            }

            @Override
            public int nextIndex() {
                return this.parent.nextIndex() - ShortSubList.this.from;
            }

            @Override
            public int previousIndex() {
                return this.parent.previousIndex() - ShortSubList.this.from;
            }

            @Override
            public boolean hasNext() {
                return this.parent.nextIndex() < ShortSubList.this.to;
            }

            @Override
            public boolean hasPrevious() {
                return this.parent.previousIndex() >= ShortSubList.this.from;
            }

            @Override
            public short nextShort() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.parent.nextShort();
            }

            @Override
            public short previousShort() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                return this.parent.previousShort();
            }

            @Override
            public void add(short s2) {
                this.parent.add(s2);
            }

            @Override
            public void set(short s2) {
                this.parent.set(s2);
            }

            @Override
            public void remove() {
                this.parent.remove();
            }
        }
    }

    static final class IndexBasedSpliterator
    extends ShortSpliterators.LateBindingSizeIndexBasedSpliterator {
        final ShortList l;

        IndexBasedSpliterator(ShortList shortList, int n2) {
            super(n2);
            this.l = shortList;
        }

        IndexBasedSpliterator(ShortList shortList, int n2, int n3) {
            super(n2, n3);
            this.l = shortList;
        }

        @Override
        protected final int getMaxPosFromBackingStore() {
            return this.l.size();
        }

        @Override
        protected final short get(int n2) {
            return this.l.getShort(n2);
        }

        @Override
        protected final IndexBasedSpliterator makeForSplit(int n2, int n3) {
            return new IndexBasedSpliterator(this.l, n2, n3);
        }
    }
}

