/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.Size64;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs.AbstractLongList;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs.LongArrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs.LongCollection;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs.LongComparator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs.LongComparators;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs.LongListIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs.LongSpliterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.longs.LongSpliterators;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.LongUnaryOperator;
import java.util.function.UnaryOperator;

public interface LongList
extends LongCollection,
Comparable<List<? extends Long>>,
List<Long> {
    @Override
    public LongListIterator iterator();

    @Override
    default public LongSpliterator spliterator() {
        if (this instanceof RandomAccess) {
            return new AbstractLongList.IndexBasedSpliterator(this, 0);
        }
        return LongSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 16720);
    }

    public LongListIterator listIterator();

    public LongListIterator listIterator(int var1);

    public LongList subList(int var1, int var2);

    public void getElements(int var1, long[] var2, int var3, int var4);

    public void removeElements(int var1, int var2);

    default public void setElements(long[] lArray) {
        this.setElements(0, lArray);
    }

    default public void setElements(int n2, long[] lArray) {
        this.setElements(n2, lArray, 0, lArray.length);
    }

    default public void setElements(int n2, long[] lArray, int n3, int n4) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than list size (" + this.size() + ")");
        }
        LongArrays.ensureOffsetLength(lArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        LongListIterator longListIterator = this.listIterator(n2);
        int n5 = 0;
        while (n5 < n4) {
            longListIterator.nextLong();
            longListIterator.set(lArray[n3 + n5++]);
        }
    }

    @Override
    public boolean add(long var1);

    @Override
    public void add(int var1, long var2);

    @Override
    @Deprecated
    default public void add(int n2, Long l2) {
        this.add(n2, (long)l2);
    }

    @Override
    public long set(int var1, long var2);

    default public void replaceAll(LongUnaryOperator longUnaryOperator) {
        LongListIterator longListIterator = this.listIterator();
        while (longListIterator.hasNext()) {
            longListIterator.set(longUnaryOperator.applyAsLong(longListIterator.nextLong()));
        }
    }

    @Override
    @Deprecated
    default public void replaceAll(UnaryOperator<Long> unaryOperator) {
        Objects.requireNonNull(unaryOperator);
        this.replaceAll(unaryOperator instanceof LongUnaryOperator ? (LongUnaryOperator)((Object)unaryOperator) : unaryOperator::apply);
    }

    public long getLong(int var1);

    public int indexOf(long var1);

    public int lastIndexOf(long var1);

    @Override
    @Deprecated
    default public boolean contains(Object object) {
        return LongCollection.super.contains(object);
    }

    @Override
    @Deprecated
    default public Long get(int n2) {
        return this.getLong(n2);
    }

    @Override
    @Deprecated
    default public int indexOf(Object object) {
        return this.indexOf((Long)object);
    }

    @Override
    @Deprecated
    default public int lastIndexOf(Object object) {
        return this.lastIndexOf((Long)object);
    }

    @Override
    @Deprecated
    default public boolean add(Long l2) {
        return this.add((long)l2);
    }

    public long removeLong(int var1);

    @Override
    @Deprecated
    default public boolean remove(Object object) {
        return LongCollection.super.remove(object);
    }

    @Override
    @Deprecated
    default public Long remove(int n2) {
        return this.removeLong(n2);
    }

    @Override
    @Deprecated
    default public Long set(int n2, Long l2) {
        return this.set(n2, (long)l2);
    }

    @Override
    @Deprecated
    default public void sort(Comparator<? super Long> comparator) {
        this.sort(LongComparators.asLongComparator(comparator));
    }

    default public void sort(LongComparator longComparator) {
        if (longComparator == null) {
            this.unstableSort(longComparator);
        } else {
            long[] lArray = this.toLongArray();
            LongArrays.stableSort(lArray, longComparator);
            this.setElements(lArray);
        }
    }

    default public void unstableSort(LongComparator longComparator) {
        long[] lArray = this.toLongArray();
        if (longComparator == null) {
            LongArrays.unstableSort(lArray);
        } else {
            LongArrays.unstableSort(lArray, longComparator);
        }
        this.setElements(lArray);
    }
}

