/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.AbstractFloatSpliterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatArrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatComparator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatConsumer;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatSpliterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;

public final class FloatSpliterators {
    public static final EmptySpliterator EMPTY_SPLITERATOR = new EmptySpliterator();

    public static FloatSpliterator wrap(float[] fArray, int n2, int n3, int n4) {
        FloatArrays.ensureOffsetLength(fArray, n2, n3);
        return new ArraySpliterator(fArray, n2, n3, n4);
    }

    public static FloatSpliterator wrapPreSorted(float[] fArray, int n2, int n3, int n4, FloatComparator floatComparator) {
        FloatArrays.ensureOffsetLength(fArray, n2, n3);
        return new ArraySpliteratorWithComparator(fArray, n2, n3, n4, floatComparator);
    }

    public static FloatSpliterator asSpliterator(FloatIterator floatIterator, long l2, int n2) {
        return new SpliteratorFromIterator(floatIterator, l2, n2);
    }

    public static FloatSpliterator asSpliteratorFromSorted(FloatIterator floatIterator, long l2, int n2, FloatComparator floatComparator) {
        return new SpliteratorFromIteratorWithComparator(floatIterator, l2, n2, floatComparator);
    }

    public static FloatSpliterator asSpliteratorUnknownSize(FloatIterator floatIterator, int n2) {
        return new SpliteratorFromIterator(floatIterator, n2);
    }

    private static class ArraySpliterator
    implements FloatSpliterator {
        final float[] array;
        private final int offset;
        private int length;
        private int curr;
        final int characteristics;

        public ArraySpliterator(float[] fArray, int n2, int n3, int n4) {
            this.array = fArray;
            this.offset = n2;
            this.length = n3;
            this.characteristics = 0x4150 | n4;
        }

        @Override
        public boolean tryAdvance(FloatConsumer floatConsumer) {
            if (this.curr >= this.length) {
                return false;
            }
            Objects.requireNonNull(floatConsumer);
            floatConsumer.accept(this.array[this.offset + this.curr++]);
            return true;
        }

        @Override
        public long estimateSize() {
            return this.length - this.curr;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        protected ArraySpliterator makeForSplit(int n2, int n3) {
            return new ArraySpliterator(this.array, n2, n3, this.characteristics);
        }

        @Override
        public FloatSpliterator trySplit() {
            int n2 = this.length - this.curr >> 1;
            if (n2 <= 1) {
                return null;
            }
            int n3 = this.curr + n2;
            int n4 = this.offset + this.curr;
            this.curr = n3;
            return this.makeForSplit(n4, n2);
        }

        @Override
        public void forEachRemaining(FloatConsumer floatConsumer) {
            Objects.requireNonNull(floatConsumer);
            float[] fArray = this.array;
            while (this.curr < this.length) {
                floatConsumer.accept(fArray[this.offset + this.curr]);
                ++this.curr;
            }
        }
    }

    private static class ArraySpliteratorWithComparator
    extends ArraySpliterator {
        private final FloatComparator comparator;

        public ArraySpliteratorWithComparator(float[] fArray, int n2, int n3, int n4, FloatComparator floatComparator) {
            super(fArray, n2, n3, n4 | 0x14);
            this.comparator = floatComparator;
        }

        @Override
        protected ArraySpliteratorWithComparator makeForSplit(int n2, int n3) {
            return new ArraySpliteratorWithComparator(this.array, n2, n3, this.characteristics, this.comparator);
        }

        @Override
        public FloatComparator getComparator() {
            return this.comparator;
        }
    }

    private static class SpliteratorFromIterator
    implements FloatSpliterator {
        private final FloatIterator iter;
        final int characteristics;
        private final boolean knownSize;
        private long size = Long.MAX_VALUE;
        private int nextBatchSize = 1024;
        private FloatSpliterator delegate = null;

        SpliteratorFromIterator(FloatIterator floatIterator, int n2) {
            this.iter = floatIterator;
            this.characteristics = 0x100 | n2;
            this.knownSize = false;
        }

        SpliteratorFromIterator(FloatIterator floatIterator, long l2, int n2) {
            this.iter = floatIterator;
            this.knownSize = true;
            this.size = l2;
            this.characteristics = (n2 & 0x1000) != 0 ? 0x100 | n2 : 0x4140 | n2;
        }

        @Override
        public boolean tryAdvance(FloatConsumer floatConsumer) {
            if (this.delegate != null) {
                boolean bl2 = this.delegate.tryAdvance(floatConsumer);
                if (!bl2) {
                    this.delegate = null;
                }
                return bl2;
            }
            if (!this.iter.hasNext()) {
                return false;
            }
            --this.size;
            floatConsumer.accept(this.iter.nextFloat());
            return true;
        }

        @Override
        public void forEachRemaining(FloatConsumer floatConsumer) {
            if (this.delegate != null) {
                this.delegate.forEachRemaining(floatConsumer);
                this.delegate = null;
            }
            this.iter.forEachRemaining(floatConsumer);
            this.size = 0L;
        }

        @Override
        public long estimateSize() {
            if (this.delegate != null) {
                return this.delegate.estimateSize();
            }
            if (!this.iter.hasNext()) {
                return 0L;
            }
            return this.knownSize && this.size >= 0L ? this.size : Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        protected FloatSpliterator makeForSplit(float[] fArray, int n2) {
            return FloatSpliterators.wrap(fArray, 0, n2, this.characteristics);
        }

        @Override
        public FloatSpliterator trySplit() {
            if (!this.iter.hasNext()) {
                return null;
            }
            int n2 = this.knownSize && this.size > 0L ? (int)Math.min((long)this.nextBatchSize, this.size) : this.nextBatchSize;
            float[] fArray = new float[n2];
            int n3 = 0;
            while (n3 < n2 && this.iter.hasNext()) {
                fArray[n3++] = this.iter.nextFloat();
                --this.size;
            }
            if (n2 < this.nextBatchSize && this.iter.hasNext()) {
                fArray = Arrays.copyOf(fArray, this.nextBatchSize);
                while (this.iter.hasNext() && n3 < this.nextBatchSize) {
                    fArray[n3++] = this.iter.nextFloat();
                    --this.size;
                }
            }
            this.nextBatchSize = Math.min(0x2000000, this.nextBatchSize + 1024);
            FloatSpliterator floatSpliterator = this.makeForSplit(fArray, n3);
            if (!this.iter.hasNext()) {
                this.delegate = floatSpliterator;
                return floatSpliterator.trySplit();
            }
            return floatSpliterator;
        }
    }

    private static class SpliteratorFromIteratorWithComparator
    extends SpliteratorFromIterator {
        private final FloatComparator comparator;

        SpliteratorFromIteratorWithComparator(FloatIterator floatIterator, long l2, int n2, FloatComparator floatComparator) {
            super(floatIterator, l2, n2 | 0x14);
            this.comparator = floatComparator;
        }

        @Override
        public FloatComparator getComparator() {
            return this.comparator;
        }

        @Override
        protected FloatSpliterator makeForSplit(float[] fArray, int n2) {
            return FloatSpliterators.wrapPreSorted(fArray, 0, n2, this.characteristics, this.comparator);
        }
    }

    public static class EmptySpliterator
    implements FloatSpliterator,
    Serializable,
    Cloneable {
        protected EmptySpliterator() {
        }

        @Override
        public boolean tryAdvance(FloatConsumer floatConsumer) {
            return false;
        }

        @Override
        @Deprecated
        public boolean tryAdvance(Consumer<? super Float> consumer) {
            return false;
        }

        @Override
        public FloatSpliterator trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return 0L;
        }

        @Override
        public int characteristics() {
            return 16448;
        }

        @Override
        public void forEachRemaining(FloatConsumer floatConsumer) {
        }

        @Override
        @Deprecated
        public void forEachRemaining(Consumer<? super Float> consumer) {
        }

        public Object clone() {
            return EMPTY_SPLITERATOR;
        }
    }

    public static abstract class LateBindingSizeIndexBasedSpliterator
    extends AbstractIndexBasedSpliterator {
        protected int maxPos = -1;
        private boolean maxPosFixed;

        protected LateBindingSizeIndexBasedSpliterator(int n2) {
            super(n2);
            this.maxPosFixed = false;
        }

        protected LateBindingSizeIndexBasedSpliterator(int n2, int n3) {
            super(n2);
            this.maxPos = n3;
            this.maxPosFixed = true;
        }

        protected abstract int getMaxPosFromBackingStore();

        @Override
        protected final int getMaxPos() {
            return this.maxPosFixed ? this.maxPos : this.getMaxPosFromBackingStore();
        }

        @Override
        public FloatSpliterator trySplit() {
            FloatSpliterator floatSpliterator = super.trySplit();
            if (!this.maxPosFixed && floatSpliterator != null) {
                this.maxPos = this.getMaxPosFromBackingStore();
                this.maxPosFixed = true;
            }
            return floatSpliterator;
        }
    }

    public static abstract class AbstractIndexBasedSpliterator
    extends AbstractFloatSpliterator {
        protected int pos;

        protected AbstractIndexBasedSpliterator(int n2) {
            this.pos = n2;
        }

        protected abstract float get(int var1);

        protected abstract int getMaxPos();

        protected abstract FloatSpliterator makeForSplit(int var1, int var2);

        protected int computeSplitPoint() {
            return this.pos + (this.getMaxPos() - this.pos) / 2;
        }

        private void splitPointCheck(int n2, int n3) {
            if (n2 < this.pos || n2 > n3) {
                throw new IndexOutOfBoundsException("splitPoint " + n2 + " outside of range of current position " + this.pos + " and range end " + n3);
            }
        }

        @Override
        public int characteristics() {
            return 16720;
        }

        @Override
        public long estimateSize() {
            return (long)this.getMaxPos() - (long)this.pos;
        }

        @Override
        public boolean tryAdvance(FloatConsumer floatConsumer) {
            if (this.pos >= this.getMaxPos()) {
                return false;
            }
            floatConsumer.accept(this.get(this.pos++));
            return true;
        }

        @Override
        public void forEachRemaining(FloatConsumer floatConsumer) {
            int n2 = this.getMaxPos();
            while (this.pos < n2) {
                floatConsumer.accept(this.get(this.pos));
                ++this.pos;
            }
        }

        @Override
        public FloatSpliterator trySplit() {
            int n2 = this.getMaxPos();
            int n3 = this.computeSplitPoint();
            if (n3 == this.pos || n3 == n2) {
                return null;
            }
            this.splitPointCheck(n3, n2);
            int n4 = this.pos;
            FloatSpliterator floatSpliterator = this.makeForSplit(n4, n3);
            if (floatSpliterator != null) {
                this.pos = n3;
            }
            return floatSpliterator;
        }
    }
}

