/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.AbstractByteSpliterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteArrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteComparator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteConsumer;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteSpliterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;

public final class ByteSpliterators {
    public static final EmptySpliterator EMPTY_SPLITERATOR = new EmptySpliterator();

    public static ByteSpliterator wrap(byte[] byArray, int n2, int n3, int n4) {
        ByteArrays.ensureOffsetLength(byArray, n2, n3);
        return new ArraySpliterator(byArray, n2, n3, n4);
    }

    public static ByteSpliterator wrapPreSorted(byte[] byArray, int n2, int n3, int n4, ByteComparator byteComparator) {
        ByteArrays.ensureOffsetLength(byArray, n2, n3);
        return new ArraySpliteratorWithComparator(byArray, n2, n3, n4, byteComparator);
    }

    public static ByteSpliterator asSpliterator(ByteIterator byteIterator, long l2, int n2) {
        return new SpliteratorFromIterator(byteIterator, l2, n2);
    }

    public static ByteSpliterator asSpliteratorFromSorted(ByteIterator byteIterator, long l2, int n2, ByteComparator byteComparator) {
        return new SpliteratorFromIteratorWithComparator(byteIterator, l2, n2, byteComparator);
    }

    public static ByteSpliterator asSpliteratorUnknownSize(ByteIterator byteIterator, int n2) {
        return new SpliteratorFromIterator(byteIterator, n2);
    }

    private static class ArraySpliterator
    implements ByteSpliterator {
        final byte[] array;
        private final int offset;
        private int length;
        private int curr;
        final int characteristics;

        public ArraySpliterator(byte[] byArray, int n2, int n3, int n4) {
            this.array = byArray;
            this.offset = n2;
            this.length = n3;
            this.characteristics = 0x4150 | n4;
        }

        @Override
        public boolean tryAdvance(ByteConsumer byteConsumer) {
            if (this.curr >= this.length) {
                return false;
            }
            Objects.requireNonNull(byteConsumer);
            byteConsumer.accept(this.array[this.offset + this.curr++]);
            return true;
        }

        @Override
        public long estimateSize() {
            return this.length - this.curr;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        protected ArraySpliterator makeForSplit(int n2, int n3) {
            return new ArraySpliterator(this.array, n2, n3, this.characteristics);
        }

        @Override
        public ByteSpliterator trySplit() {
            int n2 = this.length - this.curr >> 1;
            if (n2 <= 1) {
                return null;
            }
            int n3 = this.curr + n2;
            int n4 = this.offset + this.curr;
            this.curr = n3;
            return this.makeForSplit(n4, n2);
        }

        @Override
        public void forEachRemaining(ByteConsumer byteConsumer) {
            Objects.requireNonNull(byteConsumer);
            byte[] byArray = this.array;
            while (this.curr < this.length) {
                byteConsumer.accept(byArray[this.offset + this.curr]);
                ++this.curr;
            }
        }
    }

    private static class ArraySpliteratorWithComparator
    extends ArraySpliterator {
        private final ByteComparator comparator;

        public ArraySpliteratorWithComparator(byte[] byArray, int n2, int n3, int n4, ByteComparator byteComparator) {
            super(byArray, n2, n3, n4 | 0x14);
            this.comparator = byteComparator;
        }

        @Override
        protected ArraySpliteratorWithComparator makeForSplit(int n2, int n3) {
            return new ArraySpliteratorWithComparator(this.array, n2, n3, this.characteristics, this.comparator);
        }

        @Override
        public ByteComparator getComparator() {
            return this.comparator;
        }
    }

    private static class SpliteratorFromIterator
    implements ByteSpliterator {
        private final ByteIterator iter;
        final int characteristics;
        private final boolean knownSize;
        private long size = Long.MAX_VALUE;
        private int nextBatchSize = 1024;
        private ByteSpliterator delegate = null;

        SpliteratorFromIterator(ByteIterator byteIterator, int n2) {
            this.iter = byteIterator;
            this.characteristics = 0x100 | n2;
            this.knownSize = false;
        }

        SpliteratorFromIterator(ByteIterator byteIterator, long l2, int n2) {
            this.iter = byteIterator;
            this.knownSize = true;
            this.size = l2;
            this.characteristics = (n2 & 0x1000) != 0 ? 0x100 | n2 : 0x4140 | n2;
        }

        @Override
        public boolean tryAdvance(ByteConsumer byteConsumer) {
            if (this.delegate != null) {
                boolean bl2 = this.delegate.tryAdvance(byteConsumer);
                if (!bl2) {
                    this.delegate = null;
                }
                return bl2;
            }
            if (!this.iter.hasNext()) {
                return false;
            }
            --this.size;
            byteConsumer.accept(this.iter.nextByte());
            return true;
        }

        @Override
        public void forEachRemaining(ByteConsumer byteConsumer) {
            if (this.delegate != null) {
                this.delegate.forEachRemaining(byteConsumer);
                this.delegate = null;
            }
            this.iter.forEachRemaining(byteConsumer);
            this.size = 0L;
        }

        @Override
        public long estimateSize() {
            if (this.delegate != null) {
                return this.delegate.estimateSize();
            }
            if (!this.iter.hasNext()) {
                return 0L;
            }
            return this.knownSize && this.size >= 0L ? this.size : Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        protected ByteSpliterator makeForSplit(byte[] byArray, int n2) {
            return ByteSpliterators.wrap(byArray, 0, n2, this.characteristics);
        }

        @Override
        public ByteSpliterator trySplit() {
            if (!this.iter.hasNext()) {
                return null;
            }
            int n2 = this.knownSize && this.size > 0L ? (int)Math.min((long)this.nextBatchSize, this.size) : this.nextBatchSize;
            byte[] byArray = new byte[n2];
            int n3 = 0;
            while (n3 < n2 && this.iter.hasNext()) {
                byArray[n3++] = this.iter.nextByte();
                --this.size;
            }
            if (n2 < this.nextBatchSize && this.iter.hasNext()) {
                byArray = Arrays.copyOf(byArray, this.nextBatchSize);
                while (this.iter.hasNext() && n3 < this.nextBatchSize) {
                    byArray[n3++] = this.iter.nextByte();
                    --this.size;
                }
            }
            this.nextBatchSize = Math.min(0x2000000, this.nextBatchSize + 1024);
            ByteSpliterator byteSpliterator = this.makeForSplit(byArray, n3);
            if (!this.iter.hasNext()) {
                this.delegate = byteSpliterator;
                return byteSpliterator.trySplit();
            }
            return byteSpliterator;
        }
    }

    private static class SpliteratorFromIteratorWithComparator
    extends SpliteratorFromIterator {
        private final ByteComparator comparator;

        SpliteratorFromIteratorWithComparator(ByteIterator byteIterator, long l2, int n2, ByteComparator byteComparator) {
            super(byteIterator, l2, n2 | 0x14);
            this.comparator = byteComparator;
        }

        @Override
        public ByteComparator getComparator() {
            return this.comparator;
        }

        @Override
        protected ByteSpliterator makeForSplit(byte[] byArray, int n2) {
            return ByteSpliterators.wrapPreSorted(byArray, 0, n2, this.characteristics, this.comparator);
        }
    }

    public static class EmptySpliterator
    implements ByteSpliterator,
    Serializable,
    Cloneable {
        protected EmptySpliterator() {
        }

        @Override
        public boolean tryAdvance(ByteConsumer byteConsumer) {
            return false;
        }

        @Override
        @Deprecated
        public boolean tryAdvance(Consumer<? super Byte> consumer) {
            return false;
        }

        @Override
        public ByteSpliterator trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return 0L;
        }

        @Override
        public int characteristics() {
            return 16448;
        }

        @Override
        public void forEachRemaining(ByteConsumer byteConsumer) {
        }

        @Override
        @Deprecated
        public void forEachRemaining(Consumer<? super Byte> consumer) {
        }

        public Object clone() {
            return EMPTY_SPLITERATOR;
        }
    }

    public static abstract class LateBindingSizeIndexBasedSpliterator
    extends AbstractIndexBasedSpliterator {
        protected int maxPos = -1;
        private boolean maxPosFixed;

        protected LateBindingSizeIndexBasedSpliterator(int n2) {
            super(n2);
            this.maxPosFixed = false;
        }

        protected LateBindingSizeIndexBasedSpliterator(int n2, int n3) {
            super(n2);
            this.maxPos = n3;
            this.maxPosFixed = true;
        }

        protected abstract int getMaxPosFromBackingStore();

        @Override
        protected final int getMaxPos() {
            return this.maxPosFixed ? this.maxPos : this.getMaxPosFromBackingStore();
        }

        @Override
        public ByteSpliterator trySplit() {
            ByteSpliterator byteSpliterator = super.trySplit();
            if (!this.maxPosFixed && byteSpliterator != null) {
                this.maxPos = this.getMaxPosFromBackingStore();
                this.maxPosFixed = true;
            }
            return byteSpliterator;
        }
    }

    public static abstract class AbstractIndexBasedSpliterator
    extends AbstractByteSpliterator {
        protected int pos;

        protected AbstractIndexBasedSpliterator(int n2) {
            this.pos = n2;
        }

        protected abstract byte get(int var1);

        protected abstract int getMaxPos();

        protected abstract ByteSpliterator makeForSplit(int var1, int var2);

        protected int computeSplitPoint() {
            return this.pos + (this.getMaxPos() - this.pos) / 2;
        }

        private void splitPointCheck(int n2, int n3) {
            if (n2 < this.pos || n2 > n3) {
                throw new IndexOutOfBoundsException("splitPoint " + n2 + " outside of range of current position " + this.pos + " and range end " + n3);
            }
        }

        @Override
        public int characteristics() {
            return 16720;
        }

        @Override
        public long estimateSize() {
            return (long)this.getMaxPos() - (long)this.pos;
        }

        @Override
        public boolean tryAdvance(ByteConsumer byteConsumer) {
            if (this.pos >= this.getMaxPos()) {
                return false;
            }
            byteConsumer.accept(this.get(this.pos++));
            return true;
        }

        @Override
        public void forEachRemaining(ByteConsumer byteConsumer) {
            int n2 = this.getMaxPos();
            while (this.pos < n2) {
                byteConsumer.accept(this.get(this.pos));
                ++this.pos;
            }
        }

        @Override
        public ByteSpliterator trySplit() {
            int n2 = this.getMaxPos();
            int n3 = this.computeSplitPoint();
            if (n3 == this.pos || n3 == n2) {
                return null;
            }
            this.splitPointCheck(n3, n2);
            int n4 = this.pos;
            ByteSpliterator byteSpliterator = this.makeForSplit(n4, n3);
            if (byteSpliterator != null) {
                this.pos = n3;
            }
            return byteSpliterator;
        }
    }
}

