/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.Size64;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.AbstractByteList;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteArrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteCollection;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteComparator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteComparators;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteListIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteSpliterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteSpliterators;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteUnaryOperator;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.UnaryOperator;

public interface ByteList
extends ByteCollection,
Comparable<List<? extends Byte>>,
List<Byte> {
    @Override
    public ByteListIterator iterator();

    @Override
    default public ByteSpliterator spliterator() {
        if (this instanceof RandomAccess) {
            return new AbstractByteList.IndexBasedSpliterator(this, 0);
        }
        return ByteSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 16720);
    }

    public ByteListIterator listIterator();

    public ByteListIterator listIterator(int var1);

    public ByteList subList(int var1, int var2);

    public void getElements(int var1, byte[] var2, int var3, int var4);

    public void removeElements(int var1, int var2);

    default public void setElements(byte[] byArray) {
        this.setElements(0, byArray);
    }

    default public void setElements(int n2, byte[] byArray) {
        this.setElements(n2, byArray, 0, byArray.length);
    }

    default public void setElements(int n2, byte[] byArray, int n3, int n4) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than list size (" + this.size() + ")");
        }
        ByteArrays.ensureOffsetLength(byArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        ByteListIterator byteListIterator = this.listIterator(n2);
        int n5 = 0;
        while (n5 < n4) {
            byteListIterator.nextByte();
            byteListIterator.set(byArray[n3 + n5++]);
        }
    }

    @Override
    public boolean add(byte var1);

    @Override
    public void add(int var1, byte var2);

    @Override
    @Deprecated
    default public void add(int n2, Byte by2) {
        this.add(n2, (byte)by2);
    }

    @Override
    public byte set(int var1, byte var2);

    default public void replaceAll(ByteUnaryOperator byteUnaryOperator) {
        ByteListIterator byteListIterator = this.listIterator();
        while (byteListIterator.hasNext()) {
            byteListIterator.set(byteUnaryOperator.apply(byteListIterator.nextByte()));
        }
    }

    @Override
    @Deprecated
    default public void replaceAll(UnaryOperator<Byte> unaryOperator) {
        Objects.requireNonNull(unaryOperator);
        this.replaceAll(unaryOperator instanceof ByteUnaryOperator ? (ByteUnaryOperator)unaryOperator : unaryOperator::apply);
    }

    public byte getByte(int var1);

    public int indexOf(byte var1);

    public int lastIndexOf(byte var1);

    @Override
    @Deprecated
    default public boolean contains(Object object) {
        return ByteCollection.super.contains(object);
    }

    @Override
    @Deprecated
    default public Byte get(int n2) {
        return this.getByte(n2);
    }

    @Override
    @Deprecated
    default public int indexOf(Object object) {
        return this.indexOf((Byte)object);
    }

    @Override
    @Deprecated
    default public int lastIndexOf(Object object) {
        return this.lastIndexOf((Byte)object);
    }

    @Override
    @Deprecated
    default public boolean add(Byte by2) {
        return this.add((byte)by2);
    }

    public byte removeByte(int var1);

    @Override
    @Deprecated
    default public boolean remove(Object object) {
        return ByteCollection.super.remove(object);
    }

    @Override
    @Deprecated
    default public Byte remove(int n2) {
        return this.removeByte(n2);
    }

    @Override
    @Deprecated
    default public Byte set(int n2, Byte by2) {
        return this.set(n2, (byte)by2);
    }

    @Override
    @Deprecated
    default public void sort(Comparator<? super Byte> comparator) {
        this.sort(ByteComparators.asByteComparator(comparator));
    }

    default public void sort(ByteComparator byteComparator) {
        if (byteComparator == null) {
            this.unstableSort(byteComparator);
        } else {
            byte[] byArray = this.toByteArray();
            ByteArrays.stableSort(byArray, byteComparator);
            this.setElements(byArray);
        }
    }

    default public void unstableSort(ByteComparator byteComparator) {
        byte[] byArray = this.toByteArray();
        if (byteComparator == null) {
            ByteArrays.unstableSort(byArray);
        } else {
            ByteArrays.unstableSort(byArray, byteComparator);
        }
        this.setElements(byArray);
    }
}

