/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.AbstractByteCollection;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteArrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteCollection;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteConsumer;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteIterators;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteList;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteListIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteSpliterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.bytes.ByteSpliterators;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;

public abstract class AbstractByteList
extends AbstractByteCollection
implements ByteList {
    protected AbstractByteList() {
    }

    protected void ensureIndex(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    @Override
    public void add(int n2, byte by2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(byte by2) {
        this.add(this.size(), by2);
        return true;
    }

    @Override
    public byte removeByte(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte set(int n2, byte by2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int n2, Collection<? extends Byte> collection) {
        if (collection instanceof ByteCollection) {
            return this.addAll(n2, (ByteCollection)collection);
        }
        this.ensureIndex(n2);
        Iterator<? extends Byte> iterator = collection.iterator();
        boolean bl2 = iterator.hasNext();
        while (iterator.hasNext()) {
            this.add(n2++, (byte)iterator.next());
        }
        return bl2;
    }

    @Override
    public boolean addAll(Collection<? extends Byte> collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public ByteListIterator iterator() {
        return this.listIterator();
    }

    @Override
    public ByteListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ByteListIterator listIterator(int n2) {
        this.ensureIndex(n2);
        return new ByteIterators.AbstractIndexBasedListIterator(0, n2){

            @Override
            protected final byte get(int n2) {
                return AbstractByteList.this.getByte(n2);
            }

            @Override
            protected final void add(int n2, byte by2) {
                AbstractByteList.this.add(n2, by2);
            }

            @Override
            protected final void set(int n2, byte by2) {
                AbstractByteList.this.set(n2, by2);
            }

            @Override
            protected final void remove(int n2) {
                AbstractByteList.this.removeByte(n2);
            }

            @Override
            protected final int getMaxPos() {
                return AbstractByteList.this.size();
            }
        };
    }

    @Override
    public boolean contains(byte by2) {
        return this.indexOf(by2) >= 0;
    }

    @Override
    public int indexOf(byte by2) {
        ByteListIterator byteListIterator = this.listIterator();
        while (byteListIterator.hasNext()) {
            byte by3 = byteListIterator.nextByte();
            if (by2 != by3) continue;
            return byteListIterator.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(byte by2) {
        ByteListIterator byteListIterator = this.listIterator(this.size());
        while (byteListIterator.hasPrevious()) {
            byte by3 = byteListIterator.previousByte();
            if (by2 != by3) continue;
            return byteListIterator.nextIndex();
        }
        return -1;
    }

    @Override
    public ByteList subList(int n2, int n3) {
        this.ensureIndex(n2);
        this.ensureIndex(n3);
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
        }
        return this instanceof RandomAccess ? new ByteRandomAccessSubList(this, n2, n3) : new ByteSubList(this, n2, n3);
    }

    @Override
    public void forEach(ByteConsumer byteConsumer) {
        if (this instanceof RandomAccess) {
            int n2 = this.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                byteConsumer.accept(this.getByte(i2));
            }
        } else {
            ByteList.super.forEach(byteConsumer);
        }
    }

    @Override
    public void removeElements(int n2, int n3) {
        this.ensureIndex(n3);
        ByteListIterator byteListIterator = this.listIterator(n2);
        int n4 = n3 - n2;
        if (n4 < 0) {
            throw new IllegalArgumentException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
        }
        while (n4-- != 0) {
            byteListIterator.nextByte();
            byteListIterator.remove();
        }
    }

    @Override
    public void getElements(int n2, byte[] byArray, int n3, int n4) {
        this.ensureIndex(n2);
        ByteArrays.ensureOffsetLength(byArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        if (this instanceof RandomAccess) {
            int n5 = n2;
            while (n4-- != 0) {
                byArray[n3++] = this.getByte(n5++);
            }
        } else {
            ByteListIterator byteListIterator = this.listIterator(n2);
            while (n4-- != 0) {
                byArray[n3++] = byteListIterator.nextByte();
            }
        }
    }

    @Override
    public void setElements(int n2, byte[] byArray, int n3, int n4) {
        this.ensureIndex(n2);
        ByteArrays.ensureOffsetLength(byArray, n3, n4);
        if (n2 + n4 > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size() + ")");
        }
        if (this instanceof RandomAccess) {
            for (int i2 = 0; i2 < n4; ++i2) {
                this.set(i2 + n2, byArray[i2 + n3]);
            }
        } else {
            ByteListIterator byteListIterator = this.listIterator(n2);
            int n5 = 0;
            while (n5 < n4) {
                byteListIterator.nextByte();
                byteListIterator.set(byArray[n3 + n5++]);
            }
        }
    }

    @Override
    public void clear() {
        this.removeElements(0, this.size());
    }

    @Override
    public int hashCode() {
        ByteListIterator byteListIterator = this.iterator();
        int n2 = 1;
        int n3 = this.size();
        while (n3-- != 0) {
            byte by2 = byteListIterator.nextByte();
            n2 = 31 * n2 + by2;
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        int n2 = this.size();
        if (n2 != list.size()) {
            return false;
        }
        if (list instanceof ByteList) {
            ByteListIterator byteListIterator = this.listIterator();
            ByteListIterator byteListIterator2 = ((ByteList)list).listIterator();
            while (n2-- != 0) {
                if (byteListIterator.nextByte() == byteListIterator2.nextByte()) continue;
                return false;
            }
            return true;
        }
        ByteListIterator byteListIterator = this.listIterator();
        ListIterator listIterator = list.listIterator();
        while (n2-- != 0) {
            if (Objects.equals(byteListIterator.next(), listIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(List<? extends Byte> list) {
        if (list == this) {
            return 0;
        }
        if (list instanceof ByteList) {
            ByteListIterator byteListIterator = this.listIterator();
            ByteListIterator byteListIterator2 = ((ByteList)list).listIterator();
            while (byteListIterator.hasNext() && byteListIterator2.hasNext()) {
                byte by2;
                byte by3 = byteListIterator.nextByte();
                int n2 = Byte.compare(by3, by2 = byteListIterator2.nextByte());
                if (n2 == 0) continue;
                return n2;
            }
            return byteListIterator2.hasNext() ? -1 : (byteListIterator.hasNext() ? 1 : 0);
        }
        ByteListIterator byteListIterator = this.listIterator();
        ListIterator<? extends Byte> listIterator = list.listIterator();
        while (byteListIterator.hasNext() && listIterator.hasNext()) {
            int n3 = ((Comparable)byteListIterator.next()).compareTo(listIterator.next());
            if (n3 == 0) continue;
            return n3;
        }
        return listIterator.hasNext() ? -1 : (byteListIterator.hasNext() ? 1 : 0);
    }

    @Override
    public boolean rem(byte by2) {
        int n2 = this.indexOf(by2);
        if (n2 == -1) {
            return false;
        }
        this.removeByte(n2);
        return true;
    }

    @Override
    public byte[] toByteArray() {
        int n2 = this.size();
        if (n2 == 0) {
            return ByteArrays.EMPTY_ARRAY;
        }
        byte[] byArray = new byte[n2];
        this.getElements(0, byArray, 0, n2);
        return byArray;
    }

    public boolean addAll(int n2, ByteCollection byteCollection) {
        this.ensureIndex(n2);
        ByteIterator byteIterator = byteCollection.iterator();
        boolean bl2 = byteIterator.hasNext();
        while (byteIterator.hasNext()) {
            this.add(n2++, byteIterator.nextByte());
        }
        return bl2;
    }

    @Override
    public boolean addAll(ByteCollection byteCollection) {
        return this.addAll(this.size(), byteCollection);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        ByteListIterator byteListIterator = this.iterator();
        int n2 = this.size();
        boolean bl2 = true;
        stringBuilder.append("[");
        while (n2-- != 0) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(", ");
            }
            byte by2 = byteListIterator.nextByte();
            stringBuilder.append(String.valueOf(by2));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static class ByteRandomAccessSubList
    extends ByteSubList
    implements RandomAccess {
        public ByteRandomAccessSubList(ByteList byteList, int n2, int n3) {
            super(byteList, n2, n3);
        }

        @Override
        public ByteList subList(int n2, int n3) {
            this.ensureIndex(n2);
            this.ensureIndex(n3);
            if (n2 > n3) {
                throw new IllegalArgumentException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
            }
            return new ByteRandomAccessSubList(this, n2, n3);
        }
    }

    public static class ByteSubList
    extends AbstractByteList
    implements Serializable {
        protected final ByteList l;
        protected final int from;
        protected int to;

        public ByteSubList(ByteList byteList, int n2, int n3) {
            this.l = byteList;
            this.from = n2;
            this.to = n3;
        }

        private boolean assertRange() {
            assert (this.from <= this.l.size());
            assert (this.to <= this.l.size());
            assert (this.to >= this.from);
            return true;
        }

        @Override
        public boolean add(byte by2) {
            this.l.add(this.to, by2);
            ++this.to;
            assert (this.assertRange());
            return true;
        }

        @Override
        public void add(int n2, byte by2) {
            this.ensureIndex(n2);
            this.l.add(this.from + n2, by2);
            ++this.to;
            assert (this.assertRange());
        }

        @Override
        public boolean addAll(int n2, Collection<? extends Byte> collection) {
            this.ensureIndex(n2);
            this.to += collection.size();
            return this.l.addAll(this.from + n2, collection);
        }

        @Override
        public byte getByte(int n2) {
            this.ensureRestrictedIndex(n2);
            return this.l.getByte(this.from + n2);
        }

        @Override
        public byte removeByte(int n2) {
            this.ensureRestrictedIndex(n2);
            --this.to;
            return this.l.removeByte(this.from + n2);
        }

        @Override
        public byte set(int n2, byte by2) {
            this.ensureRestrictedIndex(n2);
            return this.l.set(this.from + n2, by2);
        }

        @Override
        public int size() {
            return this.to - this.from;
        }

        @Override
        public void getElements(int n2, byte[] byArray, int n3, int n4) {
            this.ensureIndex(n2);
            if (n2 + n4 > this.size()) {
                throw new IndexOutOfBoundsException("End index (" + n2 + n4 + ") is greater than list size (" + this.size() + ")");
            }
            this.l.getElements(this.from + n2, byArray, n3, n4);
        }

        @Override
        public void removeElements(int n2, int n3) {
            this.ensureIndex(n2);
            this.ensureIndex(n3);
            this.l.removeElements(this.from + n2, this.from + n3);
            this.to -= n3 - n2;
            assert (this.assertRange());
        }

        @Override
        public void setElements(int n2, byte[] byArray, int n3, int n4) {
            this.ensureIndex(n2);
            this.l.setElements(this.from + n2, byArray, n3, n4);
            assert (this.assertRange());
        }

        @Override
        public ByteListIterator listIterator(int n2) {
            this.ensureIndex(n2);
            return this.l instanceof RandomAccess ? new RandomAccessIter(n2) : new ParentWrappingIter(this.l.listIterator(n2 + this.from));
        }

        @Override
        public ByteSpliterator spliterator() {
            return this.l instanceof RandomAccess ? new IndexBasedSpliterator(this.l, this.from, this.to) : super.spliterator();
        }

        @Override
        public ByteList subList(int n2, int n3) {
            this.ensureIndex(n2);
            this.ensureIndex(n3);
            if (n2 > n3) {
                throw new IllegalArgumentException("Start index (" + n2 + ") is greater than end index (" + n3 + ")");
            }
            return new ByteSubList(this, n2, n3);
        }

        @Override
        public boolean rem(byte by2) {
            int n2 = this.indexOf(by2);
            if (n2 == -1) {
                return false;
            }
            --this.to;
            this.l.removeByte(this.from + n2);
            assert (this.assertRange());
            return true;
        }

        @Override
        public boolean addAll(int n2, ByteCollection byteCollection) {
            this.ensureIndex(n2);
            return super.addAll(n2, byteCollection);
        }

        private final class RandomAccessIter
        extends ByteIterators.AbstractIndexBasedListIterator {
            RandomAccessIter(int n2) {
                super(0, n2);
            }

            @Override
            protected final byte get(int n2) {
                return ByteSubList.this.l.getByte(ByteSubList.this.from + n2);
            }

            @Override
            protected final void add(int n2, byte by2) {
                ByteSubList.this.add(n2, by2);
            }

            @Override
            protected final void set(int n2, byte by2) {
                ByteSubList.this.set(n2, by2);
            }

            @Override
            protected final void remove(int n2) {
                ByteSubList.this.removeByte(n2);
            }

            @Override
            protected final int getMaxPos() {
                return ByteSubList.this.to - ByteSubList.this.from;
            }

            @Override
            public void add(byte by2) {
                super.add(by2);
                assert (ByteSubList.this.assertRange());
            }

            @Override
            public void remove() {
                super.remove();
                assert (ByteSubList.this.assertRange());
            }
        }

        private class ParentWrappingIter
        implements ByteListIterator {
            private ByteListIterator parent;

            ParentWrappingIter(ByteListIterator byteListIterator) {
                this.parent = byteListIterator;
            }

            @Override
            public int nextIndex() {
                return this.parent.nextIndex() - ByteSubList.this.from;
            }

            @Override
            public int previousIndex() {
                return this.parent.previousIndex() - ByteSubList.this.from;
            }

            @Override
            public boolean hasNext() {
                return this.parent.nextIndex() < ByteSubList.this.to;
            }

            @Override
            public boolean hasPrevious() {
                return this.parent.previousIndex() >= ByteSubList.this.from;
            }

            @Override
            public byte nextByte() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.parent.nextByte();
            }

            @Override
            public byte previousByte() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                return this.parent.previousByte();
            }

            @Override
            public void add(byte by2) {
                this.parent.add(by2);
            }

            @Override
            public void set(byte by2) {
                this.parent.set(by2);
            }

            @Override
            public void remove() {
                this.parent.remove();
            }
        }
    }

    static final class IndexBasedSpliterator
    extends ByteSpliterators.LateBindingSizeIndexBasedSpliterator {
        final ByteList l;

        IndexBasedSpliterator(ByteList byteList, int n2) {
            super(n2);
            this.l = byteList;
        }

        IndexBasedSpliterator(ByteList byteList, int n2, int n3) {
            super(n2, n3);
            this.l = byteList;
        }

        @Override
        protected final int getMaxPosFromBackingStore() {
            return this.l.size();
        }

        @Override
        protected final byte get(int n2) {
            return this.l.getByte(n2);
        }

        @Override
        protected final IndexBasedSpliterator makeForSplit(int n2, int n3) {
            return new IndexBasedSpliterator(this.l, n2, n3);
        }
    }
}

